/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import utils.message.Message;
import utils.osstats.AbstractStats;
import utils.osstats.Stats;
import utils.osstats.winutils.WMIRegistry;
import utils.osstats.winutils.WMIResults;
import utils.osstats.winutils.WMIUtils;
import utils.osstats.winutils.WmicUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.PrintingUtil;
import utils.string.CharStack;
import utils.string.Chunker;

public class WindowsStats
extends AbstractStats {
    private static String[] light_commands = new String[]{"SELECT PercentProcessorTime FROM Win32_PerfFormattedData_PerfOS_Processor WHERE Name='_Total'", "SELECT AvailableBytes FROM Win32_PerfFormattedData_PerfOS_Memory"};
    private static String[] std_commands = new String[]{"SELECT PercentProcessorTime FROM Win32_PerfFormattedData_PerfOS_Processor WHERE Name='_Total'", "SELECT AvailableBytes FROM Win32_PerfFormattedData_PerfOS_Memory", "SELECT PercentDiskTime FROM Win32_PerfFormattedData_PerfDisk_PhysicalDisk", "SELECT Name,FreeMegabytes,PercentFreeSpace,PercentFreeSpace_Base FROM Win32_PerfRawData_PerfDisk_LogicalDisk", "SELECT IDProcess,Name,WorkingSet FROM Win32_PerfFormattedData_PerfProc_Process", "SELECT IDProcess,PercentProcessorTime,Timestamp_Sys100NS FROM Win32_PerfRawData_PerfProc_Process", "SELECT Name,CommandLine,ProcessId FROM Win32_Process", "SELECT EstimatedChargeRemaining FROM Win32_Battery"};
    private static String[] nonwmic_commands = new String[]{"netsh wlan show interfaces"};
    private static String[] delayed_commands = new String[]{"SELECT IDProcess,PercentProcessorTime,Timestamp_Sys100NS FROM Win32_PerfRawData_PerfProc_Process"};

    public WindowsStats() {
        super(false, false);
    }

    public WindowsStats(boolean fake, boolean memoryOnly) {
        super(fake, memoryOnly);
    }

    public WindowsStats(Message loadFromMessage) {
        this.loadFromMessage(loadFromMessage);
    }

    private String[] runNonWmicCommands(String[] commands) {
        String[] rets = new String[commands.length];
        for (int i = 0; i < rets.length; ++i) {
            try {
                String command = commands[i];
                rets[i] = RunCommandGetOutput.runCommandGetOutput(command)[0];
                continue;
            }
            catch (Exception x) {
                System.out.println("[WindowsStats] Failed to run " + commands[i] + ": " + x);
                rets[i] = "";
            }
        }
        return rets;
    }

    private WMIResults[] runCommands(String[] commands, int attempts) {
        ArrayList<WMIResults> results = new ArrayList<WMIResults>();
        for (String command : commands) {
            results.add(WMIRegistry.getProvider().queryWMI(command));
        }
        return results.toArray(new WMIResults[0]);
    }

    private static Stats.ProcessStatistic getProcessByID(ArrayList<Stats.ProcessStatistic> processList, String id) {
        for (Stats.ProcessStatistic s : processList) {
            if (!s.id.equals(id)) continue;
            return s;
        }
        return null;
    }

    private boolean isRecoveryPartition(String volumeName) {
        return volumeName.toUpperCase().contains("RECOVE");
    }

    private boolean isSharedFoldersPartition(String volumeName) {
        return volumeName.toUpperCase().contains("SHARED FOLDERS");
    }

    @Override
    public void updateLight() {
        if (this.isFake) {
            Random r = new Random();
            this.usedMemoryBytes = (long)(r.nextDouble() * (double)this.basicInfo.memoryTotalBytes);
            this.cpuPercentage = Math.random() * 95.0;
            return;
        }
        WMIResults[] rets = this.runCommands(light_commands, 10);
        try {
            this.cpuPercentage = Integer.parseInt(WMIUtils.getOnlyValue(rets[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            long tmp = Long.parseLong(WMIUtils.getOnlyValue(rets[1]));
            this.usedMemoryBytes = this.basicInfo.memoryTotalBytes - tmp;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update() {
        String ID;
        int freeMegabytes;
        if (this.isFake) {
            Random r = new Random();
            this.usedMemoryBytes = (long)(r.nextDouble() * (double)this.basicInfo.memoryTotalBytes);
            this.cpuPercentage = Math.random() * 95.0;
            this.diskSpaceStatistics = new Stats.DiskSpaceStatistic[0];
            this.processStatistics = new Stats.ProcessStatistic[0];
            this.wifiPercentage = Math.random() * 75.0;
            this.wifiMbit = 9.0 + Math.random() * 50.0;
            this.batteryPercentage = 75;
            return;
        }
        WMIResults[] rets = this.runCommands(std_commands, 10);
        String[] nonwmicrets = this.runNonWmicCommands(nonwmic_commands);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        WMIResults[] dels = this.runCommands(delayed_commands, 10);
        try {
            if (rets[0] != null && rets[0].hasProperties()) {
                this.cpuPercentage = Integer.parseInt(WMIUtils.getOnlyValue(rets[0]));
            } else {
                System.out.println("[WindowsStats] Quering CPU failed (no results returned)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (rets[1] != null && rets[1].hasProperties()) {
                long tmp = Long.parseLong(WMIUtils.getOnlyValue(rets[1]));
                this.usedMemoryBytes = this.basicInfo.memoryTotalBytes - tmp;
            } else {
                System.out.println("[WindowsStats] Quering memory usage failed (no results returned)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Stats.DiskSpaceStatistic> diskResults = new ArrayList<Stats.DiskSpaceStatistic>();
        if (rets[3] != null && rets[3].hasProperties()) {
            for (Properties properties : rets[3].getProperties()) {
                try {
                    String name = properties.getProperty("Name");
                    if (name.toLowerCase().contains("_total")) continue;
                    freeMegabytes = Integer.parseInt(properties.getProperty("FreeMegabytes"));
                    double percentFreeSpace = Integer.parseInt(properties.getProperty("PercentFreeSpace"));
                    double percentFreeSpaceBase = Integer.parseInt(properties.getProperty("PercentFreeSpace_Base"));
                    if (!(percentFreeSpaceBase > 0.0)) continue;
                    double totalMB = (double)freeMegabytes * (percentFreeSpaceBase / percentFreeSpace);
                    long freeBytes = (long)freeMegabytes * 1024L * 1024L;
                    long usedBytes = (long)(totalMB * 1024.0 * 1024.0 - (double)freeBytes);
                    Stats.DiskSpaceStatistic diskSpaceStats = new Stats.DiskSpaceStatistic();
                    diskSpaceStats.name = name;
                    diskSpaceStats.free = freeBytes;
                    diskSpaceStats.used = usedBytes;
                    if (OS.isWindows()) {
                        diskSpaceStats.isRecovery = this.isRecoveryPartition(name);
                        diskSpaceStats.isShared = this.isSharedFoldersPartition(name);
                    } else {
                        diskSpaceStats.isRecovery = false;
                        diskSpaceStats.isShared = false;
                    }
                    diskResults.add(diskSpaceStats);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("[WindowsStats] Quering disks failed (no results returned)");
        }
        this.diskSpaceStatistics = diskResults.toArray(new Stats.DiskSpaceStatistic[0]);
        ArrayList<Stats.ProcessStatistic> processList = new ArrayList<Stats.ProcessStatistic>();
        HashMap<String, ProcessorTimeContainer> processToTimestampMap = new HashMap<String, ProcessorTimeContainer>();
        if (rets[4] != null && rets[4].hasProperties()) {
            Properties[] processResults;
            Properties[] propertiesArray = processResults = rets[4].getProperties();
            int e = propertiesArray.length;
            for (freeMegabytes = 0; freeMegabytes < e; ++freeMegabytes) {
                Properties processResult = propertiesArray[freeMegabytes];
                try {
                    ID = processResult.getProperty("IDProcess");
                    String name = processResult.getProperty("Name");
                    double memBytes = Double.parseDouble(processResult.getProperty("WorkingSet"));
                    double memoryPercent = 100.0 * (memBytes / (double)this.basicInfo.memoryTotalBytes);
                    String lowercaseName = name.toLowerCase().trim();
                    if (lowercaseName.contains("_total") || lowercaseName.contains("idle") || lowercaseName.contains("system")) continue;
                    Stats.ProcessStatistic p = new Stats.ProcessStatistic();
                    p.name = name;
                    p.id = ID;
                    p.memPercentage = (byte)memoryPercent;
                    p.user = "-";
                    processList.add(p);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            System.out.println("[WindowsStats] Quering process stats (1) failed (no results returned)");
        }
        if (rets[6] != null && rets[6].hasProperties()) {
            Properties[] processResults;
            Properties[] propertiesArray = processResults = rets[6].getProperties();
            int e = propertiesArray.length;
            for (freeMegabytes = 0; freeMegabytes < e; ++freeMegabytes) {
                Properties processResult = propertiesArray[freeMegabytes];
                try {
                    int indexOfProcessName;
                    ID = processResult.getProperty("ProcessId");
                    String commandLineWithArgs = processResult.getProperty("CommandLine");
                    String name = processResult.getProperty("Name");
                    Stats.ProcessStatistic p = WindowsStats.getProcessByID(processList, ID);
                    if (p == null) continue;
                    p.name = name;
                    p.cmdLineNoArgs = name != null && commandLineWithArgs != null && commandLineWithArgs.length() > 0 ? (commandLineWithArgs.startsWith("\"") ? commandLineWithArgs.substring(1, commandLineWithArgs.indexOf(34, 1)) : ((indexOfProcessName = commandLineWithArgs.toLowerCase().lastIndexOf(name.toLowerCase())) == -1 ? commandLineWithArgs : commandLineWithArgs.substring(0, indexOfProcessName + name.length()))) : (commandLineWithArgs != null ? commandLineWithArgs : p.name);
                    if (commandLineWithArgs != null && commandLineWithArgs.length() > 0) {
                        p.cmdLineArgs = commandLineWithArgs;
                        continue;
                    }
                    p.cmdLineArgs = p.name;
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            System.out.println("[WindowsStats] Quering process stats (2) failed (no results returned)");
        }
        if (rets[5] != null && rets[5].hasProperties()) {
            Properties[] processResults;
            Properties[] propertiesArray = processResults = rets[5].getProperties();
            int e = propertiesArray.length;
            for (freeMegabytes = 0; freeMegabytes < e; ++freeMegabytes) {
                Properties processResult = propertiesArray[freeMegabytes];
                try {
                    ID = processResult.getProperty("IDProcess");
                    long percentProcessorTime = Long.parseLong(processResult.getProperty("PercentProcessorTime"));
                    long timestamp = Long.parseLong(processResult.getProperty("Timestamp_Sys100NS"));
                    ProcessorTimeContainer cont = new ProcessorTimeContainer();
                    cont.timestamp = timestamp;
                    cont.processorTime = percentProcessorTime;
                    processToTimestampMap.put(ID, cont);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            System.out.println("[WindowsStats] Quering process stats (3) failed (no results returned)");
        }
        if (dels[0] != null && dels[0].hasProperties()) {
            Properties[] processResults;
            for (Properties processResult : processResults = dels[0].getProperties()) {
                try {
                    ID = processResult.getProperty("IDProcess");
                    long processorTime = Long.parseLong(processResult.getProperty("PercentProcessorTime"));
                    long timestamp = Long.parseLong(processResult.getProperty("Timestamp_Sys100NS"));
                    ProcessorTimeContainer previous = (ProcessorTimeContainer)processToTimestampMap.get(ID);
                    Stats.ProcessStatistic p = WindowsStats.getProcessByID(processList, ID);
                    if (previous == null || p == null) continue;
                    long cpu = 100L * (processorTime -= previous.processorTime) / (timestamp -= previous.timestamp);
                    p.cpuPercentage = (int)cpu;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            System.out.println("[WindowsStats] Quering delayed process stats failed (no results returned)");
        }
        this.processStatistics = processList.toArray(new Stats.ProcessStatistic[0]);
        String wlan = nonwmicrets[0];
        try {
            int n = wlan.indexOf(37);
            int first = wlan.lastIndexOf(58, n);
            first = wlan.lastIndexOf(58, first - 1);
            if (n >= 0) {
                wlan = wlan.substring(first + 1, n);
                System.out.println(wlan);
                CharStack cs = new CharStack(wlan);
                cs.popWhitespace();
                this.wifiMbit = cs.popNumber();
                cs.popUntil(":");
                cs.pop();
                cs.popWhitespace();
                this.wifiPercentage = cs.popNumber();
            }
        }
        catch (Exception exception) {
            System.out.println("[WindowsStats] Quering WLAN stats failed (" + exception.getMessage() + ")");
        }
        this.batteryPercentage = 0;
        try {
            if (rets[7] != null && rets[7].hasProperties()) {
                String string = WMIUtils.getOnlyValue(rets[7]);
                this.batteryPercentage = Integer.parseInt(string.trim());
            } else {
                System.out.println("[WindowsStats] Quering battery stats failed (no results returned)");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String killProcess(String pid) {
        try {
            RunCommandGetOutput.runCommandGetOutput(new String[]{"taskkill.exe", "/F", "/PID", pid});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Process p = WmicUtil.launchWmicCommand("/interactive:off process where ProcessId=\"" + pid + "\" call terminate");
            OutputStream out = p.getOutputStream();
            out.write("yyyyyyyy\r\nyyyyyy\r\n".getBytes());
            out.flush();
            p.getInputStream().close();
            p.getErrorStream().close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static Stats.LocalPort[] getListeningApplications() {
        return WindowsStats.getListeningApplication(-1);
    }

    public static Stats.LocalPort[] getListeningApplication(int port) {
        String[] output = RunCommandGetOutput.runCommandGetOutput(new String[]{"netstat", "-aon"});
        String stdout = output[0];
        String[] lines = stdout.split("\n");
        ArrayList<Stats.LocalPort> results = new ArrayList<Stats.LocalPort>();
        for (String line : lines) {
            if (!line.contains("UDP") && !line.contains("TCP")) continue;
            ArrayList<String> chunks = Chunker.chunk(line, false, true);
            try {
                Stats.LocalPort result = new Stats.LocalPort();
                String protocol = chunks.get(0);
                if (protocol.equalsIgnoreCase("TCP")) {
                    result.tcp = true;
                    if (!line.contains("LISTENING")) {
                        continue;
                    }
                } else if (protocol.equalsIgnoreCase("UDP")) {
                    result.udp = true;
                }
                String local = chunks.get(1);
                result.pid = Integer.parseInt(chunks.get(chunks.size() - 1));
                result.ip = local.substring(0, local.lastIndexOf(58));
                local = local.substring(local.lastIndexOf(":") + 1);
                result.port = Integer.parseInt(local);
                if (port != -1 && result.port != port) continue;
                results.add(result);
            }
            catch (Exception x) {
                System.out.println("[WindowsStats] Ignored: " + line);
            }
        }
        return results.toArray(new Stats.LocalPort[0]);
    }

    private boolean contains(String[] array, String elem) {
        for (String test : array) {
            if (!test.equalsIgnoreCase(elem)) continue;
            return true;
        }
        return false;
    }

    public void killProcessLaunchedFrom(String path, String exclude) {
        if (exclude == null) {
            this.killProcessLaunchedFrom(path, (String[])null);
        } else {
            this.killProcessLaunchedFrom(path, new String[]{exclude});
        }
    }

    public void killProcessLaunchedFrom(String path, String[] excludes) {
        WMIResults results = WMIRegistry.getProvider().queryWMI("SELECT * from Win32_Process");
        if (results.hasProperties()) {
            Properties[] rows;
            for (Properties row : rows = results.getProperties()) {
                PrintingUtil.printPropertiesLined(row);
                String commandLine = row.getProperty("ExecutablePath");
                String pid = row.getProperty("ProcessId");
                if (commandLine == null || pid == null) continue;
                System.out.println("[WindowsStats] Process " + pid + " launched from " + commandLine);
                if (excludes != null && this.contains(excludes, pid)) {
                    System.out.println("[WindowsStats] EXCLUDING " + pid);
                    continue;
                }
                if (!commandLine.startsWith(path)) continue;
                System.out.println("[WindowsStats] KILLING " + pid);
                this.killProcess(pid);
            }
        }
    }

    @Override
    public void killProcessListeningOn(int port, boolean tcp, boolean udp) {
        String[] lines;
        String[] output = RunCommandGetOutput.runCommandGetOutput(new String[]{"netstat", "-aon"});
        String stdout = output[0];
        for (String line : lines = stdout.split("\n")) {
            ArrayList<String> chunks = Chunker.chunk(line, false, true);
            try {
                String protocol = chunks.get(0);
                String local = chunks.get(1);
                String pid = chunks.get(chunks.size() - 1);
                System.out.println(line);
                System.out.println(pid + " - (" + protocol + ") " + local);
                local = local.substring(local.lastIndexOf(":") + 1);
                int lport = Integer.parseInt(local);
                boolean mustKill = false;
                if (tcp && protocol.equalsIgnoreCase("tcp") && lport == port) {
                    mustKill = true;
                }
                if (udp && protocol.equalsIgnoreCase("udp") && lport == port) {
                    mustKill = true;
                }
                if (!mustKill) continue;
                System.out.println("[WindowsStats] Killing process " + pid);
                this.killProcess(pid);
            }
            catch (Exception x) {
                System.out.println("[WindowsStats] Ignored: " + line);
            }
        }
    }

    public static void main(String[] args) {
        int freeMegabytes = 4692;
        double percentFreeSpace = 4692.0;
        double percentFreeSpaceBase = 20477.0;
        double totalMB = (double)freeMegabytes * (percentFreeSpaceBase / percentFreeSpace);
        System.out.println(totalMB);
        long freeBytes = (long)freeMegabytes * 1024L * 1024L;
        long usedBytes = (long)(totalMB * 1024.0 * 1024.0 - (double)freeBytes);
        System.out.println(usedBytes);
        System.out.println(freeBytes);
    }

    private class ProcessorTimeContainer {
        long timestamp;
        long processorTime;

        private ProcessorTimeContainer() {
        }
    }
}

