/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageMap;
import utils.message.MessageUtils;
import utils.progtools.BestCaseCompressor;
import utils.string.HexData;
import utils.string.WebBase64;

public class TypedMap {
    final Object map_LOCK = new Object();
    MessageMap map = new MessageMap();

    public String toHex() {
        return HexData.byteArrayToHexString(this.toCompressedBytes());
    }

    public static TypedMap fromHex(String str) {
        return TypedMap.fromCompressedBytes(HexData.hexStringToByteArray(str));
    }

    public String toBase64() {
        return WebBase64.byteArrayToBase64(this.toCompressedBytes());
    }

    public static TypedMap fromBase64(String str) {
        return TypedMap.fromCompressedBytes(WebBase64.base64ToByteArray(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllKeys() {
        Object object = this.map_LOCK;
        synchronized (object) {
            return this.map.getAllKeys();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        ArrayList<String> allkeys = this.map.getAllKeys();
        Collections.sort(allkeys);
        for (String key : allkeys) {
            String value;
            Message m = this.map.get(key);
            if (m == null) {
                value = "(null)";
            } else if (m.length() == 1) {
                value = "" + m.get(0);
            } else {
                StringBuilder value2 = new StringBuilder();
                value2.append("[");
                for (int i = 0; i < m.length(); ++i) {
                    if (i > 0) {
                        value2.append(", ");
                    }
                    value2.append(m.get(i));
                }
                value2.append("]");
                value = value2.toString();
            }
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(key).append(":").append(value);
        }
        builder.append("}");
        return builder.toString();
    }

    public static TypedMap fromFile(File f) throws IOException {
        try {
            AtomicFileOutputStream.prepareForReading(f);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return TypedMap.fromCompressedBytes(FileUtil.readFile(f));
    }

    public void toFile(File f) throws IOException {
        AtomicFileOutputStream afos = new AtomicFileOutputStream(f);
        afos.write(this.toCompressedBytes());
        afos.close();
    }

    public Message toMessage() {
        return this.map.toMessage();
    }

    public static TypedMap fromMessage(Message m) {
        TypedMap map = new TypedMap();
        map.map = MessageMap.fromMessage(m);
        return map;
    }

    public Message toCompressedMessage() {
        Message m = new Message();
        m.append(this.toCompressedBytes());
        return m;
    }

    public static TypedMap fromCompressedMessage(Message m) {
        return TypedMap.fromCompressedBytes(m.getFirstByteArray());
    }

    public byte[] toCompressedBytes() {
        byte[] dat = MessageUtils.messageToBytes(this.toMessage());
        dat = BestCaseCompressor.compress(dat);
        return dat;
    }

    public static TypedMap fromCompressedBytes(byte[] dat) {
        dat = BestCaseCompressor.decompress(dat);
        return TypedMap.fromMessage(MessageUtils.bytesToMessage(dat));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypedMap(String key, TypedMap v) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = v.map.toMessage();
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedMap getTypedMap(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            if (m == null) {
                return null;
            }
            TypedMap tm = new TypedMap();
            tm.map = MessageMap.fromMessage(m);
            return tm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(String key, Properties p) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Object[] keys;
            Message m = new Message();
            for (Object keyobj : keys = p.keySet().toArray()) {
                String skey = (String)keyobj;
                String val = p.getProperty(skey);
                m.append(skey);
                m.append(val);
            }
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPropertiesCopy(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            if (m == null) {
                return null;
            }
            Properties p = new Properties();
            m.resetIndex();
            while (m.hasNext()) {
                String skey = m.getNextString();
                String val = m.getNextString();
                p.setProperty(skey, val);
            }
            return p;
        }
    }

    public static void main(String[] args) {
        TypedMap tm = new TypedMap();
        Properties p = new Properties();
        p.setProperty("A", "A");
        p.setProperty("B", "B");
        tm.setProperties("WOOT", p);
        tm.setInt("Key", 1);
        tm.setInt("Key2", 2);
        tm.setInt("Test", 2);
        tm.setString("Woot", "2");
        System.out.println(tm.getPropertiesCopy("WOOT"));
        System.out.println(tm.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringArray(String key, String[] n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = new Message();
            for (String s : n) {
                m.append(s);
            }
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStringArray(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            if (m == null) {
                return null;
            }
            String[] tmp = new String[m.length()];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = m.getAsString(i);
            }
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringList(String key, ArrayList<String> n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = new Message();
            for (String s : n) {
                m.append(s);
            }
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getStringList(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            if (m == null) {
                return null;
            }
            ArrayList<String> tmp = new ArrayList<String>();
            for (int i = 0; i < m.length(); ++i) {
                tmp.add(m.getAsString(i));
            }
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            return this.map.contains(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(String key, int n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = new Message();
            m.append(n);
            this.map.put(key, m);
        }
    }

    public boolean has(String key) {
        return this.map.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(String key, boolean n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = new Message();
            m.append(n);
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            return m.getFirstBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean def) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            if (m == null) {
                return def;
            }
            return m.getFirstBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            return m.getFirstInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String key, String n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = new Message();
            m.append(n);
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            if (m == null) {
                return null;
            }
            return m.getFirstString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String key, byte[] n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = new Message();
            m.append(n);
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            if (m == null) {
                return null;
            }
            return m.getFirstByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(String key, Message m) {
        Object object = this.map_LOCK;
        synchronized (object) {
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(String key, long n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = new Message();
            m.append(n);
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            return m.getFirstLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(String key, double n) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = new Message();
            m.append(n);
            this.map.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String key) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Message m = this.map.get(key);
            return m.getFirstDouble();
        }
    }
}

