/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.logging;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.updater.JWLaunchProperties;
import jwrapper.updater.LogFolderCleaner;
import utils.ostools.OS;
import utils.progtools.CheapTimingPrintStream;
import utils.progtools.CheapTimingProvider;
import utils.progtools.CircularLogStream;
import utils.progtools.ProcessPrinter;

public class StdLogging {
    public static final boolean DEBUG_LOG_ALL = true;
    public static final String LOG_DIR = "logs";
    public static long DEF_INITIAL_MB = 20L;
    public static long DEF_CIRCULAR_MB = 30L;
    static long ONE_MB = 1024000L;
    static File myLogFile;
    static CircularLogStream myLogStream;
    static CheapTimingPrintStream myCheapTimer;
    static boolean logging;

    public static boolean beforeDebugLogUntil(String propvalue) {
        try {
            long x = Long.parseLong(propvalue);
            return System.currentTimeMillis() < x;
        }
        catch (Exception x) {
            return true;
        }
    }

    public static void startDebugLogging(File master, String name) {
        StdLogging.startLogging(master, name);
    }

    public static File getLogFile(File logsFolder, String name) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
        int pid = 0;
        try {
            pid = JWGenericOS.getInstance().getCurrentProcessID();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File file = new File(logsFolder, name + "-" + sdf.format(new Date()) + "-pid" + pid + ".log");
        if (!OS.isWindows()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"chmod", "755", file.getCanonicalPath()});
                new ProcessPrinter(p, System.out, System.err);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
        }
        return file;
    }

    public static File getMyLogFile() {
        return myLogFile;
    }

    public static void setInitialLogSize(long bytes) {
        try {
            myLogStream.setInitialSize(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setCircularLogSize(long bytes) {
        try {
            myLogStream.setCircularSize(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setCheapTimingProvider(CheapTimingProvider provider) {
        try {
            if (myCheapTimer != null) {
                myCheapTimer.setProvider(provider);
            } else if (System.out instanceof CheapTimingPrintStream) {
                ((CheapTimingPrintStream)System.out).setProvider(provider);
            } else {
                System.out.println("[StdLogging] Cheap timing provider not set, class is " + System.out.getClass().getName());
            }
        }
        catch (Exception x) {
            System.out.println("Unable to set cheap timing provider: " + x);
        }
    }

    public static void startLogging(File master, String name) {
        if (JWLaunchProperties.getBooleanProperty("logging_mute", false)) {
            return;
        }
        if (!logging) {
            File file;
            File logs = new File(master, LOG_DIR);
            if (!logs.exists()) {
                logs.mkdirs();
                if (!OS.isWindows()) {
                    try {
                        Process p = Runtime.getRuntime().exec(new String[]{"chmod", "-R", "777", logs.getCanonicalPath()});
                        new ProcessPrinter(p, System.out, System.err);
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                    }
                }
            }
            myLogFile = file = StdLogging.getLogFile(logs, name);
            logging = true;
            try {
                myLogStream = new CircularLogStream(file, DEF_INITIAL_MB * ONE_MB, DEF_CIRCULAR_MB * ONE_MB);
                myCheapTimer = new CheapTimingPrintStream(myLogStream);
                System.setErr(myCheapTimer);
                System.setOut(myCheapTimer);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LogFolderCleaner.clean(logs);
        }
    }

    static {
        logging = false;
    }
}

