/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.logging;

public class ProcessResult {
    public StringBuffer logMessages = new StringBuffer();
    public StringBuffer logErrors = new StringBuffer();
    public String stacktrace = "";
    public String source = "";
    public int code = 0;
    public long time = 0L;
    public static final int UNKNOWN = 0;
    public static final int OK = 1;
    public static final int ERROR = 2;
    public static final int CANCELLED = 3;
    public static final int LAUNCHED_OK = 4;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ProcessResult <").append(this.code).append(">\n");
        if (this.logMessages != null && this.logMessages.length() > 0) {
            buffer.append("Log: " + this.logMessages).append("\n");
        }
        if (this.logErrors != null && this.logErrors.length() > 0) {
            buffer.append("Error: " + this.logErrors).append("\n");
        }
        if (this.stacktrace != null && this.stacktrace.length() > 0) {
            buffer.append("StackTrace: " + this.stacktrace).append("\n");
        }
        return buffer.toString();
    }

    public boolean isUnknown() {
        return this.code == 0;
    }

    public boolean isLaunchedOK() {
        return this.code == 4;
    }

    public boolean isOK() {
        return this.code == 1;
    }

    public boolean isError() {
        return this.code == 2;
    }

    public boolean isCancelled() {
        return this.code == 3;
    }

    public String getErrors() {
        return this.logErrors.toString();
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public String getInfoMessages() {
        return this.logMessages.toString();
    }
}

