/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.webservice;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.jradius.server.JRadiusEvent;
import net.jradius.webservice.WebServiceResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRequest
extends JRadiusEvent {
    public static final long serialVersionUID = 0L;
    public static final int GET = 1;
    public static final int POST = 2;
    public static final int PUT = 3;
    private int type;
    private int method;
    private String httpVersion;
    private URI uri;
    private byte[] content;
    private Map<String, String> headerMap;
    private Map<String, String> serverVariableMap;
    private X509Certificate clientCertificate;
    private WebServiceResponse response;
    private Object sessionObject;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTypeString() {
        return "ws";
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        return this.getContent() == null ? null : new String(this.getContent(), "UTF-8");
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public WebServiceResponse getResponse() {
        return this.response;
    }

    public void setResponse(WebServiceResponse reply) {
        this.response = reply;
    }

    public Object getSessionObject() {
        return this.sessionObject;
    }

    public void setSessionObject(Object sessionObject) {
        this.sessionObject = sessionObject;
    }

    public Map<String, String> getParameterMap() {
        String qs = this.getUri().getQuery();
        HashMap<String, String> map = new HashMap<String, String>();
        if (qs != null) {
            StringTokenizer st = new StringTokenizer(qs, "&");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                int i = param.indexOf("=");
                if (i == -1) continue;
                String k = param.substring(0, i);
                String v = param.substring(i + 1, param.length());
                try {
                    map.put(k, URLDecoder.decode(v));
                }
                catch (Exception e) {
                    map.put(k, v);
                }
            }
        }
        if (this.serverVariableMap != null) {
            map.putAll(this.serverVariableMap);
        }
        return map;
    }

    public String toString() {
        return this.getHeaderMap().toString();
    }

    public void setCertificate(X509Certificate x509) {
        this.clientCertificate = x509;
    }

    public X509Certificate getCertificate() {
        return this.clientCertificate;
    }

    public Map<String, String> getServerVariableMap() {
        return this.serverVariableMap;
    }

    public void setServerVariableMap(Map<String, String> serverVariableMap) {
        this.serverVariableMap = serverVariableMap;
    }
}

