/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.webservice;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.util.Base64;
import java.io.Serializable;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import net.jradius.handler.EventHandlerBase;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusEvent;
import net.jradius.session.JRadiusSession;
import net.jradius.session.JRadiusSessionManager;
import net.jradius.webservice.WebServiceException;
import net.jradius.webservice.WebServiceRequest;
import net.jradius.webservice.WebServiceResponse;

public class SSOProxyService
extends EventHandlerBase {
    private String defaultURL = "http://jradius.net/";
    private String cipherType = "Blowfish";
    private String cipherKey = "changeme";

    public boolean doesHandle(JRadiusEvent event) {
        WebServiceRequest request = (WebServiceRequest)event;
        String path = request.getUri().getPath();
        return path.startsWith("/sso/");
    }

    public boolean handle(JRadiusEvent event) throws Exception {
        WebServiceRequest request = (WebServiceRequest)event;
        String path = request.getUri().getRawPath();
        RadiusLog.debug((String)("SSO Proxy Request: " + path));
        String[] parts = path.split("/", 3);
        if (parts.length != 3) {
            throw new WebServiceException("invalid request");
        }
        String command = parts[1];
        String payload = parts[2];
        if (!"sso".equals(command)) {
            throw new WebServiceException("invalid command");
        }
        if (payload == null) {
            throw new WebServiceException("invalid security");
        }
        IBlockCipher cipher = CipherFactory.getInstance((String)this.cipherType);
        HashMap<String, byte[]> attributes = new HashMap<String, byte[]>();
        attributes.put("gnu.crypto.cipher.key.material", this.cipherKey.getBytes());
        try {
            cipher.init(attributes);
        }
        catch (InvalidKeyException e) {
            RadiusLog.warn((String)e.getMessage(), (Throwable)e);
        }
        int bs = cipher.currentBlockSize();
        byte[] data = Base64.decode((String)payload);
        byte[] plaintext = new byte[(data.length / bs + 1) * bs];
        int i = 0;
        while (i + bs < data.length) {
            cipher.decryptBlock(data, i, plaintext, i);
            i += bs;
        }
        String scommand = URLDecoder.decode(new String(plaintext).trim(), "US-ASCII");
        RadiusLog.debug((String)("Secure command: " + scommand));
        String session = scommand.substring("session=".length());
        JRadiusSession radiusSession = JRadiusSessionManager.getManager((Object)request.getSender()).getSession(null, (Serializable)((Object)session));
        WebServiceResponse response = new WebServiceResponse();
        Map<String, String> headers = response.getHeaders();
        String url = radiusSession.getRedirectURL();
        if (url == null) {
            url = this.defaultURL;
        }
        headers.put("Location", url);
        request.setResponse(response);
        return false;
    }

    public String getCipherKey() {
        return this.cipherKey;
    }

    public void setCipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
    }

    public String getCipherType() {
        return this.cipherType;
    }

    public void setCipherType(String cipherType) {
        this.cipherType = cipherType;
    }

    public String getDefaultURL() {
        return this.defaultURL;
    }

    public void setDefaultURL(String defaultURL) {
        this.defaultURL = defaultURL;
    }
}

