/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.webservice;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.EAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_AcctSessionId;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.realm.JRadiusRealm;
import net.jradius.server.JRadiusThread;
import net.jradius.util.Base64;
import net.jradius.util.RadiusRandom;
import net.jradius.webservice.OTPProxyException;
import net.jradius.webservice.WebServiceListener;
import net.jradius.webservice.WebServiceRequestObject;

public class OTPProxyRequest
extends JRadiusThread
implements WebServiceRequestObject {
    private final WebServiceListener wsListener;
    private String userName;
    private JRadiusRealm radiusRealm;
    private String otpName;
    private String otpPassword;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private RadiusClient radiusClient;
    private AttributeList reqList = new AttributeList();
    private long timeout = 30000L;
    private PacketLocker accessRequest = new PacketLocker();
    private PacketLocker accessResponse = new PacketLocker();

    public OTPProxyRequest(WebServiceListener wsListener, String userName, JRadiusRealm realm, Socket socket, BufferedReader reader, BufferedWriter writer) throws OTPProxyException {
        this.wsListener = wsListener;
        this.userName = userName;
        this.otpName = RadiusRandom.getRandomString((int)16);
        this.otpPassword = RadiusRandom.getRandomString((int)16);
        this.socket = socket;
        this.reader = reader;
        this.writer = writer;
        this.radiusRealm = realm;
        try {
            this.radiusClient = new RadiusClient(InetAddress.getByName(this.radiusRealm.getServer()), this.radiusRealm.getSharedSecret());
        }
        catch (Exception e) {
            throw new OTPProxyException(e.getMessage());
        }
    }

    public void delete() {
        this.shutdown();
    }

    public String getKey() {
        return this.getOtpName();
    }

    public void run() {
        try {
            this.writer.write(this.getOtpName());
            this.writer.write("\n");
            this.writer.write(this.getOtpPassword());
            this.writer.write("\n");
            this.writer.flush();
            RadiusRequest request = this.getAccessRequest();
            if (request == null) {
                RadiusLog.error((String)"we never got the access request");
                this.abort(null);
                return;
            }
            AttributeList attrs = request.getAttributes();
            for (RadiusAttribute at : attrs.getAttributeList()) {
                long type = at.getFormattedType();
                if (type != 30L && type != 31L && type != 4L && type != 32L && type != 6L && type != 1259012098L && type != 61L && type != 5L) continue;
                this.reqList.add(AttributeFactory.newAttribute((long)type, (byte[])at.getValue().getBytes()));
            }
            this.reqList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)this.userName)));
            this.reqList.add((RadiusAttribute)new Attr_AcctSessionId((Serializable)((Object)RadiusRandom.getRandomString((int)16))));
            AccessRequest realRequest = new AccessRequest(this.radiusClient, this.reqList);
            RadiusLog.debug((String)("------------------------------------------------\nOTP Proxy Request:\n" + realRequest.toString() + "------------------------------------------------\n"));
            RadiusResponse reply = this.radiusClient.authenticate(realRequest, (RadiusAuthenticator)new EAPRelayAuthenticator(), 5);
            this.setAccessResponse(reply);
        }
        catch (Exception e) {
            RadiusLog.warn((String)e.getMessage(), (Throwable)e);
            this.abort(e);
        }
    }

    public String getOtpName() {
        return this.otpName;
    }

    public String getOtpPassword() {
        return this.otpPassword;
    }

    public String getUserName() {
        return this.userName;
    }

    public JRadiusRealm getRadiusRealm() {
        return this.radiusRealm;
    }

    public void setAccessRequest(RadiusRequest accessRequest) {
        this.accessRequest.setPacket((RadiusPacket)accessRequest);
    }

    public void setAccessResponse(RadiusResponse accessResponse) {
        this.accessResponse.setPacket((RadiusPacket)accessResponse);
    }

    public RadiusRequest getAccessRequest() throws InterruptedException {
        RadiusPacket p = this.accessRequest.getPacket();
        if (p == null) {
            RadiusLog.error((String)"we never got the access request");
            this.abort(null);
        }
        return (RadiusRequest)p;
    }

    public RadiusResponse getAccessResponse() throws InterruptedException {
        RadiusPacket p = this.accessResponse.getPacket();
        if (p == null) {
            RadiusLog.error((String)"we never got the access response");
            this.abort(null);
        }
        return (RadiusResponse)p;
    }

    public void updateAccounting(AccountingRequest acctRequest) throws RadiusException {
        AccountingRequest newRequest = new AccountingRequest(this.radiusClient, this.reqList);
        AttributeList attrs = acctRequest.getAttributes();
        for (RadiusAttribute at : attrs.getAttributeList()) {
            long type = at.getFormattedType();
            if (type != 42L && type != 43L && type != 52L && type != 53L && type != 47L && type != 48L && type != 49L && type != 1050L && type != 41L && type != 46L && type != 40L) continue;
            newRequest.addAttribute(AttributeFactory.newAttribute((long)type, (byte[])at.getValue().getBytes()));
        }
        this.radiusClient.accounting(newRequest, 2);
    }

    private byte[] readData() {
        try {
            String line = this.reader.readLine();
            RadiusLog.debug((String)("OtpProxy: read-" + line));
            if (line.startsWith("eap:")) {
                return Base64.decode((String)line.substring(4));
            }
        }
        catch (Exception e) {
            this.abort(e);
        }
        return null;
    }

    private byte[] relayEAP(byte[] eapIn) {
        try {
            String line = "eap:" + Base64.encodeBytes((byte[])eapIn, (int)8) + "\n";
            this.writer.write(line);
            this.writer.flush();
            RadiusLog.debug((String)("OtpProxy: write-" + line));
            return this.readData();
        }
        catch (IOException e) {
            this.abort(e);
            return null;
        }
    }

    public void abort(Exception e) {
        if (e == null) {
            RadiusLog.error((String)"aborting otp proxy request");
        } else {
            RadiusLog.error((String)e.getMessage(), (Throwable)e);
        }
        this.wsListener.remove(this);
        this.shutdown();
    }

    public void shutdown() {
        try {
            this.writer.close();
            this.reader.close();
            this.socket.close();
            this.radiusClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class EAPRelayAuthenticator
    extends EAPAuthenticator {
        private EAPRelayAuthenticator() {
        }

        public void processRequest(RadiusPacket p) throws RadiusException {
            p.addAttribute(AttributeFactory.newAttribute((long)79L, (byte[])OTPProxyRequest.this.readData()));
        }

        public byte[] doEAP(byte[] eapReply) {
            return OTPProxyRequest.this.relayEAP(eapReply);
        }

        public byte[] doEAPType(byte id, byte[] data) {
            return null;
        }

        public String getAuthName() {
            return "OTPProxy-EAP-Callback";
        }
    }

    private class PacketLocker {
        RadiusPacket packet;

        private PacketLocker() {
        }

        public synchronized RadiusPacket getPacket() throws InterruptedException {
            if (this.packet == null) {
                this.wait(OTPProxyRequest.this.timeout);
            }
            return this.packet;
        }

        public synchronized void setPacket(RadiusPacket packet) {
            this.packet = packet;
            this.notify();
        }
    }
}

