/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;

public class KeyStoreUtil {
    public static void loadBC() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static KeyManager[] loadKeyManager(String type, InputStream in, String password) throws Exception {
        char[] pwd;
        KeyStoreUtil.loadBC();
        char[] cArray = pwd = password == null || password.length() == 0 ? null : password.toCharArray();
        if (type.equalsIgnoreCase("pem")) {
            Object obj;
            PEMReader pemReader = new PEMReader((Reader)new InputStreamReader(in), new PasswordFinder(){

                public char[] getPassword() {
                    return pwd;
                }
            });
            Object keyObj = null;
            Object certObj = null;
            Object keyPair = null;
            while ((obj = pemReader.readObject()) != null) {
                if (obj instanceof X509Certificate) {
                    certObj = obj;
                    continue;
                }
                if (obj instanceof PrivateKey) {
                    keyObj = obj;
                    continue;
                }
                if (!(obj instanceof KeyPair)) continue;
                keyPair = obj;
            }
            if ((keyObj != null || keyPair != null) && certObj != null) {
                PrivateKey key = keyPair != null ? ((KeyPair)keyPair).getPrivate() : (PrivateKey)keyObj;
                X509Certificate cert = (X509Certificate)certObj;
                KeyStore ksKeys = KeyStore.getInstance("JKS");
                ksKeys.load(null, pwd == null ? "".toCharArray() : pwd);
                ksKeys.setCertificateEntry("", cert);
                ksKeys.setKeyEntry("", key, pwd == null ? "".toCharArray() : pwd, new Certificate[]{cert});
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ksKeys, pwd == null ? "".toCharArray() : pwd);
                return kmf.getKeyManagers();
            }
            throw new RuntimeException("Could not load PEM source");
        }
        KeyStore ksKeys = KeyStore.getInstance(type);
        ksKeys.load(in, pwd);
        Enumeration<String> aliases = ksKeys.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            System.err.println("KeyStore Alias: " + alias);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ksKeys, pwd);
        return kmf.getKeyManagers();
    }

    public static X509Certificate loadCertificateFromPEM(InputStream in, final char[] pwd) throws Exception {
        Object obj;
        KeyStoreUtil.loadBC();
        PEMReader pemReader = new PEMReader((Reader)new InputStreamReader(in), new PasswordFinder(){

            public char[] getPassword() {
                return pwd;
            }
        });
        while ((obj = pemReader.readObject()) != null) {
            if (!(obj instanceof X509Certificate)) continue;
            return (X509Certificate)obj;
        }
        return null;
    }

    public static TrustManager[] loadTrustManager(String type, InputStream in, String password) throws Exception {
        char[] pwd;
        KeyStoreUtil.loadBC();
        char[] cArray = pwd = password == null || password.length() == 0 ? null : password.toCharArray();
        if (type.equalsIgnoreCase("pem")) {
            X509Certificate cert = KeyStoreUtil.loadCertificateFromPEM(in, pwd);
            KeyStore ksKeys = KeyStore.getInstance("JKS");
            ksKeys.load(null, pwd == null ? "".toCharArray() : pwd);
            ksKeys.setCertificateEntry("", cert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ksKeys);
            return tmf.getTrustManagers();
        }
        KeyStore caKeys = KeyStore.getInstance(type);
        caKeys.load(in, pwd);
        Enumeration<String> aliases = caKeys.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            System.err.println("KeyStore Alias: " + alias);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(caKeys);
        return tmf.getTrustManagers();
    }

    public static TrustManager[] trustAllManager() {
        KeyStoreUtil.loadBC();
        return new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

