/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.radsec;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.jradius.dictionary.Attr_SharedSecret;
import net.jradius.exception.RadiusException;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.NullResponse;
import net.jradius.packet.PacketFactory;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.radsec.RadSecRequest;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.ListenerRequest;
import net.jradius.server.TCPListener;
import net.jradius.util.MessageAuthenticator;

public class RadSecListener
extends TCPListener {
    private String tunnelSharedSecret = "radsec";

    public RadSecListener() {
        this.sslWantClientAuth = true;
        this.sslNeedClientAuth = true;
        this.keepAlive = true;
        this.requiresSSL = true;
        this.port = 2083;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JRadiusEvent parseRequest(ListenerRequest listenerRequest, ByteBuffer byteBuffer, InputStream inputStream) throws IOException, RadiusException {
        RadSecRequest request = new RadSecRequest();
        ByteBuffer buffer = request.buffer_in;
        int code = RadiusFormat.readUnsignedByte((InputStream)inputStream);
        int identifier = RadiusFormat.readUnsignedByte((InputStream)inputStream);
        int length = RadiusFormat.readUnsignedShort((InputStream)inputStream);
        if ((length -= 4) <= 0) {
            return null;
        }
        buffer.clear();
        buffer.limit(inputStream.read(buffer.array(), 0, length));
        if (buffer.limit() != length) {
            return null;
        }
        RadiusRequest req = (RadiusRequest)PacketFactory.parseUDP((int)code, (int)identifier, (int)length, (ByteBuffer)buffer);
        if (req == null) {
            return null;
        }
        if (req instanceof AccountingRequest) {
            if (!req.verifyAuthenticator(this.tunnelSharedSecret)) throw new RadiusException("Bad RadSec tunnel shared secret, set to " + this.tunnelSharedSecret);
            req.addAttribute((RadiusAttribute)new Attr_SharedSecret((Serializable)((Object)this.tunnelSharedSecret)));
        } else if (req instanceof RadiusRequest) {
            try {
                Boolean verified = MessageAuthenticator.verifyRequest((RadiusPacket)req, (String)this.tunnelSharedSecret);
                if (verified == null) {
                    throw new RadiusException("Message-Authenticator required");
                }
                if (!Boolean.TRUE.equals(verified)) {
                    throw new RadiusException("Bad RadSec tunnel shared secret, set to " + this.tunnelSharedSecret);
                }
                req.addAttribute((RadiusAttribute)new Attr_SharedSecret((Serializable)((Object)this.tunnelSharedSecret)));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        req.addAttribute((RadiusAttribute)new Attr_SharedSecret((Serializable)((Object)this.tunnelSharedSecret)));
        request.setSender("RadSec");
        request.setPackets(new RadiusPacket[]{req, new NullResponse()});
        request.setConfigItems(new AttributeList());
        return request;
    }

    public void setTunnelSharedSecret(String tunnelSharedSecret) {
        this.tunnelSharedSecret = tunnelSharedSecret;
    }
}

