/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.radsec;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.jradius.client.RadiusClientTransport;
import net.jradius.exception.RadiusException;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.PacketFactory;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;

public class RadSecClientTransport
extends RadiusClientTransport {
    private Socket socket;
    private Socket socketAcct;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    protected final ByteBuffer buffer_in;
    protected final ByteBuffer buffer_out;

    public RadSecClientTransport(KeyManager keyManager, TrustManager trustManager) {
        this(new KeyManager[]{keyManager}, new TrustManager[]{trustManager});
    }

    public RadSecClientTransport(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.keyManagers = keyManagers;
        this.trustManagers = trustManagers;
        this.buffer_in = ByteBuffer.allocate(25000);
        this.buffer_in.order(ByteOrder.BIG_ENDIAN);
        this.buffer_out = ByteBuffer.allocate(25000);
        this.buffer_out.order(ByteOrder.BIG_ENDIAN);
    }

    private void initialize() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSLv3");
            sslContext.init(this.keyManagers, this.trustManagers, null);
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            this.socket = socketFactory.createSocket(this.getRemoteInetAddress(), this.getAuthPort());
            this.socket.setReuseAddress(true);
            this.socket.setSoTimeout(this.getSocketTimeout() * 1000);
            if (this.getAcctPort() != this.getAuthPort()) {
                this.socketAcct = socketFactory.createSocket(this.getRemoteInetAddress(), this.getAcctPort());
                this.socketAcct.setReuseAddress(true);
                this.socketAcct.setSoTimeout(this.getSocketTimeout() * 1000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RadiusResponse sendReceive(RadiusRequest p, int retries) throws RadiusException {
        if (this.socket == null) {
            this.initialize();
        }
        return super.sendReceive(p, retries);
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RadiusResponse receive(RadiusRequest req) throws Exception {
        DataInputStream in;
        RadiusResponse res = null;
        DataInputStream dataInputStream = in = new DataInputStream(this.socket.getInputStream());
        synchronized (dataInputStream) {
            if (this.statusListener != null) {
                this.statusListener.onBeforeReceive((RadiusClientTransport)this);
            }
            int code = RadiusFormat.readUnsignedByte((InputStream)in);
            int identifier = RadiusFormat.readUnsignedByte((InputStream)in);
            int length = RadiusFormat.readUnsignedShort((InputStream)in);
            this.buffer_in.clear();
            this.buffer_in.limit(in.read(this.buffer_in.array(), 0, length));
            res = (RadiusResponse)PacketFactory.parseUDP((int)code, (int)identifier, (int)length, (ByteBuffer)this.buffer_in);
            if (this.statusListener != null) {
                this.statusListener.onAfterReceive((RadiusClientTransport)this, (RadiusPacket)res);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(RadiusRequest req, int attempt) throws Exception {
        Socket sock = this.socket;
        if (this.socketAcct != null && req instanceof AccountingRequest) {
            sock = this.socketAcct;
        }
        RadiusFormat format = RadiusFormat.getInstance();
        OutputStream out = sock.getOutputStream();
        this.buffer_out.clear();
        format.packPacket((RadiusPacket)req, "radsec", this.buffer_out, true);
        OutputStream outputStream = out;
        synchronized (outputStream) {
            if (this.statusListener != null) {
                this.statusListener.onBeforeSend((RadiusClientTransport)this, (RadiusPacket)req);
            }
            out.write(this.buffer_out.array(), 0, this.buffer_out.position());
            if (this.statusListener != null) {
                this.statusListener.onAfterSend((RadiusClientTransport)this);
            }
        }
    }
}

