/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler;

import java.io.Serializable;
import net.jradius.exception.RadiusException;
import net.jradius.handler.PacketHandlerChain;
import net.jradius.log.RadiusLog;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.server.JRadiusRequest;

public abstract class RadiusSessionHandler
extends PacketHandlerChain {
    public static final String ClassPrefix = "JRADIUS-CLASS:";

    protected boolean noSessionFound(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        RadiusLog.error((String)("No session found for packet:\n" + req.toString()));
        return true;
    }

    protected void setPlainTextPassword(JRadiusRequest request, String password) {
        this.setPlainTextPassword(request, password, true);
    }

    protected void setPlainTextPassword(JRadiusRequest request, String password, boolean overwrite) {
        AttributeList ci = request.getConfigItems();
        ci.add(AttributeFactory.newAttribute((Long)1100L, (Serializable)((Object)password)), overwrite);
        ci.add(AttributeFactory.newAttribute((Long)2L, (Serializable)((Object)password)), overwrite);
    }

    protected void reverseAccounting(RadiusPacket req) throws RadiusException {
        Long octetsIn = (Long)req.getAttributeValue(42L);
        Long octetsOut = (Long)req.getAttributeValue(43L);
        Long gigaIn = (Long)req.getAttributeValue(52L);
        Long gigaOut = (Long)req.getAttributeValue(53L);
        Long packetsIn = (Long)req.getAttributeValue(47L);
        Long packetsOut = (Long)req.getAttributeValue(48L);
        if (octetsIn != null && octetsOut != null) {
            req.overwriteAttribute(AttributeFactory.newAttribute((Long)42L, (Serializable)octetsOut));
            req.overwriteAttribute(AttributeFactory.newAttribute((Long)43L, (Serializable)octetsIn));
        }
        if (gigaIn != null && gigaOut != null) {
            req.overwriteAttribute(AttributeFactory.newAttribute((Long)52L, (Serializable)gigaOut));
            req.overwriteAttribute(AttributeFactory.newAttribute((Long)53L, (Serializable)gigaIn));
        }
        if (packetsIn != null && packetsOut != null) {
            req.overwriteAttribute(AttributeFactory.newAttribute((Long)47L, (Serializable)packetsOut));
            req.overwriteAttribute(AttributeFactory.newAttribute((Long)48L, (Serializable)packetsIn));
        }
    }
}

