/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.jradius.client.RadiusClient;
import net.jradius.client.RadiusClientTransport;
import net.jradius.client.TransportStatusListener;
import net.jradius.client.UDPClientTransport;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.client.auth.TunnelAuthenticator;
import net.jradius.client.gui.AttributesTableEntry;
import net.jradius.client.gui.AttributesTableModel;
import net.jradius.client.gui.LogConsole;
import net.jradius.dictionary.Attr_AcctSessionId;
import net.jradius.dictionary.Attr_AcctStatusType;
import net.jradius.exception.StandardViolatedException;
import net.jradius.exception.TimeoutException;
import net.jradius.exception.UnknownAttributeException;
import net.jradius.packet.AccessReject;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.AccountingResponse;
import net.jradius.packet.CoARequest;
import net.jradius.packet.DisconnectRequest;
import net.jradius.packet.PacketFactory;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSADictionary;
import net.jradius.packet.attribute.VSAttribute;
import net.jradius.packet.attribute.value.IntegerValue;
import net.jradius.packet.attribute.value.NamedValue;
import net.jradius.radsec.RadSecClientTransport;
import net.jradius.standard.IRAPStandard;
import net.jradius.standard.RadiusStandard;
import net.jradius.standard.WISPrStandard;
import net.jradius.util.Base64;
import net.jradius.util.KeyStoreUtil;
import net.jradius.util.RadiusRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRadiusSimulator
extends JFrame {
    private static final long serialVersionUID = 0L;
    public static final String logSepLine = "----------------------------------------------------------";
    private static String configFileUrl = "file:///" + System.getProperty("user.home") + "/.jRadiusSimulator";
    private String[] authTypeNames = new String[]{"PAP", "CHAP", "MSCHAPv1", "MSCHAPv2", "EAP-MD5", "EAP-MSCHAPv2", "EAP-TLS", "PEAP", "EAP-TTLS/PAP"};
    private String[] keystoreTypes = new String[]{"PEM", "PKCS12", "JKS"};
    private String[] transportTypes = new String[]{"UDP", "RadSec"};
    private Properties properties;
    private Thread[] simulationThreads = null;
    private SimulationRunner[] simulationRunners = null;
    private Thread simulationMonitor = null;
    boolean interactiveSession = false;
    private final HashMap namedValueComponentCache = new HashMap();
    private NumberFormatter numberFormatter;
    private PrintStream logSent;
    private PrintStream logRecv;
    private PrintStream logErr;
    private AttributesTableModel attributesTableModel = new AttributesTableModel();
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem saveMenuItem = null;
    private JMenuItem saveAsMenuItem = null;
    private JMenuItem openMenuItem = null;
    private JMenuItem openUrlMenuItem = null;
    private JTabbedPane mainTabPane = null;
    private JPanel radiusPanel = null;
    private JPanel diameterPanel = null;
    private JPanel dhcpPanel = null;
    private JPanel logPanel = null;
    private JPanel runStatusPanel = null;
    private LogConsole logConsole = null;
    private JPanel logButtonPanel = null;
    private JPanel mainContentPane = null;
    private JButton clearLogButton = null;
    private JButton saveLogButton = null;
    private JPanel runStatsPanel = null;
    private JLabel runStatsSent = null;
    private JLabel runStatsRecv = null;
    private JLabel runStatsTime = null;
    private JLabel runStatsRPS = null;
    private JLabel runStatsTime1 = null;
    private JLabel runStatsTime2 = null;
    private JLabel runStatsTime3 = null;
    private JLabel runStatsTime4 = null;
    private JLabel runStatsTime5 = null;
    private JLabel runStatsThreads = null;
    private JToggleButton runButton = null;
    private JScrollPane attributesTableScrollPane = null;
    private JTable attributesTable = null;
    private JPanel sendOptionsPanel = null;
    private JButton addAttributeButton = null;
    private JDialog addAttributeDialog = null;
    private JPanel addAttributeContentPane = null;
    private JTree attributeTree = null;
    private JPanel addAttributePanel = null;
    private JComboBox authTypeComboBox = null;
    private JComboBox checkStandardComboBox = null;
    private JPanel attributesPanel = null;
    private JPanel keysPanel = null;
    private JPanel keysOptionsPanel = null;
    private JTextField radiusServerTextField = null;
    private JTextField tlsKeyFileTextField = null;
    private JTextField tlsKeyPasswordTextField = null;
    private JTextField tlsCAFileTextField = null;
    private JTextField tlsCAPasswordTextField = null;
    private JFormattedTextField requestersTextField = null;
    private JFormattedTextField requestsTextField = null;
    private JComboBox tlsKeyFileTypeComboBox = null;
    private JComboBox tlsCAFileTypeComboBox = null;
    private JCheckBox tlsTrustAll = null;
    private JCheckBox tlsUseJavaRootCA = null;
    private JLabel radiusServerLabel = null;
    private JTextField sharedSecretTextField = null;
    private JButton doneButton = null;
    private JScrollPane attributeTreeScrollPane = null;
    private JPanel attributeTreeScrollPanel = null;
    private JButton addButton = null;
    private JComboBox simulationTypeComboBox = null;
    private JPanel attributesButtonPanel = null;
    private JButton removeAttributeButton = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JFormattedTextField radiusAuthPortTextField = null;
    private JFormattedTextField radiusAcctPortTextField = null;
    private JFormattedTextField radiusRetriesTextField = null;
    private JFormattedTextField radiusTimeoutTextField = null;
    private JFormattedTextField radiusInterimIntervalTextField = null;
    private JFormattedTextField sessionTimeTextField = null;
    private JCheckBox generateAcctSessionIdCheckBox = null;
    private JCheckBox doLogCheckBox = null;
    private JCheckBox floodCheckBox = null;
    private JCheckBox notStopOnRejectCheckBox = null;
    private JCheckBox notSendClassAttribute = null;
    private JDialog openUrlDialog = null;
    private JPanel openUrlContentPane = null;
    private JTextField openUrlTextField = null;
    private JButton openUrlButton = null;
    private JLabel openUrlStatusLabel = null;
    private JButton cancelUrlButton = null;
    private JLabel statusLabel = null;
    private JComboBox transportTypeComboBox = null;
    private boolean isJava14 = false;
    private boolean windows;

    public JRadiusSimulator() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.4")) {
            this.isJava14 = true;
            for (int i = 0; i < this.authTypeNames.length; ++i) {
                if (!this.authTypeNames[i].startsWith("EAP-T")) continue;
                int n = i;
                this.authTypeNames[n] = this.authTypeNames[n] + " (requires Java 1.5)";
            }
        }
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(650, 600);
        this.setContentPane(this.getMainContentPane());
        this.setTitle("JRadiusSimulator");
        this.setVisible(true);
        String osName = System.getProperty("os.name");
        this.windows = osName.indexOf("Windows") != -1;
        this.logSent = new PrintStream(this.logConsole.createFilteredStream("sent"));
        this.logRecv = new PrintStream(this.logConsole.createFilteredStream("recv"));
        this.logErr = new PrintStream(this.logConsole.createFilteredStream("err"));
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        try {
            this.loadConfigFile(configFileUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.statusLabel.setText("Ready");
        this.fileMenu.setEnabled(true);
        this.mainTabPane.setEnabled(true);
        this.runButton.setEnabled(true);
    }

    private void loadConfigFile(String url) throws IOException {
        this.properties = new Properties();
        this.loadConfigFile(new URL(url).openStream());
    }

    private void loadConfigFile(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
        String s = this.properties.getProperty("AttributesTableEntries");
        if (s != null) {
            this.attributesTableModel.setEntries((ArrayList)Base64.decodeToObject((String)s));
            this.attributesTableModel.fireTableDataChanged();
        }
        if ((s = this.properties.getProperty("RadiusServer")) != null) {
            this.radiusServerTextField.setText(s);
        }
        if ((s = this.properties.getProperty("SharedSecret")) != null) {
            this.sharedSecretTextField.setText(s);
        }
        if ((s = this.properties.getProperty("AuthPort")) != null) {
            this.radiusAuthPortTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("AcctPort")) != null) {
            this.radiusAcctPortTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("Retries")) != null) {
            this.radiusRetriesTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("Timeout")) != null) {
            this.radiusTimeoutTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("Requesters")) != null) {
            this.requestersTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("Requests")) != null) {
            this.requestsTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("SimulationType")) != null) {
            try {
                this.simulationTypeComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("AuthType")) != null) {
            try {
                this.authTypeComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("CheckStandard")) != null) {
            try {
                this.checkStandardComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("GenerateAcctSessionId")) != null) {
            try {
                this.generateAcctSessionIdCheckBox.setSelected(new Boolean(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("DoLog")) != null) {
            try {
                this.doLogCheckBox.setSelected(new Boolean(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("StopOnReject")) != null) {
            try {
                this.notStopOnRejectCheckBox.setSelected(new Boolean(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("SendClassAttr")) != null) {
            try {
                this.notSendClassAttribute.setSelected(new Boolean(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("TLSKeyFile")) != null) {
            this.tlsKeyFileTextField.setText(s);
        }
        if ((s = this.properties.getProperty("TLSKeyPassword")) != null) {
            this.tlsKeyPasswordTextField.setText(s);
        }
        if ((s = this.properties.getProperty("TLSCAFile")) != null) {
            this.tlsCAFileTextField.setText(s);
        }
        if ((s = this.properties.getProperty("TLSCAPassword")) != null) {
            this.tlsCAPasswordTextField.setText(s);
        }
        if ((s = this.properties.getProperty("TLSKeyFileType")) != null) {
            try {
                this.tlsKeyFileTypeComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("TLSCAFileType")) != null) {
            try {
                this.tlsCAFileTypeComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("TLSTrustAll")) != null) {
            try {
                this.tlsTrustAll.setSelected(new Boolean(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveConfigFile(String fileName) {
        try {
            String encodedAttributes = Base64.encodeObject((Serializable)this.attributesTableModel.getEntries(), (int)10);
            this.properties.setProperty("AttributesTableEntries", encodedAttributes);
            this.properties.setProperty("RadiusServer", this.radiusServerTextField.getText());
            this.properties.setProperty("SharedSecret", this.sharedSecretTextField.getText());
            this.properties.setProperty("SimulationType", "" + this.simulationTypeComboBox.getSelectedIndex());
            this.properties.setProperty("AuthType", "" + this.authTypeComboBox.getSelectedIndex());
            this.properties.setProperty("CheckStandard", "" + this.checkStandardComboBox.getSelectedIndex());
            this.properties.setProperty("AuthPort", ((Integer)this.radiusAuthPortTextField.getValue()).toString());
            this.properties.setProperty("AcctPort", ((Integer)this.radiusAcctPortTextField.getValue()).toString());
            this.properties.setProperty("Retries", ((Integer)this.radiusRetriesTextField.getValue()).toString());
            this.properties.setProperty("Timeout", ((Integer)this.radiusTimeoutTextField.getValue()).toString());
            this.properties.setProperty("Requesters", ((Integer)this.requestersTextField.getValue()).toString());
            this.properties.setProperty("Requests", ((Integer)this.requestsTextField.getValue()).toString());
            this.properties.setProperty("GenerateAcctSessionId", Boolean.toString(this.generateAcctSessionIdCheckBox.isSelected()));
            this.properties.setProperty("DoLog", Boolean.toString(this.doLogCheckBox.isSelected()));
            this.properties.setProperty("StopOnReject", Boolean.toString(this.notStopOnRejectCheckBox.isSelected()));
            this.properties.setProperty("SendClassAttr", Boolean.toString(this.notSendClassAttribute.isSelected()));
            this.properties.setProperty("TLSKeyFile", this.tlsKeyFileTextField.getText());
            this.properties.setProperty("TLSKeyPassword", this.tlsKeyPasswordTextField.getText());
            this.properties.setProperty("TLSCAFile", this.tlsCAFileTextField.getText());
            this.properties.setProperty("TLSCAPassword", this.tlsCAPasswordTextField.getText());
            this.properties.setProperty("TLSKeyFileType", "" + this.tlsKeyFileTypeComboBox.getSelectedIndex());
            this.properties.setProperty("TLSCAFileType", "" + this.tlsCAFileTypeComboBox.getSelectedIndex());
            this.properties.setProperty("TLSTrustAll", Boolean.toString(this.tlsTrustAll.isSelected()));
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            this.properties.store(fileOutputStream, "JRadiusSimulator");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setConfigFileUrl(String fileName) {
        configFileUrl = fileName;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getSaveMenuItem());
            this.fileMenu.add(this.getSaveAsMenuItem());
            this.fileMenu.add(this.getOpenMenuItem());
            this.fileMenu.add(this.getOpenUrlMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
            this.fileMenu.setEnabled(false);
        }
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(JRadiusSimulator.this, "Version 1.3.0\n\nFor help, go to http://www.coova.org/JRadius\nLicensed under the GNU General Public License (GPL).\nCopyright (c) 2007-2010 Coova Technologies, LLC\n", "Copyright (c) 2006 PicoPoint B.V.\nAbout JRadiusSimulator", 1, null);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText("Save");
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, true));
            this.saveMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (configFileUrl.startsWith("file:///")) {
                        JRadiusSimulator.this.saveConfigFile(configFileUrl.substring(7));
                    } else {
                        JRadiusSimulator.this.doSaveAs();
                    }
                }
            });
        }
        return this.saveMenuItem;
    }

    private JMenuItem getSaveAsMenuItem() {
        if (this.saveAsMenuItem == null) {
            this.saveAsMenuItem = new JMenuItem();
            this.saveAsMenuItem.setText("Save As");
            this.saveAsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.doSaveAs();
                }
            });
        }
        return this.saveAsMenuItem;
    }

    private void doSaveAs() {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            this.saveConfigFile(file.getAbsolutePath());
        }
    }

    private JMenuItem getOpenMenuItem() {
        if (this.openMenuItem == null) {
            this.openMenuItem = new JMenuItem();
            this.openMenuItem.setText("Open");
            this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, true));
            this.openMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showOpenDialog(JRadiusSimulator.this);
                    if (returnVal == 0) {
                        File file = chooser.getSelectedFile();
                        try {
                            JRadiusSimulator.this.loadConfigFile("file:///" + file.getAbsolutePath());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.openMenuItem;
    }

    private JMenuItem getOpenUrlMenuItem() {
        if (this.openUrlMenuItem == null) {
            this.openUrlMenuItem = new JMenuItem();
            this.openUrlMenuItem.setText("Open Url");
            this.openUrlMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.getOpenUrlDialog().setVisible(true);
                }
            });
        }
        return this.openUrlMenuItem;
    }

    private JTabbedPane getMainTabPane() {
        if (this.mainTabPane == null) {
            this.mainTabPane = new JTabbedPane();
            this.mainTabPane.addTab("RADIUS", null, this.getRADIUSPanel(), null);
            this.mainTabPane.addTab("Attributes", null, this.getAttributesPanel(), null);
            this.mainTabPane.addTab("Keys", null, this.getKeysPanel(), null);
            this.mainTabPane.addTab("Log", null, this.getLogPanel(), null);
            this.mainTabPane.setEnabled(false);
        }
        return this.mainTabPane;
    }

    private JPanel getRADIUSPanel() {
        if (this.radiusPanel == null) {
            this.radiusPanel = new JPanel();
            this.radiusPanel.setLayout(new BorderLayout());
            this.radiusPanel.add((Component)this.getRunStatusPanel(), "South");
            this.radiusPanel.add((Component)this.getSendOptionsPanel(), "North");
        }
        return this.radiusPanel;
    }

    private JPanel getDHCPPanel() {
        if (this.dhcpPanel == null) {
            this.dhcpPanel = new JPanel();
            this.dhcpPanel.setLayout(new BorderLayout());
        }
        return this.dhcpPanel;
    }

    private JPanel getDiameterPanel() {
        if (this.diameterPanel == null) {
            this.diameterPanel = new JPanel();
            this.diameterPanel.setLayout(new BorderLayout());
        }
        return this.diameterPanel;
    }

    private JPanel getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new JPanel();
            this.logPanel.setLayout(new BorderLayout());
            this.logPanel.add((Component)this.getLogConsole(), "Center");
            this.logPanel.add((Component)this.getLogButtonPanel(), "South");
        }
        return this.logPanel;
    }

    private JPanel getRunStatusPanel() {
        if (this.runStatusPanel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText("Initializing...");
            this.runStatusPanel = new JPanel();
            this.runStatusPanel.setLayout(new BorderLayout());
            this.runStatusPanel.add((Component)this.getRunStatsPanel(), "North");
            this.runStatusPanel.add((Component)this.getRunButton(), "East");
            this.runStatusPanel.add((Component)this.statusLabel, "Center");
        }
        return this.runStatusPanel;
    }

    private LogConsole getLogConsole() {
        if (this.logConsole == null) {
            this.logConsole = new LogConsole();
        }
        return this.logConsole;
    }

    private JPanel getLogButtonPanel() {
        if (this.logButtonPanel == null) {
            this.logButtonPanel = new JPanel();
            this.logButtonPanel.add((Component)this.getClearLogButton(), null);
            this.logButtonPanel.add((Component)this.getSaveLogButton(), null);
        }
        return this.logButtonPanel;
    }

    private JPanel getMainContentPane() {
        if (this.mainContentPane == null) {
            this.mainContentPane = new JPanel();
            this.mainContentPane.setLayout(new BorderLayout());
            this.mainContentPane.add((Component)this.getMainTabPane(), "Center");
        }
        return this.mainContentPane;
    }

    private JButton getClearLogButton() {
        if (this.clearLogButton == null) {
            this.clearLogButton = new JButton();
            this.clearLogButton.setText("Clear");
            this.clearLogButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.logConsole.setText("");
                }
            });
        }
        return this.clearLogButton;
    }

    private JButton getSaveLogButton() {
        if (this.saveLogButton == null) {
            this.saveLogButton = new JButton();
            this.saveLogButton.setText("Save");
            this.saveLogButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showSaveDialog(JRadiusSimulator.this);
                    if (returnVal == 0) {
                        File file = chooser.getSelectedFile();
                        try {
                            FileOutputStream out = new FileOutputStream(file);
                            out.write(JRadiusSimulator.this.logConsole.getText().getBytes());
                            out.close();
                        }
                        catch (Exception ex) {
                            System.err.println(ex.getMessage());
                        }
                    }
                }
            });
        }
        return this.saveLogButton;
    }

    private JToggleButton getRunButton() {
        if (this.runButton == null) {
            this.runButton = new JToggleButton();
            this.runButton.setText("Start");
            this.runButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractButton ab = (AbstractButton)e.getSource();
                    if (ab.isSelected()) {
                        JRadiusSimulator.this.simulationMonitor = new Thread(new SimulationMonitor());
                        JRadiusSimulator.access$702(JRadiusSimulator.this, new Thread[((Integer)JRadiusSimulator.this.requestersTextField.getValue()).intValue()]);
                        JRadiusSimulator.access$902(JRadiusSimulator.this, new SimulationRunner[((Integer)JRadiusSimulator.this.requestersTextField.getValue()).intValue()]);
                        for (int i = 0; i < JRadiusSimulator.this.simulationThreads.length; ++i) {
                            SimulationRunner simulationRunner = new SimulationRunner();
                            ((JRadiusSimulator)JRadiusSimulator.this).simulationRunners[i] = simulationRunner;
                            ((JRadiusSimulator)JRadiusSimulator.this).simulationThreads[i] = new Thread(simulationRunner);
                            JRadiusSimulator.this.simulationThreads[i].start();
                        }
                        JRadiusSimulator.this.simulationMonitor.start();
                        JRadiusSimulator.this.runButton.setText("Stop");
                    } else {
                        JRadiusSimulator.access$902(JRadiusSimulator.this, null);
                        if (JRadiusSimulator.this.simulationThreads != null) {
                            for (int i = 0; i < JRadiusSimulator.this.simulationThreads.length; ++i) {
                                JRadiusSimulator.this.simulationThreads[i].interrupt();
                            }
                        }
                        JRadiusSimulator.this.simulationMonitor.interrupt();
                        JRadiusSimulator.access$702(JRadiusSimulator.this, null);
                        JRadiusSimulator.this.simulationMonitor = null;
                        JRadiusSimulator.this.statusLabel.setText("Ready");
                        JRadiusSimulator.this.runButton.setText("Start");
                    }
                }
            });
            this.runButton.setEnabled(false);
        }
        return this.runButton;
    }

    private JScrollPane getAttributesTableScrollPane() {
        if (this.attributesTableScrollPane == null) {
            this.attributesTableScrollPane = new JScrollPane();
            this.attributesTableScrollPane.setViewportView(this.getAttributesTable());
        }
        return this.attributesTableScrollPane;
    }

    private JTable getAttributesTable() {
        if (this.attributesTable == null) {
            this.attributesTable = new JTable(this.attributesTableModel);
            TableColumn col = this.attributesTable.getColumnModel().getColumn(6);
            col.setCellEditor(new ValueTableCellEditor());
            for (int i = 0; i < this.attributesTableModel.getColumnCount(); ++i) {
                col = this.attributesTable.getColumnModel().getColumn(i);
                if (i == 0 || i == 6) {
                    col.setPreferredWidth(120);
                    continue;
                }
                col.setPreferredWidth(40);
            }
        }
        return this.attributesTable;
    }

    private JComboBox createNamedValueCellEditor(String attributeName) {
        JComboBox<String> comboBox = (JComboBox<String>)this.namedValueComponentCache.get(attributeName);
        if (comboBox != null) {
            return comboBox;
        }
        try {
            RadiusAttribute attribute = AttributeFactory.newAttribute((String)attributeName);
            NamedValue namedValue = (NamedValue)attribute.getValue();
            NamedValue.NamedValueMap valueMap = namedValue.getMap();
            Long[] possibleValues = valueMap.getKnownValues();
            comboBox = new JComboBox<String>();
            for (int i = 0; i < possibleValues.length; ++i) {
                comboBox.addItem(valueMap.getNamedValue(possibleValues[i]));
            }
            this.namedValueComponentCache.put(attributeName, comboBox);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return comboBox;
    }

    private JPanel getRunStatsPanel() {
        if (this.runStatsPanel == null) {
            this.runStatsPanel = new JPanel();
            this.runStatsPanel.setLayout(new FlowLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints1.weightx = 1.0;
            JPanel runStatsPanel1 = new JPanel();
            runStatsPanel1.setLayout(new GridBagLayout());
            runStatsPanel1.add((Component)new JLabel("Threads:"), gridBagConstraints);
            this.runStatsThreads = new JLabel();
            runStatsPanel1.add((Component)this.runStatsThreads, gridBagConstraints1);
            runStatsPanel1.add((Component)new JLabel("Sent:"), gridBagConstraints);
            this.runStatsSent = new JLabel();
            runStatsPanel1.add((Component)this.runStatsSent, gridBagConstraints1);
            runStatsPanel1.add((Component)new JLabel("Received:"), gridBagConstraints);
            this.runStatsRecv = new JLabel();
            runStatsPanel1.add((Component)this.runStatsRecv, gridBagConstraints1);
            runStatsPanel1.add((Component)new JLabel("Time:"), gridBagConstraints);
            this.runStatsTime = new JLabel();
            runStatsPanel1.add((Component)this.runStatsTime, gridBagConstraints1);
            runStatsPanel1.add((Component)new JLabel("Throughput:"), gridBagConstraints);
            this.runStatsRPS = new JLabel();
            runStatsPanel1.add((Component)this.runStatsRPS, gridBagConstraints1);
            JPanel runStatsPanel2 = new JPanel();
            runStatsPanel2.setLayout(new GridBagLayout());
            runStatsPanel2.add((Component)new JLabel("1 ms or less:"), gridBagConstraints);
            this.runStatsTime1 = new JLabel();
            runStatsPanel2.add((Component)this.runStatsTime1, gridBagConstraints1);
            runStatsPanel2.add((Component)new JLabel("10 ms or less:"), gridBagConstraints);
            this.runStatsTime2 = new JLabel();
            runStatsPanel2.add((Component)this.runStatsTime2, gridBagConstraints1);
            runStatsPanel2.add((Component)new JLabel("100 ms or less:"), gridBagConstraints);
            this.runStatsTime3 = new JLabel();
            runStatsPanel2.add((Component)this.runStatsTime3, gridBagConstraints1);
            runStatsPanel2.add((Component)new JLabel("1000 ms or less:"), gridBagConstraints);
            this.runStatsTime4 = new JLabel();
            runStatsPanel2.add((Component)this.runStatsTime4, gridBagConstraints1);
            runStatsPanel2.add((Component)new JLabel("10000 ms or less:"), gridBagConstraints);
            this.runStatsTime5 = new JLabel();
            runStatsPanel2.add((Component)this.runStatsTime5, gridBagConstraints1);
            this.clearStats();
            this.runStatsPanel.add(runStatsPanel1);
            this.runStatsPanel.add(runStatsPanel2);
        }
        return this.runStatsPanel;
    }

    private JPanel getSendOptionsPanel() {
        if (this.sendOptionsPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints1.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints3.weightx = 1.0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridwidth = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints5.weightx = 1.0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridwidth = 0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints7.weightx = 1.0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridwidth = 0;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints9.weightx = 1.0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridwidth = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints11.weightx = 1.0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridwidth = 0;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints13.weightx = 1.0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.anchor = 13;
            gridBagConstraints14.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridwidth = 0;
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints15.weightx = 1.0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridwidth = 0;
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.gridx = 1;
            JLabel authenticationProtocolLabel = new JLabel();
            authenticationProtocolLabel.setText("Authentication Protocol:");
            JLabel sharedSecretLabel = new JLabel();
            sharedSecretLabel.setText("Shared Secret:");
            this.radiusServerLabel = new JLabel();
            this.radiusServerLabel.setText("RADIUS Server:");
            JLabel simulationTypeLabel = new JLabel();
            simulationTypeLabel.setText("Simulation Type:");
            JLabel checkStandardLabel = new JLabel();
            checkStandardLabel.setText("Verify Standard:");
            JLabel radiusAuthPortLabel = new JLabel();
            radiusAuthPortLabel.setText("Auth Port:");
            JLabel radiusAcctPortLabel = new JLabel();
            radiusAcctPortLabel.setText("Acct Port:");
            JLabel radiusRetriesLabel = new JLabel();
            radiusRetriesLabel.setText("Send Retries:");
            JLabel radiusTimeoutLabel = new JLabel();
            radiusTimeoutLabel.setText("Send Timeout (sec):");
            JLabel radiusInterimIntervalLabel = new JLabel();
            radiusInterimIntervalLabel.setText("Interim Interval (sec):");
            JLabel sessionTimeLabel = new JLabel();
            sessionTimeLabel.setText("Session Duration (sec):");
            JLabel requestersLabel = new JLabel();
            requestersLabel.setText("Requester Threads:");
            JLabel requestsLabel = new JLabel();
            requestsLabel.setText("Requests per Thread:");
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.sendOptionsPanel = new JPanel();
            this.sendOptionsPanel.setLayout(gridBagLayout);
            this.sendOptionsPanel.add((Component)new JLabel("Transport"), gridBagConstraints);
            this.sendOptionsPanel.add((Component)this.getTransportTypeComboBox(), gridBagConstraints1);
            this.sendOptionsPanel.add((Component)this.radiusServerLabel, gridBagConstraints);
            this.sendOptionsPanel.add((Component)this.getRadiusServerTextField(), gridBagConstraints1);
            this.sendOptionsPanel.add((Component)sharedSecretLabel, gridBagConstraints2);
            this.sendOptionsPanel.add((Component)this.getSharedSecretTextField(), gridBagConstraints3);
            this.sendOptionsPanel.add((Component)radiusAuthPortLabel, gridBagConstraints8);
            this.sendOptionsPanel.add((Component)this.getRadiusAuthPortTextField(), gridBagConstraints9);
            this.sendOptionsPanel.add((Component)radiusAcctPortLabel, gridBagConstraints10);
            this.sendOptionsPanel.add((Component)this.getRadiusAcctPortTextField(), gridBagConstraints11);
            this.sendOptionsPanel.add((Component)radiusTimeoutLabel, gridBagConstraints12);
            this.sendOptionsPanel.add((Component)this.getRadiusTimeoutTextField(), gridBagConstraints13);
            this.sendOptionsPanel.add((Component)radiusRetriesLabel, gridBagConstraints12);
            this.sendOptionsPanel.add((Component)this.getRadiusRetriesTextField(), gridBagConstraints13);
            this.sendOptionsPanel.add((Component)requestersLabel, gridBagConstraints12);
            this.sendOptionsPanel.add((Component)this.getRequestersTextField(), gridBagConstraints13);
            this.sendOptionsPanel.add((Component)requestsLabel, gridBagConstraints12);
            this.sendOptionsPanel.add((Component)this.getRequestsTextField(), gridBagConstraints13);
            this.sendOptionsPanel.add((Component)simulationTypeLabel, gridBagConstraints4);
            this.sendOptionsPanel.add((Component)this.getSimulationTypeComboBox(), gridBagConstraints5);
            this.sendOptionsPanel.add((Component)authenticationProtocolLabel, gridBagConstraints6);
            this.sendOptionsPanel.add((Component)this.getAuthTypeComboBox(), gridBagConstraints7);
            this.sendOptionsPanel.add((Component)checkStandardLabel, gridBagConstraints6);
            this.sendOptionsPanel.add((Component)this.getCheckStandardComboBox(), gridBagConstraints7);
            this.sendOptionsPanel.add((Component)this.getOptionsLabel(), gridBagConstraints14);
            this.sendOptionsPanel.add((Component)this.getGenerateAcctSessionIdCheckBox(), gridBagConstraints15);
            this.sendOptionsPanel.add((Component)this.getNotStopOnRejectCheckBox(), gridBagConstraints16);
            this.sendOptionsPanel.add((Component)this.getSendClassAttributeCheckBox(), gridBagConstraints16);
            this.sendOptionsPanel.add((Component)this.getDoLogCheckBox(), gridBagConstraints16);
            this.sendOptionsPanel.add((Component)this.getFloodCheckBox(), gridBagConstraints16);
        }
        return this.sendOptionsPanel;
    }

    private JLabel getOptionsLabel() {
        JLabel optionsLabel = new JLabel();
        optionsLabel.setText("Options:");
        return optionsLabel;
    }

    private JButton getAddAttributeButton() {
        if (this.addAttributeButton == null) {
            this.addAttributeButton = new JButton();
            this.addAttributeButton.setText("Add Attribute");
            this.addAttributeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialog dialog = JRadiusSimulator.this.getAddAttributeDialog();
                    dialog.setModal(true);
                    dialog.setVisible(true);
                }
            });
        }
        return this.addAttributeButton;
    }

    private JDialog getAddAttributeDialog() {
        if (this.addAttributeDialog == null) {
            this.addAttributeDialog = new JDialog();
            this.addAttributeDialog.setSize(350, 300);
            this.addAttributeDialog.setTitle("Add Attributes");
            this.addAttributeDialog.setContentPane(this.getAddAttributeContentPane());
        }
        return this.addAttributeDialog;
    }

    private JPanel getAddAttributeContentPane() {
        if (this.addAttributeContentPane == null) {
            this.addAttributeContentPane = new JPanel();
            this.addAttributeContentPane.setLayout(new BorderLayout());
            this.addAttributeContentPane.add((Component)this.getAddAttributePanel(), "South");
            this.addAttributeContentPane.add((Component)this.getAttributeTreeScrollPane(), "Center");
        }
        return this.addAttributeContentPane;
    }

    private JTree getAttributeTree() {
        if (this.attributeTree == null) {
            DefaultMutableTreeNode top = new DefaultMutableTreeNode("Attribute Dictionary");
            this.createAttributeTreeNodes(top);
            this.attributeTree = new JTree(top);
        }
        return this.attributeTree;
    }

    private void createAttributeTreeNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode standardTree = new DefaultMutableTreeNode("Standard Attributes");
        DefaultMutableTreeNode vsaTree = new DefaultMutableTreeNode("Vendor Specific Attributes");
        this.addAttributesToTable(standardTree, AttributeFactory.getAttributeNameMap(), true);
        top.add(standardTree);
        LinkedHashMap vendors = AttributeFactory.getVendorValueMap();
        LinkedHashMap<String, Map> dictList = new LinkedHashMap<String, Map>();
        for (AttributeFactory.VendorValue vendor : vendors.values()) {
            try {
                VSADictionary dict = (VSADictionary)vendor.getDictClass().newInstance();
                String vendorName = dict.getVendorName();
                Map map = vendor.getAttributeNameMap();
                System.out.println("Loading vendor " + vendorName + " with " + map.size() + " attributes.");
                dictList.put(vendorName, map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LinkedList list = new LinkedList(dictList.keySet());
        Collections.sort(list);
        for (String vendorName : list) {
            DefaultMutableTreeNode vsaNode = new DefaultMutableTreeNode(vendorName);
            this.addAttributesToTable(vsaNode, (Map)dictList.get(vendorName), false);
            vsaTree.add(vsaNode);
        }
        top.add(vsaTree);
    }

    private void addAttributesToTable(DefaultMutableTreeNode node, Map<String, Class<?>> map, boolean skipVSA) {
        LinkedHashMap<String, String> attributeList = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
            String type = entry.getKey();
            Class<?> clazz = entry.getValue();
            try {
                String attributeName;
                RadiusAttribute attribute = (RadiusAttribute)clazz.newInstance();
                if (skipVSA && (attribute instanceof VSAttribute || attribute.getType() > 255L) || (attributeName = attribute.getAttributeName()).equals("Vendor-Specific") || attributeName.startsWith("X-Ascend-")) continue;
                attributeList.put(type, attributeName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LinkedList list = new LinkedList(attributeList.keySet());
        Collections.sort(list);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            node.add(new DefaultMutableTreeNode(attributeList.get(i.next())));
        }
    }

    private JPanel getAddAttributePanel() {
        if (this.addAttributePanel == null) {
            this.addAttributePanel = new JPanel();
            this.addAttributePanel.add((Component)this.getAddButton(), null);
            this.addAttributePanel.add((Component)this.getDoneButton(), null);
        }
        return this.addAttributePanel;
    }

    private JComboBox getAuthTypeComboBox() {
        if (this.authTypeComboBox == null) {
            this.authTypeComboBox = new JComboBox<String>(this.authTypeNames);
        }
        return this.authTypeComboBox;
    }

    private RadiusAuthenticator getAuthenticator() throws Exception {
        String authName = this.authTypeNames[this.authTypeComboBox.getSelectedIndex()];
        if (authName.startsWith("EAP-T") || authName.startsWith("PEAP")) {
            if (this.isJava14) {
                throw new Exception(authName + " not available with this Java version");
            }
            String[] s = authName.split("/");
            StringBuffer sb = new StringBuffer(s[0]);
            String v = this.tlsKeyFileTextField.getText();
            if (v != null && !"".equals(v)) {
                sb.append(":keyFile=").append(v);
            }
            if ((v = (String)this.tlsKeyFileTypeComboBox.getSelectedItem()) != null && !"".equals(v)) {
                sb.append(":keyFileType=").append(v);
            }
            if ((v = this.tlsKeyPasswordTextField.getText()) != null && !"".equals(v)) {
                sb.append(":keyPassword=").append(v);
            }
            if ((v = this.tlsCAFileTextField.getText()) != null && !"".equals(v)) {
                sb.append(":caFile=").append(v);
            }
            if ((v = (String)this.tlsCAFileTypeComboBox.getSelectedItem()) != null && !"".equals(v)) {
                sb.append(":caFileType=").append(v);
            }
            if ((v = this.tlsCAPasswordTextField.getText()) != null && !"".equals(v)) {
                sb.append(":caPassword=").append(v);
            }
            if (this.tlsTrustAll.isSelected()) {
                sb.append(":trustAll=true");
            }
            if (s.length == 2) {
                sb.append(":innerProtocol=").append(s[1]);
            }
            authName = sb.toString();
            System.out.println("Using Authenticator String: " + authName);
        }
        return RadiusClient.getAuthProtocol((String)authName);
    }

    private JComboBox getCheckStandardComboBox() {
        if (this.checkStandardComboBox == null) {
            this.checkStandardComboBox = new JComboBox<String>(new String[]{"None", "IRAP", "WISPr"});
        }
        return this.checkStandardComboBox;
    }

    private JComboBox getTLSCAFileTypeComboBox() {
        if (this.tlsCAFileTypeComboBox == null) {
            this.tlsCAFileTypeComboBox = new JComboBox<String>(this.keystoreTypes);
        }
        return this.tlsCAFileTypeComboBox;
    }

    private JComboBox getTLSKeyFileTypeComboBox() {
        if (this.tlsKeyFileTypeComboBox == null) {
            this.tlsKeyFileTypeComboBox = new JComboBox<String>(this.keystoreTypes);
        }
        return this.tlsKeyFileTypeComboBox;
    }

    private JComboBox getTransportTypeComboBox() {
        if (this.transportTypeComboBox == null) {
            this.transportTypeComboBox = new JComboBox<String>(this.transportTypes);
        }
        return this.transportTypeComboBox;
    }

    private JPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new JPanel();
            this.attributesPanel.setLayout(new BorderLayout());
            this.attributesPanel.add((Component)this.getAttributesTableScrollPane(), "Center");
            this.attributesPanel.add((Component)this.getAttributesButtonPanel(), "South");
        }
        return this.attributesPanel;
    }

    private JPanel getKeysPanel() {
        if (this.keysPanel == null) {
            this.keysPanel = new JPanel();
            this.keysPanel.setLayout(new BorderLayout());
            this.keysPanel.add((Component)this.getKeysOptionsPanel(), "North");
        }
        return this.keysPanel;
    }

    private JPanel getKeysOptionsPanel() {
        if (this.keysOptionsPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraintsH = new GridBagConstraints();
            gridBagConstraintsH.insets = new Insets(10, 10, 5, 10);
            gridBagConstraintsH.gridwidth = 0;
            GridBagConstraints gridBagConstraints0 = new GridBagConstraints();
            gridBagConstraints0.fill = 2;
            gridBagConstraints0.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints0.gridwidth = 0;
            gridBagConstraints0.weightx = 1.0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints1.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.keysOptionsPanel = new JPanel();
            this.keysOptionsPanel.setLayout(gridBagLayout);
            this.keysOptionsPanel.add((Component)new JLabel("Client Certificate Java Keystore"), gridBagConstraintsH);
            this.keysOptionsPanel.add((Component)new JLabel("File:"), gridBagConstraints);
            this.keysOptionsPanel.add((Component)this.getTLSKeyFileTextField(), gridBagConstraints0);
            this.keysOptionsPanel.add((Component)new JLabel("Password:"), gridBagConstraints);
            this.keysOptionsPanel.add((Component)this.getTLSKeyPasswordTextField(), gridBagConstraints1);
            this.keysOptionsPanel.add((Component)new JLabel("Type:"), gridBagConstraints4);
            this.keysOptionsPanel.add((Component)this.getTLSKeyFileTypeComboBox(), gridBagConstraints2);
            this.keysOptionsPanel.add((Component)new JLabel("Root CA Chain Java Keystore"), gridBagConstraintsH);
            this.keysOptionsPanel.add((Component)new JLabel("File:"), gridBagConstraints);
            this.keysOptionsPanel.add((Component)this.getTLSCAFileTextField(), gridBagConstraints0);
            this.keysOptionsPanel.add((Component)new JLabel("Password:"), gridBagConstraints);
            this.keysOptionsPanel.add((Component)this.getTLSCAPasswordTextField(), gridBagConstraints1);
            this.keysOptionsPanel.add((Component)new JLabel("Type:"), gridBagConstraints4);
            this.keysOptionsPanel.add((Component)this.getTLSCAFileTypeComboBox(), gridBagConstraints2);
            this.keysOptionsPanel.add((Component)this.getOptionsLabel(), gridBagConstraints);
            this.keysOptionsPanel.add((Component)this.getTLSTrustAllCheckBox(), gridBagConstraints2);
        }
        return this.keysOptionsPanel;
    }

    private JTextField getTLSKeyFileTextField() {
        if (this.tlsKeyFileTextField == null) {
            this.tlsKeyFileTextField = new JTextField(100);
        }
        return this.tlsKeyFileTextField;
    }

    private JTextField getTLSKeyPasswordTextField() {
        if (this.tlsKeyPasswordTextField == null) {
            this.tlsKeyPasswordTextField = new JTextField(100);
        }
        return this.tlsKeyPasswordTextField;
    }

    private JTextField getTLSCAFileTextField() {
        if (this.tlsCAFileTextField == null) {
            this.tlsCAFileTextField = new JTextField(100);
        }
        return this.tlsCAFileTextField;
    }

    private JTextField getTLSCAPasswordTextField() {
        if (this.tlsCAPasswordTextField == null) {
            this.tlsCAPasswordTextField = new JTextField(100);
        }
        return this.tlsCAPasswordTextField;
    }

    private JTextField getRadiusServerTextField() {
        if (this.radiusServerTextField == null) {
            this.radiusServerTextField = new JTextField(100);
        }
        return this.radiusServerTextField;
    }

    private JTextField getSharedSecretTextField() {
        if (this.sharedSecretTextField == null) {
            this.sharedSecretTextField = new JTextField(40);
        }
        return this.sharedSecretTextField;
    }

    private JButton getDoneButton() {
        if (this.doneButton == null) {
            this.doneButton = new JButton();
            this.doneButton.setText("Done");
            this.doneButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.addAttributeDialog.dispose();
                }
            });
        }
        return this.doneButton;
    }

    private JScrollPane getAttributeTreeScrollPane() {
        if (this.attributeTreeScrollPane == null) {
            this.attributeTreeScrollPane = new JScrollPane();
            this.attributeTreeScrollPane.setViewportView(this.getAttributeTreeScrollPanel());
        }
        return this.attributeTreeScrollPane;
    }

    private JPanel getAttributeTreeScrollPanel() {
        if (this.attributeTreeScrollPanel == null) {
            this.attributeTreeScrollPanel = new JPanel();
            this.attributeTreeScrollPanel.add((Component)this.getAttributeTree(), null);
        }
        return this.attributeTreeScrollPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] rows = JRadiusSimulator.this.attributeTree.getSelectionRows();
                    if (rows != null) {
                        for (int i = 0; i < rows.length; ++i) {
                            TreePath path = JRadiusSimulator.this.attributeTree.getPathForRow(rows[i]);
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
                            String attr = (String)node.getUserObject();
                            try {
                                JRadiusSimulator.this.attributesTableModel.addAttribute(AttributeFactory.newAttribute((String)attr));
                                continue;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        JRadiusSimulator.this.attributesTableModel.fireTableDataChanged();
                    }
                }
            });
        }
        return this.addButton;
    }

    private JComboBox getSimulationTypeComboBox() {
        if (this.simulationTypeComboBox == null) {
            this.simulationTypeComboBox = new JComboBox<String>(new String[]{"Auth Only", "Auth & Acct (Start, Interim, Stop)", "Auth & Acct (Start, Stop)", "Auth & Acct (Start Only)", "Acct Only (Start, Interim, Stop)", "Acct Only (Stop Only)", "Disconnect Request", "CoA Request"});
        }
        return this.simulationTypeComboBox;
    }

    private JPanel getAttributesButtonPanel() {
        if (this.attributesButtonPanel == null) {
            this.attributesButtonPanel = new JPanel();
            this.attributesButtonPanel.add((Component)this.getAddAttributeButton(), null);
            this.attributesButtonPanel.add((Component)this.getMoveUpButton(), null);
            this.attributesButtonPanel.add((Component)this.getMoveDownButton(), null);
            this.attributesButtonPanel.add((Component)this.getRemoveAttributeButton(), null);
        }
        return this.attributesButtonPanel;
    }

    private JButton getRemoveAttributeButton() {
        if (this.removeAttributeButton == null) {
            this.removeAttributeButton = new JButton();
            this.removeAttributeButton.setText("Remove Attribute");
            this.removeAttributeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selectedIndex = JRadiusSimulator.this.attributesTable.getSelectedRows();
                    if (selectedIndex == null) {
                        return;
                    }
                    for (int i = 0; i < selectedIndex.length; ++i) {
                        JRadiusSimulator.this.attributesTableModel.getEntries().remove(selectedIndex[i]);
                    }
                    JRadiusSimulator.this.attributesTableModel.fireTableDataChanged();
                }
            });
        }
        return this.removeAttributeButton;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton();
            this.moveUpButton.setText("Move Up");
            this.moveUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = JRadiusSimulator.this.attributesTable.getSelectedRow();
                    if (selectedIndex <= 0) {
                        return;
                    }
                    ArrayList list = JRadiusSimulator.this.attributesTableModel.getEntries();
                    ArrayList<Object> newList = new ArrayList<Object>();
                    Object[] oList = list.toArray();
                    Object selectedObject = null;
                    for (int i = 0; i < oList.length; ++i) {
                        if (i == selectedIndex) {
                            newList.add(oList[i]);
                            newList.add(selectedObject);
                            continue;
                        }
                        if (i == selectedIndex - 1) {
                            selectedObject = oList[i];
                            continue;
                        }
                        newList.add(oList[i]);
                    }
                    JRadiusSimulator.this.attributesTableModel.setEntries(newList);
                    JRadiusSimulator.this.attributesTableModel.fireTableDataChanged();
                    JRadiusSimulator.this.attributesTable.setRowSelectionInterval(--selectedIndex, selectedIndex);
                }
            });
        }
        return this.moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton();
            this.moveDownButton.setText("Move Down");
            this.moveDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = JRadiusSimulator.this.attributesTable.getSelectedRow();
                    if (selectedIndex == -1) {
                        return;
                    }
                    ArrayList list = JRadiusSimulator.this.attributesTableModel.getEntries();
                    if (selectedIndex >= list.size() - 1) {
                        return;
                    }
                    ArrayList<Object> newList = new ArrayList<Object>();
                    Object[] oList = list.toArray();
                    Object selectedObject = null;
                    for (int i = 0; i < oList.length; ++i) {
                        if (i == selectedIndex) {
                            selectedObject = oList[i];
                            continue;
                        }
                        if (i == selectedIndex + 1) {
                            newList.add(oList[i]);
                            newList.add(selectedObject);
                            continue;
                        }
                        newList.add(oList[i]);
                    }
                    JRadiusSimulator.this.attributesTableModel.setEntries(newList);
                    JRadiusSimulator.this.attributesTableModel.fireTableDataChanged();
                    JRadiusSimulator.this.attributesTable.setRowSelectionInterval(++selectedIndex, selectedIndex);
                }
            });
        }
        return this.moveDownButton;
    }

    private JCheckBox getGenerateAcctSessionIdCheckBox() {
        if (this.generateAcctSessionIdCheckBox == null) {
            this.generateAcctSessionIdCheckBox = new JCheckBox();
            this.generateAcctSessionIdCheckBox.setText("Generate Unique Acct-Session-Id");
        }
        return this.generateAcctSessionIdCheckBox;
    }

    private JCheckBox getDoLogCheckBox() {
        if (this.doLogCheckBox == null) {
            this.doLogCheckBox = new JCheckBox();
            this.doLogCheckBox.setText("Log RADIUS to Log tab");
        }
        return this.doLogCheckBox;
    }

    private JCheckBox getFloodCheckBox() {
        if (this.floodCheckBox == null) {
            this.floodCheckBox = new JCheckBox();
            this.floodCheckBox.setText("Flood (don't wait for reply)");
        }
        return this.floodCheckBox;
    }

    private JCheckBox getUseJavaRootCAChainCheckBox() {
        if (this.tlsUseJavaRootCA == null) {
            this.tlsUseJavaRootCA = new JCheckBox();
            this.tlsUseJavaRootCA.setText("Use Java's Root CA Chain");
        }
        return this.tlsUseJavaRootCA;
    }

    private JCheckBox getTLSTrustAllCheckBox() {
        if (this.tlsTrustAll == null) {
            this.tlsTrustAll = new JCheckBox();
            this.tlsTrustAll.setText("Trust All Server Certificates");
        }
        return this.tlsTrustAll;
    }

    private JCheckBox getNotStopOnRejectCheckBox() {
        if (this.notStopOnRejectCheckBox == null) {
            this.notStopOnRejectCheckBox = new JCheckBox();
            this.notStopOnRejectCheckBox.setText("Don't Stop Simulation On AccessReject");
        }
        return this.notStopOnRejectCheckBox;
    }

    private JCheckBox getSendClassAttributeCheckBox() {
        if (this.notSendClassAttribute == null) {
            this.notSendClassAttribute = new JCheckBox();
            this.notSendClassAttribute.setText("Don't Send The Received Class Attribute");
        }
        return this.notSendClassAttribute;
    }

    public NumberFormatter getNumberFormatter() {
        if (this.numberFormatter == null) {
            this.numberFormatter = new NumberFormatter(NumberFormat.getIntegerInstance());
            this.numberFormatter.setValueClass(Integer.class);
        }
        return this.numberFormatter;
    }

    private JFormattedTextField getRadiusAuthPortTextField() {
        if (this.radiusAuthPortTextField == null) {
            this.radiusAuthPortTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusAuthPortTextField.setValue(new Integer(1812));
        }
        return this.radiusAuthPortTextField;
    }

    private JFormattedTextField getRadiusAcctPortTextField() {
        if (this.radiusAcctPortTextField == null) {
            this.radiusAcctPortTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusAcctPortTextField.setValue(new Integer(1813));
        }
        return this.radiusAcctPortTextField;
    }

    private JFormattedTextField getRadiusRetriesTextField() {
        if (this.radiusRetriesTextField == null) {
            this.radiusRetriesTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusRetriesTextField.setValue(new Integer(0));
        }
        return this.radiusRetriesTextField;
    }

    private JFormattedTextField getRequestersTextField() {
        if (this.requestersTextField == null) {
            this.requestersTextField = new JFormattedTextField(this.getNumberFormatter());
            this.requestersTextField.setValue(new Integer(1));
        }
        return this.requestersTextField;
    }

    private JFormattedTextField getRequestsTextField() {
        if (this.requestsTextField == null) {
            this.requestsTextField = new JFormattedTextField(this.getNumberFormatter());
            this.requestsTextField.setValue(new Integer(1));
        }
        return this.requestsTextField;
    }

    private JFormattedTextField getRadiusTimeoutTextField() {
        if (this.radiusTimeoutTextField == null) {
            this.radiusTimeoutTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusTimeoutTextField.setValue(new Integer(10));
        }
        return this.radiusTimeoutTextField;
    }

    private JFormattedTextField getRadiusInterimIntervalTextField() {
        if (this.radiusInterimIntervalTextField == null) {
            this.radiusInterimIntervalTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusInterimIntervalTextField.setValue(new Integer(60));
        }
        return this.radiusInterimIntervalTextField;
    }

    private JFormattedTextField getSessionTimeTextField() {
        if (this.sessionTimeTextField == null) {
            this.sessionTimeTextField = new JFormattedTextField(this.getNumberFormatter());
            this.sessionTimeTextField.setValue(new Integer(60));
        }
        return this.sessionTimeTextField;
    }

    private void checkStandard(RadiusStandard radiusStandard, RadiusPacket p) {
        if (radiusStandard != null) {
            try {
                radiusStandard.checkPacket(p);
            }
            catch (StandardViolatedException e) {
                this.statusLabel.setText(radiusStandard.getName() + " standard violated");
                this.logErr.println(radiusStandard.getName() + " Standard Violated: " + p.getClass().getName());
                this.logErr.println(logSepLine);
                this.logErr.println("Missing attributes:");
                this.logErr.println(e.listAttributes("\n") + "\n");
                this.logErr.flush();
            }
        }
    }

    private RadiusStandard getRadiusStandard() {
        switch (this.checkStandardComboBox.getSelectedIndex()) {
            case 1: {
                return new IRAPStandard();
            }
            case 2: {
                return new WISPrStandard();
            }
        }
        return null;
    }

    private JDialog getOpenUrlDialog() {
        if (this.openUrlDialog == null) {
            this.openUrlDialog = new JDialog();
            this.openUrlDialog.setContentPane(this.getOpenUrlContentPane());
            this.openUrlDialog.setSize(425, 125);
        }
        this.openUrlStatusLabel.setText("Enter the URL of the configuration file:");
        this.openUrlTextField.setText("http://");
        return this.openUrlDialog;
    }

    private JPanel getOpenUrlContentPane() {
        if (this.openUrlContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(25, 25, 10, 25);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 25, 0, 5);
            gridBagConstraints1.anchor = 13;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 25);
            gridBagConstraints2.weightx = 1.0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.insets = new Insets(0, 25, 25, 25);
            JLabel openUrlLabel = new JLabel();
            openUrlLabel.setText("URL:");
            this.openUrlStatusLabel = new JLabel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.openUrlContentPane = new JPanel();
            this.openUrlContentPane.setLayout(gridBagLayout);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add((Component)this.getOpenUrlButton(), null);
            buttonPanel.add((Component)this.getCancelUrlButton(), null);
            this.openUrlContentPane.add((Component)this.openUrlStatusLabel, gridBagConstraints);
            this.openUrlContentPane.add((Component)openUrlLabel, gridBagConstraints1);
            this.openUrlContentPane.add((Component)this.getOpenUrlTextField(), gridBagConstraints2);
            this.openUrlContentPane.add((Component)buttonPanel, gridBagConstraints3);
        }
        return this.openUrlContentPane;
    }

    private JTextField getOpenUrlTextField() {
        if (this.openUrlTextField == null) {
            this.openUrlTextField = new JTextField();
        }
        return this.openUrlTextField;
    }

    private JButton getOpenUrlButton() {
        if (this.openUrlButton == null) {
            this.openUrlButton = new JButton();
            this.openUrlButton.setText("Open");
            this.openUrlButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JRadiusSimulator.this.loadConfigFile(JRadiusSimulator.this.openUrlTextField.getText());
                    }
                    catch (FileNotFoundException ex) {
                        JRadiusSimulator.this.openUrlStatusLabel.setText("Not found: " + ex.getMessage());
                        return;
                    }
                    catch (ConnectException ex) {
                        JRadiusSimulator.this.openUrlStatusLabel.setText("Open Failed: " + ex.getMessage());
                        return;
                    }
                    catch (Exception ex) {
                        JRadiusSimulator.this.openUrlStatusLabel.setText(ex.getMessage());
                        ex.printStackTrace();
                        return;
                    }
                    JRadiusSimulator.this.openUrlDialog.dispose();
                }
            });
        }
        return this.openUrlButton;
    }

    private JButton getCancelUrlButton() {
        if (this.cancelUrlButton == null) {
            this.cancelUrlButton = new JButton();
            this.cancelUrlButton.setText("Cancel");
            this.cancelUrlButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.openUrlDialog.dispose();
                }
            });
        }
        return this.cancelUrlButton;
    }

    public static void main(String[] args) {
        System.setProperty("org.apache.commons.logging.LogFactory", "net.jradius.client.gui.LogFactory");
        if (args.length > 0) {
            String url = args[0];
            File file = new File(url);
            if (file.exists()) {
                url = "file:///" + file.getAbsolutePath();
            }
            JRadiusSimulator.setConfigFileUrl(url);
        }
        JRadiusSimulator application = new JRadiusSimulator();
        application.setVisible(true);
    }

    public boolean isWindows() {
        return this.windows;
    }

    public byte[] toBinArray(String hexStr) {
        hexStr = hexStr.replace("0x", "");
        byte[] bArray = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            byte firstNibble = Byte.parseByte(hexStr.substring(2 * i, 2 * i + 1), 16);
            byte secondNibble = Byte.parseByte(hexStr.substring(2 * i + 1, 2 * i + 2), 16);
            int finalByte = secondNibble | firstNibble << 4;
            bArray[i] = (byte)finalByte;
        }
        return bArray;
    }

    public void clearStats() {
        this.runStatsThreads.setText("-");
        this.runStatsSent.setText("-");
        this.runStatsRecv.setText("-");
        this.runStatsTime.setText("-");
        this.runStatsRPS.setText("-");
        this.runStatsTime1.setText("-");
        this.runStatsTime2.setText("-");
        this.runStatsTime3.setText("-");
        this.runStatsTime4.setText("-");
        this.runStatsTime5.setText("-");
    }

    static /* synthetic */ Thread[] access$702(JRadiusSimulator x0, Thread[] x1) {
        x0.simulationThreads = x1;
        return x1;
    }

    static /* synthetic */ SimulationRunner[] access$902(JRadiusSimulator x0, SimulationRunner[] x1) {
        x0.simulationRunners = x1;
        return x1;
    }

    class SimulationRunner
    implements Runnable {
        protected int sent = 0;
        protected int recd = 0;
        protected int accepts = 0;
        protected double requestPerSecond = 0.0;
        protected long[] pkts = new long[10];

        SimulationRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final boolean doLog = JRadiusSimulator.this.doLogCheckBox.isSelected();
            int id = 0;
            String radiusServer = JRadiusSimulator.this.radiusServerTextField.getText();
            String sharedSecret = JRadiusSimulator.this.sharedSecretTextField.getText();
            Integer authPort = (Integer)JRadiusSimulator.this.radiusAuthPortTextField.getValue();
            Integer acctPort = (Integer)JRadiusSimulator.this.radiusAcctPortTextField.getValue();
            Integer timeout = (Integer)JRadiusSimulator.this.radiusTimeoutTextField.getValue();
            Integer retries = (Integer)JRadiusSimulator.this.radiusRetriesTextField.getValue();
            Integer requests = (Integer)JRadiusSimulator.this.requestsTextField.getValue();
            if (radiusServer == null || sharedSecret == null || "".equals(radiusServer) || "".equals(sharedSecret)) {
                JRadiusSimulator.this.statusLabel.setText("The RADIUS Server and Shared Secret are required");
                return;
            }
            if (authPort == null || acctPort == null) {
                JRadiusSimulator.this.statusLabel.setText("The Auth Port and Acct Port must be set");
                return;
            }
            AttributeList[] authAttributes = new AttributeList[]{new AttributeList(), new AttributeList()};
            AttributeList[] acctAttributes = new AttributeList[]{new AttributeList(), new AttributeList(), new AttributeList()};
            Object[] entries = JRadiusSimulator.this.attributesTableModel.getEntries().toArray();
            for (int i = 0; i < entries.length; ++i) {
                AttributesTableEntry entry = (AttributesTableEntry)entries[i];
                try {
                    RadiusAttribute attribute = AttributeFactory.newAttribute((String)entry.getAttributeName(), (String)entry.getAttributeValue(), (String)"=");
                    Boolean bool = entry.getAccessRequest();
                    if (bool != null && bool.booleanValue()) {
                        authAttributes[0].add(AttributeFactory.copyAttribute((RadiusAttribute)attribute), false);
                    }
                    if ((bool = entry.getTunnelRequest()) != null && bool.booleanValue()) {
                        authAttributes[1].add(AttributeFactory.copyAttribute((RadiusAttribute)attribute), false);
                    }
                    if ((bool = entry.getAccountingStart()) != null && bool.booleanValue()) {
                        acctAttributes[0].add(AttributeFactory.copyAttribute((RadiusAttribute)attribute), false);
                    }
                    if ((bool = entry.getAccountingUpdate()) != null && bool.booleanValue()) {
                        acctAttributes[1].add(AttributeFactory.copyAttribute((RadiusAttribute)attribute), false);
                    }
                    if ((bool = entry.getAccountingStop()) == null || !bool.booleanValue()) continue;
                    acctAttributes[2].add(AttributeFactory.copyAttribute((RadiusAttribute)attribute), false);
                    continue;
                }
                catch (UnknownAttributeException e) {
                    e.printStackTrace();
                }
            }
            boolean[] sendPackets = new boolean[]{true, false, false, false};
            boolean sendDisconnectRequest = false;
            boolean sendCoARequest = false;
            boolean simulationSuccess = true;
            JRadiusSimulator.this.interactiveSession = false;
            switch (JRadiusSimulator.this.simulationTypeComboBox.getSelectedIndex()) {
                case 1: {
                    sendPackets[3] = true;
                    sendPackets[2] = true;
                    sendPackets[1] = true;
                    break;
                }
                case 2: {
                    sendPackets[3] = true;
                    sendPackets[1] = true;
                    break;
                }
                case 3: {
                    sendPackets[1] = true;
                    break;
                }
                case 4: {
                    sendPackets = new boolean[]{false, true, true, true};
                    break;
                }
                case 5: {
                    sendPackets = new boolean[]{false, false, false, true};
                    break;
                }
                case 6: {
                    sendDisconnectRequest = true;
                    break;
                }
                case 7: {
                    sendCoARequest = true;
                }
            }
            long startTime = System.currentTimeMillis();
            for (int r = 0; r < requests; ++r) {
                Object transport = null;
                RadiusClient radiusClient = null;
                try {
                    if ("RadSec".equals(JRadiusSimulator.this.transportTypeComboBox.getSelectedItem())) {
                        KeyManager[] keyManagers = KeyStoreUtil.loadKeyManager(JRadiusSimulator.this.tlsKeyFileTypeComboBox.getSelectedItem().toString(), new FileInputStream(JRadiusSimulator.this.tlsKeyFileTextField.getText()), JRadiusSimulator.this.tlsKeyPasswordTextField.getText());
                        TrustManager[] trustManagers = JRadiusSimulator.this.tlsTrustAll.isSelected() ? KeyStoreUtil.trustAllManager() : KeyStoreUtil.loadTrustManager(JRadiusSimulator.this.tlsCAFileTypeComboBox.getSelectedItem().toString(), new FileInputStream(JRadiusSimulator.this.tlsCAFileTextField.getText()), JRadiusSimulator.this.tlsCAPasswordTextField.getText());
                        transport = new RadSecClientTransport(keyManagers, trustManagers);
                    } else {
                        transport = new UDPClientTransport();
                    }
                    transport.setRemoteInetAddress(InetAddress.getByName(radiusServer));
                    transport.setSharedSecret(sharedSecret);
                    transport.setAuthPort(authPort.intValue());
                    transport.setAcctPort(acctPort.intValue());
                    transport.setSocketTimeout(timeout.intValue());
                    transport.setStatusListener(new TransportStatusListener(){
                        long t = 0L;

                        public void onAfterReceive(RadiusClientTransport transport, RadiusPacket packet) {
                            long d;
                            if (doLog) {
                                JRadiusSimulator.this.statusLabel.setText("Received RADIUS Packet " + packet.getClass().getName());
                                JRadiusSimulator.this.logRecv.println("Received RADIUS Packet:");
                                JRadiusSimulator.this.logRecv.println(JRadiusSimulator.logSepLine);
                                JRadiusSimulator.this.logRecv.println(packet.toString());
                                JRadiusSimulator.this.logRecv.flush();
                                JRadiusSimulator.this.checkStandard(JRadiusSimulator.this.getRadiusStandard(), packet);
                            }
                            if ((d = System.currentTimeMillis() - this.t) <= 1L) {
                                SimulationRunner.this.pkts[0] = SimulationRunner.this.pkts[0] + 1L;
                            } else if (d <= 10L) {
                                SimulationRunner.this.pkts[1] = SimulationRunner.this.pkts[1] + 1L;
                            } else if (d <= 100L) {
                                SimulationRunner.this.pkts[2] = SimulationRunner.this.pkts[2] + 1L;
                            } else if (d <= 1000L) {
                                SimulationRunner.this.pkts[3] = SimulationRunner.this.pkts[3] + 1L;
                            } else if (d <= 10000L) {
                                SimulationRunner.this.pkts[4] = SimulationRunner.this.pkts[4] + 1L;
                            } else if (d <= 100000L) {
                                SimulationRunner.this.pkts[5] = SimulationRunner.this.pkts[5] + 1L;
                            } else if (d <= 1000000L) {
                                SimulationRunner.this.pkts[6] = SimulationRunner.this.pkts[6] + 1L;
                            }
                            ++SimulationRunner.this.recd;
                        }

                        public void onAfterSend(RadiusClientTransport transport) {
                        }

                        public void onBeforeReceive(RadiusClientTransport transport) {
                            if (doLog) {
                                JRadiusSimulator.this.statusLabel.setText("Waiting for response...");
                            }
                        }

                        public void onBeforeSend(RadiusClientTransport transport, RadiusPacket packet) {
                            if (doLog) {
                                JRadiusSimulator.this.logSent.println("Sending RADIUS Packet:");
                                JRadiusSimulator.this.logSent.println(JRadiusSimulator.logSepLine);
                                JRadiusSimulator.this.logSent.println(packet.toString());
                                JRadiusSimulator.this.logSent.flush();
                                JRadiusSimulator.this.checkStandard(JRadiusSimulator.this.getRadiusStandard(), packet);
                                JRadiusSimulator.this.statusLabel.setText("Sending RADIUS Packet " + packet.getClass().getName());
                            }
                            this.t = System.currentTimeMillis();
                            ++SimulationRunner.this.sent;
                        }
                    });
                    radiusClient = new RadiusClient((RadiusClientTransport)transport);
                    String sessionId = "JRadius-" + RadiusRandom.getRandomString((int)16);
                    byte[] bClass = null;
                    for (int i = 0; i < sendPackets.length; ++i) {
                        Attr_AcctSessionId generatedAcctSessionId;
                        RadiusRequest request;
                        if (!sendPackets[i]) continue;
                        if (i == 0) {
                            request = sendDisconnectRequest ? PacketFactory.newPacket((byte)40, (RadiusClient)radiusClient, (AttributeList)authAttributes[0]) : (sendCoARequest ? PacketFactory.newPacket((byte)43, (RadiusClient)radiusClient, (AttributeList)authAttributes[0]) : PacketFactory.newPacket((byte)1, (RadiusClient)radiusClient, (AttributeList)authAttributes[0]));
                        } else {
                            request = PacketFactory.newPacket((byte)4, (RadiusClient)radiusClient, (AttributeList)acctAttributes[i - 1]);
                            if (request.findAttribute(40L) == null) {
                                switch (i) {
                                    case 1: {
                                        request.addAttribute(AttributeFactory.newAttribute((Long)40L, (Serializable)Attr_AcctStatusType.Start));
                                        break;
                                    }
                                    case 2: {
                                        request.addAttribute(AttributeFactory.newAttribute((Long)40L, (Serializable)Attr_AcctStatusType.InterimUpdate));
                                        break;
                                    }
                                    case 3: {
                                        request.addAttribute(AttributeFactory.newAttribute((Long)40L, (Serializable)Attr_AcctStatusType.Stop));
                                    }
                                }
                            }
                        }
                        request.setIdentifier(request.getIdentifier() + id++);
                        if (bClass != null) {
                            request.addAttribute(AttributeFactory.newAttribute((long)25L, bClass));
                        }
                        if (JRadiusSimulator.this.generateAcctSessionIdCheckBox.isSelected() && (generatedAcctSessionId = (Attr_AcctSessionId)AttributeFactory.newAttribute((Long)44L, (Serializable)((Object)sessionId))) != null && request.findAttribute(44L) != null) {
                            request.overwriteAttribute((RadiusAttribute)generatedAcctSessionId);
                        }
                        AccountingResponse reply = null;
                        if (JRadiusSimulator.this.floodCheckBox.isSelected()) {
                            radiusClient.send(request);
                        } else if (i == 0) {
                            if (request instanceof AccessRequest) {
                                RadiusAuthenticator auth = JRadiusSimulator.this.getAuthenticator();
                                if (auth instanceof TunnelAuthenticator) {
                                    ((TunnelAuthenticator)auth).setTunneledAttributes(authAttributes[1]);
                                }
                                if ((reply = radiusClient.authenticate((AccessRequest)request, auth, retries.intValue())) == null) {
                                    PacketFactory.recycle((RadiusPacket)request);
                                    throw new TimeoutException("timeout waiting for reply");
                                }
                                if (!JRadiusSimulator.this.notStopOnRejectCheckBox.isSelected() && reply instanceof AccessReject) {
                                    String replyMessage = (String)reply.getAttributeValue(18L);
                                    if (replyMessage == null) {
                                        replyMessage = "reason unknown";
                                    }
                                    JRadiusSimulator.this.statusLabel.setText("Access Rejected: " + replyMessage);
                                    simulationSuccess = false;
                                    break;
                                }
                                if (!JRadiusSimulator.this.notSendClassAttribute.isSelected()) {
                                    bClass = (byte[])reply.getAttributeValue(25L);
                                }
                            } else if (sendDisconnectRequest) {
                                reply = radiusClient.disconnect((DisconnectRequest)request, retries.intValue());
                            } else if (sendCoARequest) {
                                reply = radiusClient.changeOfAuth((CoARequest)request, retries.intValue());
                            }
                        } else {
                            reply = radiusClient.accounting((AccountingRequest)request, retries.intValue());
                        }
                        if (reply != null) {
                            PacketFactory.recycle(reply);
                        }
                        PacketFactory.recycle((RadiusPacket)request);
                    }
                    if (!simulationSuccess) continue;
                    continue;
                }
                catch (Exception e) {
                    JRadiusSimulator.this.statusLabel.setText("Problem: " + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (radiusClient != null) {
                        radiusClient.close();
                    } else if (transport != null) {
                        transport.close();
                    }
                }
            }
            authAttributes[0].clear();
            authAttributes[1].clear();
            acctAttributes[0].clear();
            acctAttributes[1].clear();
            acctAttributes[2].clear();
            System.out.println("Sent: " + this.sent + " Recd: " + this.recd + " in " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    class SimulationMonitor
    implements Runnable {
        long startTime = System.currentTimeMillis();

        SimulationMonitor() {
        }

        public void run() {
            JRadiusSimulator.this.clearStats();
            JRadiusSimulator.this.statusLabel.setText("Simulation Running...");
            for (Thread t : JRadiusSimulator.this.simulationThreads) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    JRadiusSimulator.this.statusLabel.setText(JRadiusSimulator.this.statusLabel.getText() + " Stopped.");
                    JRadiusSimulator.this.runButton.setSelected(false);
                    JRadiusSimulator.this.runButton.setText("Start");
                    return;
                }
            }
            if (JRadiusSimulator.this.simulationRunners == null) {
                return;
            }
            JRadiusSimulator.this.statusLabel.setText(JRadiusSimulator.this.statusLabel.getText() + " Done.");
            long overallTime = System.currentTimeMillis() - this.startTime;
            int threads = JRadiusSimulator.this.simulationRunners.length;
            int sent = 0;
            int recd = 0;
            long[] pktTimes = new long[10];
            for (SimulationRunner r : JRadiusSimulator.this.simulationRunners) {
                sent += r.sent;
                recd += r.recd;
                for (int i = 0; i < pktTimes.length; ++i) {
                    int n = i;
                    pktTimes[n] = pktTimes[n] + r.pkts[i];
                }
            }
            double time = (double)overallTime / 1000.0;
            double rps = recd;
            rps /= time;
            DecimalFormat dfmt = new DecimalFormat("#.##");
            NumberFormat ifmt = NumberFormat.getInstance();
            JRadiusSimulator.this.runStatsThreads.setText(ifmt.format(threads));
            JRadiusSimulator.this.runStatsSent.setText(ifmt.format(sent));
            JRadiusSimulator.this.runStatsRecv.setText(ifmt.format(recd));
            JRadiusSimulator.this.runStatsTime.setText(dfmt.format(time) + " sec");
            JRadiusSimulator.this.runStatsRPS.setText(dfmt.format(rps) + " req/sec");
            JRadiusSimulator.this.runStatsTime1.setText(ifmt.format(pktTimes[0]));
            JRadiusSimulator.this.runStatsTime2.setText(ifmt.format(pktTimes[1]));
            JRadiusSimulator.this.runStatsTime3.setText(ifmt.format(pktTimes[2]));
            JRadiusSimulator.this.runStatsTime4.setText(ifmt.format(pktTimes[3]));
            JRadiusSimulator.this.runStatsTime5.setText(ifmt.format(pktTimes[4]));
            JRadiusSimulator.this.runButton.setSelected(false);
            JRadiusSimulator.this.runButton.setText("Start");
        }
    }

    private class ValueTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 0L;
        private JComponent component;

        private ValueTableCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
            AttributesTableEntry entry;
            if (isSelected) {
                // empty if block
            }
            if ((entry = (AttributesTableEntry)JRadiusSimulator.this.attributesTableModel.getEntries().get(rowIndex)).getValueClass().equals(NamedValue.class)) {
                this.component = JRadiusSimulator.this.createNamedValueCellEditor(entry.getAttributeName());
                ((JComboBox)this.component).setSelectedItem(value);
            } else if (entry.getValueClass().equals(IntegerValue.class)) {
                JFormattedTextField ftf = new JFormattedTextField(JRadiusSimulator.this.getNumberFormatter());
                Integer iValue = null;
                try {
                    iValue = new Integer((String)value);
                }
                catch (Exception e) {
                    iValue = new Integer(0);
                }
                ftf.setValue(iValue);
                this.component = ftf;
            } else {
                this.component = new JTextField();
                ((JTextField)this.component).setText((String)value);
            }
            this.component.setBorder(null);
            return this.component;
        }

        public Object getCellEditorValue() {
            if (this.component instanceof JComboBox) {
                return ((JComboBox)this.component).getSelectedItem();
            }
            if (this.component instanceof JFormattedTextField) {
                return ((Integer)((JFormattedTextField)this.component).getValue()).toString();
            }
            return ((JTextField)this.component).getText();
        }

        public boolean stopCellEditing() {
            if (this.component instanceof JFormattedTextField) {
                JFormattedTextField ftf = (JFormattedTextField)this.component;
                if (ftf.isEditValid()) {
                    try {
                        ftf.commitEdit();
                    }
                    catch (ParseException parseException) {}
                } else {
                    return false;
                }
            }
            return super.stopCellEditing();
        }
    }
}

