/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import javax.net.ssl.SSLException;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.EAPAuthenticator;
import net.jradius.client.auth.EAPMSCHAPv2Authenticator;
import net.jradius.client.auth.EAPTLSAuthenticator;
import net.jradius.exception.RadiusException;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;

public class PEAPAuthenticator
extends EAPTLSAuthenticator {
    public static final String NAME = "peap";
    private EAPAuthenticator tunnelAuth;
    private RadiusPacket tunnelRequest;

    public PEAPAuthenticator() {
        this.setEAPType(25);
    }

    public void init() throws RadiusException {
        super.init();
        this.tunnelAuth = new EAPMSCHAPv2Authenticator(true);
    }

    public String getAuthName() {
        return NAME;
    }

    protected boolean isCertificateRequired() {
        return false;
    }

    public void setupRequest(RadiusClient c, RadiusPacket p) throws RadiusException {
        super.setupRequest(c, p);
        this.tunnelRequest = new AccessRequest();
        AttributeList attrs = this.tunnelRequest.getAttributes();
        if (attrs.get(1L) == null) {
            attrs.add(this.username);
        }
        if (attrs.get(2L) == null) {
            attrs.add(this.password);
        }
        this.tunnelAuth.setupRequest(c, this.tunnelRequest);
        this.tunnelAuth.processRequest(this.tunnelRequest);
    }

    protected boolean doTunnelAuthentication(byte id, byte[] in) throws RadiusException, SSLException {
        byte[] out = in != null && in.length > 0 ? this.tunnelAuth.doEAP(in) : this.tunnelAuth.eapResponse(1, (byte)0, this.getUsername());
        this.putAppBuffer(out);
        return true;
    }
}

