/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet.attribute.value;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.value.AttributeValue;
import net.jradius.packet.attribute.value.OctetsValue;
import net.jradius.packet.attribute.value.TLVFormat;

public class TLVValue
extends OctetsValue {
    private static final long serialVersionUID = 1L;
    private TLVFormat format;
    private AttributeList list;

    public TLVValue(long vendorId, int vsaType, AttributeList subAttributes) {
        this.format = new TLVFormat(vendorId, vsaType);
        this.list = subAttributes;
    }

    public void getBytes(ByteBuffer buffer) {
        this.format.packAttributeList(this.list, buffer, false);
    }

    public void copy(AttributeValue value) {
        TLVValue tlvValue = (TLVValue)value;
        this.list.clear();
        this.list.add(tlvValue.list);
    }

    public int getLength() {
        ByteBuffer b = ByteBuffer.allocate(4096);
        this.format.packAttributeList(this.list, b, true);
        return b.position();
    }

    public Serializable getValueObject() {
        return super.getValueObject();
    }

    public void setValue(byte[] b) {
        this.list.clear();
        if (b != null && b.length > 0) {
            ByteBuffer bb = ByteBuffer.wrap(b);
            this.format.unpackAttributes(this.list, bb, bb.limit());
        }
    }

    public void setValue(byte[] b, int off, int len) {
        this.list.clear();
        if (b != null && len > 0) {
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            this.format.unpackAttributes(this.list, bb, len);
        }
    }

    public void setValueObject(Serializable o) {
        super.setValueObject(o);
    }

    public String toDebugString() {
        return "[" + this.list.toString().trim().replaceAll("\n", ", ") + "]";
    }

    public String toString() {
        return this.toDebugString();
    }
}

