/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.glassdialog;

import javax.swing.Icon;
import javax.swing.RootPaneContainer;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;

public class MessageGlassDialog
extends AbstractGlassDialog {
    private final OKCancelDialogPanel okCancelDialogPanel;

    MessageGlassDialog(RootPaneContainer rootPane, int w, OKCancelDialogPanel contentPanel) {
        super(rootPane, w, (AbstractDialogPanel)contentPanel);
        this.setShowDecoration(true);
        this.okCancelDialogPanel = contentPanel;
    }

    public OKCancelDialogPanel getDialogPanel() {
        return this.okCancelDialogPanel;
    }

    public static MessageGlassDialog getDecoratedDialog(RootPaneContainer rootPane, int w, String title, String okText, Icon icon) {
        return MessageGlassDialog.getDecoratedDialog(rootPane, w, null, title, okText, null, icon);
    }

    public static MessageGlassDialog getDecoratedDialog(RootPaneContainer rootPane, int w, String message, String title, String okText, String cancelText, Icon icon) {
        return MessageGlassDialog.getDialog(rootPane, w, message, title, okText, cancelText, icon, true);
    }

    public static MessageGlassDialog getDialog(RootPaneContainer rootPane, int w, String message, String title, String okText, String cancelText, Icon icon, boolean decorated) {
        OKCancelDialogPanel dialogPanel = new OKCancelDialogPanel(okText, cancelText);
        if (!decorated) {
            dialogPanel.setTitle(title, message != null);
        }
        dialogPanel.setIcon(icon);
        if (message != null) {
            FixedWidthLabel messageLabel = new FixedWidthLabel("<html>" + message.replaceAll("\n", "<BR>"));
            messageLabel.setVerticalAlignment(1);
            dialogPanel.setContent(messageLabel);
        }
        MessageGlassDialog dialog = new MessageGlassDialog(rootPane, w, dialogPanel);
        dialog.setShowDecoration(decorated);
        if (decorated) {
            dialog.setTitle(title);
        }
        return dialog;
    }

    public static MessageGlassDialog getDecoratedDialog(RootPaneContainer rootPane, String title, String okText, Icon icon) {
        return MessageGlassDialog.getDecoratedDialog(rootPane, title, okText, null, icon);
    }

    public static MessageGlassDialog getDecoratedDialog(RootPaneContainer rootPane, String title, String okText, String cancelText, Icon icon) {
        return MessageGlassDialog.getDecoratedDialog(rootPane, 470, null, title, okText, cancelText, icon);
    }

    public static MessageGlassDialog getDecoratedDialog(RootPaneContainer rootPane, String message, String title, String okText, String cancelText, Icon icon) {
        return MessageGlassDialog.getDecoratedDialog(rootPane, 470, message, title, okText, cancelText, icon);
    }

    public boolean isOKResult() {
        return this.okCancelDialogPanel.isOK();
    }
}

