/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHSliderUI
extends BasicSliderUI {
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    protected boolean isDragging = false;

    public SHSliderUI() {
        super(null);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new MyTrackListener();
    }

    @Override
    protected Dimension getThumbSize() {
        return SimpleHelpLookAndFeel.scale(new Dimension(12, 12));
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintLabels(Graphics g) {
        super.paintLabels(g);
    }

    @Override
    public void paintThumb(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Dimension thumbSize = this.getThumbSize();
        Arc2D.Float s = new Arc2D.Float(this.thumbRect.x + 1, this.thumbRect.y + 1, thumbSize.width - 2, thumbSize.height - 2, 0.0f, 360.0f, 0);
        g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, this.slider.isEnabled(), thumbSize.height, this.isDragging));
        g2d.fill(s);
        g2d.setStroke(SHButtonUI.getBorderStroke());
        g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, this.slider.isEnabled()));
        g2d.draw(s);
    }

    public static ComponentUI createUI(JComponent c) {
        c.setOpaque(false);
        return new SHSliderUI();
    }

    @Override
    public void paintTicks(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTrack(Graphics g) {
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int cy = trackBounds.height / 2 - 1;
            int cw = trackBounds.width;
            g.translate(trackBounds.x, trackBounds.y + cy);
            try {
                g.setColor(SHUI.SLIDER_TRACK);
                g.drawLine(0, 1, cw, 1);
            }
            finally {
                g.translate(-trackBounds.x, -(trackBounds.y + cy));
            }
        }
        int cx = trackBounds.width / 2 - 1;
        int ch = trackBounds.height;
        g.translate(trackBounds.x + cx, trackBounds.y);
        try {
            g.setColor(SHUI.SLIDER_TRACK);
            g.drawLine(1, 1, 0, ch);
        }
        finally {
            g.translate(-(trackBounds.x + cx), -trackBounds.y);
        }
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(SHUI.SLIDER_TICKS);
        g.drawLine(x, 0, x, tickBounds.height / 2 - 1);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(SHUI.SLIDER_TICKS);
        g.drawLine(x, 0, x, tickBounds.height - 2);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(SHUI.SLIDER_TICKS);
        g.drawLine(0, y, tickBounds.width / 2 - 1, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(SHUI.SLIDER_TICKS);
        g.drawLine(0, y, tickBounds.width - 2, y);
    }

    class MyTrackListener
    extends BasicSliderUI.TrackListener {
        MyTrackListener() {
            super(SHSliderUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            SHSliderUI.this.isDragging = false;
            SHSliderUI.this.slider.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (SHSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                SHSliderUI.this.isDragging = true;
            }
            SHSliderUI.this.slider.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SHSliderUI.this.isRollover = false;
            SHSliderUI.this.wasRollover = false;
            if (SHSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                SHSliderUI.this.isRollover = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SHSliderUI.this.isRollover = false;
            if (SHSliderUI.this.isRollover != SHSliderUI.this.wasRollover) {
                SHSliderUI.this.slider.repaint();
                SHSliderUI.this.wasRollover = SHSliderUI.this.isRollover;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SHSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                SHSliderUI.this.isRollover = true;
            }
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (SHSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                SHSliderUI.this.isRollover = true;
                if (SHSliderUI.this.isRollover != SHSliderUI.this.wasRollover) {
                    SHSliderUI.this.slider.repaint();
                    SHSliderUI.this.wasRollover = SHSliderUI.this.isRollover;
                }
            } else {
                SHSliderUI.this.isRollover = false;
                if (SHSliderUI.this.isRollover != SHSliderUI.this.wasRollover) {
                    SHSliderUI.this.slider.repaint();
                    SHSliderUI.this.wasRollover = SHSliderUI.this.isRollover;
                }
            }
        }
    }
}

