/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHComboBoxButton;
import utils.swing.customlaf.SHComboBoxEditor;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.renderers.BorderedListCellRendererWrapper;
import utils.switches.oem.OEMSwitches;

public class SHComboBoxUI
extends BasicComboBoxUI
implements PropertyChangeListener {
    public static final String PROPERTY_NAKED = "NAKED";
    public static final String PROPERTY_NAKED_YES = "YES";
    public static final String KEY_SEGMENTED = "Segmented";
    public static final String PROPERTY_SEGMENTED_RIGHT = "R";
    public static final String PROPERTY_SEGMENTED_LEFT = "L";
    public static final String PROPERTY_SEGMENTED_CENTER = "C";
    private boolean isNaked = false;
    private JComponent c;
    private SHComboBoxButton button;
    private Border padding;

    public SHComboBoxUI(JComponent c) {
        this.c = c;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (this.padding == null) {
            this.padding = SHBorderFactory.createEmptyBorder(4, 4, 4, 4);
        }
        this.comboBox.setRenderer(new BorderedListCellRendererWrapper(this.comboBox.getRenderer(), this.padding));
    }

    @Override
    protected ComboPopup createPopup() {
        return new SHComboPopup(this.comboBox);
    }

    public static void makeComboSegmentedRight(JComboBox box) {
        box.putClientProperty(KEY_SEGMENTED, PROPERTY_SEGMENTED_RIGHT);
    }

    public static void makeComboSegmentedLeft(JComboBox box) {
        box.putClientProperty(KEY_SEGMENTED, PROPERTY_SEGMENTED_RIGHT);
    }

    public static void makeComboSegmentedCenter(JComboBox box) {
        box.putClientProperty(KEY_SEGMENTED, PROPERTY_SEGMENTED_CENTER);
    }

    public static ComponentUI createUI(final JComponent c) {
        c.setOpaque(false);
        c.addPropertyChangeListener("opaque", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                c.setOpaque(false);
            }
        });
        SHComboBoxUI ui = new SHComboBoxUI(c);
        c.addPropertyChangeListener(PROPERTY_NAKED, ui);
        c.addPropertyChangeListener(KEY_SEGMENTED, ui);
        return ui;
    }

    @Override
    public Dimension getDisplaySize() {
        Dimension d = super.getDisplaySize();
        d.width += SimpleHelpLookAndFeel.scale(10);
        d.height = SHUI.TEXT_FIELD_HEIGHT;
        return d;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle r = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(g, r, this.hasFocus);
        this.paintCurrentValue(g, r, this.hasFocus);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (!this.isNaked && hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        x += SimpleHelpLookAndFeel.scale(5);
        w -= SimpleHelpLookAndFeel.scale(5);
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
        ((JComponent)c).setOpaque(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        Graphics2D g2d = (Graphics2D)g;
        Shape oldClip = g2d.getClip();
        try {
            g2d.setClip(g.getClipBounds().intersection(bounds));
            RoundRectangle2D.Float s = new RoundRectangle2D.Float(bounds.x, bounds.y, (float)(bounds.width + SimpleHelpLookAndFeel.scale(4)) - SHButtonUI.getBorderStrokeWidth(), (float)bounds.height - SHButtonUI.getBorderStrokeWidth(), SimpleHelpLookAndFeel.scale(2), SimpleHelpLookAndFeel.scale(2));
            if (!this.isNaked) {
                g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, this.comboBox.isEnabled(), bounds.height, false));
                g2d.fill(s);
            } else {
                if (!OEMSwitches.DARK_THEME) {
                    g2d.setColor(SHStyle.PANEL_BACKGROUND_WHITE);
                } else {
                    g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, this.comboBox.isEnabled(), bounds.height, false));
                }
                g2d.fill(s);
            }
            g2d.setStroke(SHButtonUI.getBorderStroke());
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, this.comboBox.isEnabled()));
            g2d.draw(s);
        }
        finally {
            g2d.setClip(oldClip);
        }
    }

    @Override
    protected JButton createArrowButton() {
        this.button = new SHComboBoxButton(this.comboBox);
        this.button.setMargin(new ScaledInsets(0, 0, 0, 0));
        this.button.setFocusable(false);
        return this.button;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SHComboBoxEditor.UIResource();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(PROPERTY_NAKED)) {
            String isNakedString = (String)this.c.getClientProperty(PROPERTY_NAKED);
            this.isNaked = isNakedString != null && isNakedString.equals(PROPERTY_NAKED_YES);
            this.button.setNaked(this.isNaked);
        } else if (evt.getNewValue().equals(PROPERTY_SEGMENTED_LEFT)) {
            SHButtonUI.makeButtonSegmentedLeft(this.button);
        } else if (evt.getNewValue().equals(PROPERTY_SEGMENTED_CENTER)) {
            SHButtonUI.makeButtonSegmentedCenter(this.button);
        } else if (evt.getNewValue().equals(PROPERTY_SEGMENTED_RIGHT)) {
            SHButtonUI.makeButtonSegmentedRight(this.button);
        }
    }

    public static void main(String[] args) {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.getContentPane().add(new JComboBox<String>(new String[]{"Test 1", "Test 2"}));
        frame.setVisible(true);
    }

    class SHComboPopup
    extends BasicComboPopup {
        private JComboBox combo;

        public SHComboPopup(JComboBox combo) {
            super(combo);
            this.combo = combo;
            this.setBorder(SHBorderFactory.createLineBorder(SHStyle.POPUP_BORDER_COLOR, 1));
        }

        @Override
        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Rectangle screenBounds;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            GraphicsConfiguration gc = this.comboBox.getGraphicsConfiguration();
            Point p = new Point();
            SwingUtilities.convertPointFromScreen(p, this.comboBox);
            if (gc != null) {
                Insets screenInsets = toolkit.getScreenInsets(gc);
                screenBounds = gc.getBounds();
                screenBounds.width -= screenInsets.left + screenInsets.right;
                screenBounds.height -= screenInsets.top + screenInsets.bottom;
                screenBounds.x += p.x + screenInsets.left;
                screenBounds.y += p.y + screenInsets.top;
            } else {
                screenBounds = new Rectangle(p, toolkit.getScreenSize());
            }
            Rectangle rect = new Rectangle(px, py, pw, ph);
            if (py + ph > screenBounds.y + screenBounds.height && ph < screenBounds.height) {
                rect.y = -rect.height;
            }
            rect.width = Math.max(rect.width, this.getMaxRequiredWidth());
            return rect;
        }

        private int getMaxRequiredWidth() {
            ComboBoxModel model = this.combo.getModel();
            int max = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                Object element = model.getElementAt(i);
                ListCellRenderer renderer = this.combo.getRenderer();
                Component c = renderer.getListCellRendererComponent(SHComboBoxUI.this.listBox, element, i, false, false);
                max = Math.max(c.getPreferredSize().width, max);
            }
            return max;
        }
    }
}

