/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JButton;
import javax.swing.JComboBox;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SHComboBoxButton
extends JButton {
    private final JComboBox comboBox;
    private final GeneralPath arrowPath;
    private boolean naked;

    public SHComboBoxButton(JComboBox comboBox) {
        this.comboBox = comboBox;
        SHButtonUI.makeButtonSegmentedRight(this);
        SHButtonUI.makeButtonBlue(this);
        int arrowWidth = SimpleHelpLookAndFeel.scale(6);
        this.arrowPath = new GeneralPath();
        this.arrowPath.moveTo(-arrowWidth / 2, arrowWidth / 4);
        this.arrowPath.lineTo(0.0f, -arrowWidth / 4);
        this.arrowPath.lineTo(arrowWidth / 2, arrowWidth / 4);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(SimpleHelpLookAndFeel.scale(26), SimpleHelpLookAndFeel.scale(26));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        AffineTransform oldTransform = g2d.getTransform();
        try {
            g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
            g2d.rotate(Math.PI, 0.0, 0.0);
            g2d.setColor(SHUI.SCROLL_BUTTON_ARROW);
            g2d.draw(this.arrowPath);
        }
        finally {
            g2d.setTransform(oldTransform);
        }
    }

    public void setNaked(boolean naked) {
        if (naked) {
            SHButtonUI.makeButtonNaked(this);
        } else {
            SHButtonUI.makeButtonNormal(this);
        }
        this.naked = naked;
    }
}

