/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import utils.swing.customlaf.LegacySwingUtils;
import utils.swing.customlaf.SHCheckBoxIcon;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.oem.OEMSwitches;

public class SHCheckBoxUI
extends BasicCheckBoxUI {
    private static final SHCheckBoxIcon checkBoxIcon = new SHCheckBoxIcon();
    private static SHCheckBoxUI INSTANCE = null;
    private static final Object LOCK = new Object();

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        this.icon = checkBoxIcon;
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).setIconTextGap(SimpleHelpLookAndFeel.scale(4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentUI createUI(JComponent b) {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new SHCheckBoxUI();
            }
            return INSTANCE;
        }
    }

    @Override
    protected void paintFocus(Graphics g, Rectangle t, Dimension arg2) {
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = LegacySwingUtils.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            LegacySwingUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else if (!OEMSwitches.DARK_THEME) {
            g.setColor(b.getBackground().brighter());
            LegacySwingUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset() + 1);
            g.setColor(b.getBackground().darker());
            LegacySwingUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(UIManager.getColor("textInactiveText"));
            LegacySwingUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        }
    }
}

