/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types.fields;

import java.awt.Color;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.swing.components.SHComboBox;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.validators.ComboBoxValidator;
import utils.xml.XML14Util;

public class ComboBoxField
extends AbstractField {
    public static final String COMBOBOX_TYPE = "combobox";
    private SHComboBox comboBox = new SHComboBox();
    private String[] choices;
    private int[] validIndicesArray;

    public String[] getChoices() {
        return this.choices;
    }

    public int[] getValidIndicesArray() {
        return this.validIndicesArray;
    }

    @Override
    public void setBackground(Color backgroundColor) {
        super.setBackground(backgroundColor);
        this.comboBox.setBackground(backgroundColor);
    }

    public void setSelectedIndex(int index) {
        this.comboBox.setSelectedIndex(index);
    }

    public int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    public ComboBoxField(String label, AbstractField.ChangeListener changeListener, String[] options) {
        this(label, changeListener);
        this.setChoices(options);
    }

    public ComboBoxField(String label, AbstractField.ChangeListener changeListener) {
        super(COMBOBOX_TYPE, label, changeListener);
        if (this.proxyChangeListener != null) {
            this.comboBox.addActionListener(this.proxyChangeListener);
        }
    }

    public void setEditable(boolean editable) {
        this.comboBox.setEditable(editable);
    }

    public void setIconInterface(SHComboBox.IconInterface iconInterface) {
        this.comboBox.setIconInterface(iconInterface);
    }

    @Override
    public void setStorableFilledOutData(ResultPair data) {
        this.comboBox.setSelectedIndex(Integer.parseInt(data.getValue()));
    }

    @Override
    public ResultPair getStorableFilledOutData() {
        return new ResultPair(this.label, Integer.toString(this.comboBox.getSelectedIndex()));
    }

    @Override
    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        if (this.choices.length > 0 && this.comboBox.getSelectedIndex() != -1) {
            return new ResultPair(this.label, this.choices[this.comboBox.getSelectedIndex()]);
        }
        if (this.choices.length > 0 && this.comboBox.isEditable()) {
            return new ResultPair(this.label, this.comboBox.getSelectedItem() + "");
        }
        return new ResultPair(this.label, "");
    }

    @Override
    public void toXML(StringBuffer buffer, int tabs) {
        for (int i = 0; i < this.choices.length; ++i) {
            boolean valid = false;
            for (int j = 0; j < this.validIndicesArray.length && !valid; ++j) {
                if (this.validIndicesArray[j] != i) continue;
                valid = true;
            }
            buffer.append(XML14Util.getIndent(tabs));
            buffer.append("<Choice valid=\"" + Boolean.toString(valid) + "\">" + this.choices[i] + "</Choice>\n");
        }
    }

    public void setValidIndices(int[] validIndicesArray) {
        this.validIndicesArray = validIndicesArray;
        this.addValidator(new ComboBoxValidator(validIndicesArray));
    }

    public static ComboBoxField fromXML(Element element, AbstractField.ChangeListener cl) {
        String label = element.getAttribute("label");
        NodeList elementsByTagName = element.getElementsByTagName("Choice");
        String[] choices = new String[elementsByTagName.getLength()];
        ArrayList<Integer> listOfValidIntegers = new ArrayList<Integer>();
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element choiceElement = (Element)elementsByTagName.item(i);
            choices[i] = XML14Util.getTextContent(choiceElement);
            if (!Boolean.parseBoolean(choiceElement.getAttribute("valid"))) continue;
            listOfValidIntegers.add(new Integer(i));
        }
        int[] validIndices = new int[listOfValidIntegers.size()];
        for (int i = 0; i < listOfValidIntegers.size(); ++i) {
            validIndices[i] = (Integer)listOfValidIntegers.get(i);
        }
        ComboBoxField type = new ComboBoxField(label, cl, choices);
        type.setValidIndices(validIndices);
        return type;
    }

    public void setChoices(String[] choices) {
        this.choices = choices;
        this.comboBox.setModel(new DefaultComboBoxModel<String>(choices));
    }

    @Override
    public JComponent getComponent() {
        return this.comboBox;
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    @Override
    public void clearContents() {
        this.comboBox.setSelectedIndex(-1);
    }

    public void setEditableText(String logName) {
        if (logName != null) {
            this.comboBox.getEditor().setItem(logName);
        } else {
            this.comboBox.getEditor().setItem("");
        }
    }

    public String getEditorValue() {
        return "" + this.comboBox.getEditor().getItem();
    }
}

