/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import utils.swing.ExponentialSlider;
import utils.swing.images.ImageHelper;

public class SwipeImagePanel
extends JPanel
implements ActionListener {
    protected Image oldimage;
    protected Image image;
    int width;
    int height;
    int oldwidth;
    int oldheight;
    int oldX;
    int newX;
    static Image[] swipes;
    static int index;
    Slide current;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (++index == swipes.length) {
            index = 0;
        }
        this.swipeTo(swipes[index]);
    }

    public static void main(String[] args) throws Exception {
        index = 0;
        JFrame frame = new JFrame();
        SwipeImagePanel rp = new SwipeImagePanel();
        swipes = new Image[]{ImageIO.read(new File("Querying.png")), ImageIO.read(new File("Download.png")), ImageIO.read(new File("NoInternet.png"))};
        rp.setImage(swipes[0]);
        JPanel tmp = new JPanel();
        tmp.setLayout(new BorderLayout());
        tmp.add("Center", rp);
        JButton b = new JButton("Swipe");
        tmp.add("South", b);
        b.addActionListener(rp);
        frame.getContentPane().add(tmp);
        frame.setBounds(0, 0, 400, 400);
        frame.setVisible(true);
    }

    public Image getImage() {
        return this.image;
    }

    public void waitForAllSwipes() {
        Slide now = this.current;
        if (now != null) {
            try {
                now.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void swipeTo(Image image) {
        Slide waitFor = this.current;
        this.current = new Slide();
        this.current.newImage = image;
        this.current.waitFor = waitFor;
        this.current.start();
    }

    public void setImage(Image image) {
        if (image != null) {
            this.width = image.getWidth(null);
            this.height = image.getHeight(null);
        }
        this.image = image;
    }

    @Override
    public void paintComponent(Graphics g1) {
        int yoff;
        int xoff;
        Graphics2D g = (Graphics2D)g1;
        double panw = this.getWidth();
        double panh = this.getHeight();
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)panw, (int)panh);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if ((double)this.width > panw || (double)this.height > panh) {
            this.image = ImageHelper.scaleDownToFitInside(ImageHelper.toBufferedImageARGB(this.image), (int)panw, (int)panh);
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
        }
        if (this.oldimage != null) {
            xoff = (int)(panw - (double)this.oldwidth) / 2;
            yoff = (int)(panh - (double)this.oldheight) / 2;
            g.drawImage(this.oldimage, this.oldX + xoff, yoff, this.oldwidth, this.oldheight, null);
        }
        if (this.image != null) {
            xoff = ((int)panw - this.width) / 2;
            yoff = ((int)panh - this.height) / 2;
            g.drawImage(this.image, this.newX + xoff, yoff, this.width, this.height, null);
        }
    }

    class Slide
    extends Thread {
        Slide waitFor;
        Image newImage;

        Slide() {
        }

        @Override
        public void run() {
            if (this.waitFor != null) {
                try {
                    this.waitFor.join();
                }
                catch (Exception x) {
                    x.printStackTrace();
                    return;
                }
            }
            SwipeImagePanel.this.oldimage = SwipeImagePanel.this.image;
            SwipeImagePanel.this.oldwidth = SwipeImagePanel.this.width;
            SwipeImagePanel.this.oldheight = SwipeImagePanel.this.height;
            SwipeImagePanel.this.image = this.newImage;
            if (this.newImage != null) {
                SwipeImagePanel.this.width = this.newImage.getWidth(null);
                SwipeImagePanel.this.height = this.newImage.getHeight(null);
            }
            SwipeImagePanel.this.oldX = 0;
            SwipeImagePanel.this.newX = SwipeImagePanel.this.getWidth();
            int W = SwipeImagePanel.this.getWidth();
            ExponentialSlider epx = new ExponentialSlider((double)W, 500L, 3.5, true);
            for (int i = 0; i < epx.getPositionCount(); ++i) {
                int offset = epx.getPositionForStepRounded(i);
                SwipeImagePanel.this.oldX = 0 - offset;
                SwipeImagePanel.this.newX = W - offset;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwipeImagePanel.this.repaint();
                    }
                });
                try {
                    Thread.sleep(epx.get25fpsSleep());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            SwipeImagePanel.this.current = null;
        }
    }
}

