/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.borders;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.border.Border;
import utils.progtools.arrays.ArrayUtils;
import utils.swing.components.FitImagePanel;
import utils.swing.customlaf.ScalingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.switches.oem.OEMSwitches;

public class ShadowBorder
implements Border {
    private final int size;

    public ShadowBorder(int size) {
        this.size = size;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color inner;
        Color outer;
        Color transparent;
        Graphics2D g2d = (Graphics2D)g;
        int innerBuffer = 0;
        if (!OEMSwitches.DARK_THEME) {
            transparent = new Color(0, 0, 0, 0);
            outer = new Color(0, 0, 0, 0);
            inner = new Color(100, 100, 100, 250);
        } else {
            transparent = new Color(0, 0, 0, 0);
            outer = new Color(50, 50, 50, 100);
            inner = new Color(150, 150, 150, 150);
        }
        float[] fracs = new float[]{0.0f, 0.6f, 1.0f};
        Color[] colours = new Color[]{transparent, outer, inner};
        LinearGradientPaint gp = new LinearGradientPaint(x + this.size, y + innerBuffer, x + this.size, y + this.size + innerBuffer, fracs, colours);
        g2d.setPaint(gp);
        g2d.fillRect(x + this.size, y, width - 2 * this.size, this.size);
        gp = new LinearGradientPaint(x + this.size, y + height - innerBuffer, x + this.size, y + height - this.size - innerBuffer, fracs, colours);
        g2d.setPaint(gp);
        g2d.fillRect(x + this.size, y + height - this.size, width - 2 * this.size, this.size);
        gp = new LinearGradientPaint(x + innerBuffer, y + this.size, x + this.size + innerBuffer, y + this.size, fracs, colours);
        g2d.setPaint(gp);
        g2d.fillRect(x, y + this.size, this.size, height - 2 * this.size);
        gp = new LinearGradientPaint(x + width - innerBuffer, y + this.size, x + width - this.size - innerBuffer, y + this.size, fracs, colours);
        g2d.setPaint(gp);
        g2d.fillRect(x + width - this.size, y + this.size, this.size, height - 2 * this.size);
        fracs = new float[]{0.0f, 1.0f - fracs[1], 1.0f};
        RadialGradientPaint rgp = new RadialGradientPaint(new Point2D.Float(x + this.size + innerBuffer, y + this.size + innerBuffer), this.size, fracs, ArrayUtils.reverse(colours));
        g2d.setPaint(rgp);
        g2d.fillRect(x, y, this.size, this.size);
        rgp = new RadialGradientPaint(new Point2D.Float(x + width - this.size - innerBuffer, y + this.size + innerBuffer), this.size, fracs, colours);
        g2d.setPaint(rgp);
        g2d.fillRect(x + width - this.size, y, this.size, this.size);
        rgp = new RadialGradientPaint(new Point2D.Float(x + this.size + innerBuffer, y + height - this.size - innerBuffer), this.size, fracs, colours);
        g2d.setPaint(rgp);
        g2d.fillRect(x, y + height - this.size, this.size, this.size);
        rgp = new RadialGradientPaint(new Point2D.Float(x + width - this.size - innerBuffer, y + height - this.size - innerBuffer), this.size, fracs, colours);
        g2d.setPaint(rgp);
        g2d.fillRect(x + width - this.size, y + height - this.size, this.size, this.size);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.size, this.size, this.size, this.size);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static void main(String[] args) throws IOException {
        ScalingUtil.forceScalingPercentage(100);
        SimpleHelpFrame testFrame = SimpleHelpFrame.getTestFrame();
        testFrame.setVisible(true);
        FitImagePanel imagePanel = new FitImagePanel();
        BufferedImage image = ImageIO.read(new File("/Users/gchristelis/Desktop/test.png"));
        imagePanel.setImage(image);
        testFrame.setContentPane(imagePanel);
        SHGlassOptionPane.showConfirmDialog(testFrame, "Test", "Test", null, "YO");
        SHGlassOptionPane.showBorderlessDialog(testFrame, null, "Test", 200);
    }
}

