/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.borders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.Border;

public class RoundRectBorder
implements Border {
    protected Color color;
    protected int radius;
    protected int padding = 3;
    protected Stroke stroke = new BasicStroke(1.0f);
    private Color fillColor = null;
    private float strokeWidth;
    private boolean tl = true;
    private boolean tr = true;
    private boolean bl = true;
    private boolean br = true;

    public RoundRectBorder(Color color, int radius) {
        this.color = color;
        this.radius = radius;
    }

    public RoundRectBorder(Color color, int radius, int padding) {
        this(color, radius);
        this.padding = padding;
    }

    public RoundRectBorder(Color color, int radius, int padding, Color fillColor) {
        this(color, radius);
        this.padding = padding;
        this.fillColor = fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setWidth(float width) {
        this.strokeWidth = width;
        this.stroke = new BasicStroke(width);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        int value = this.radius / 2 + this.padding;
        return new Insets(value, value, value, value);
    }

    public void setCornersToRound(boolean tl, boolean tr, boolean bl, boolean br) {
        this.tl = tl;
        this.tr = tr;
        this.bl = bl;
        this.br = br;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        Shape oldClip;
        int arc = this.radius * 2;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.stroke != null) {
            g2.setStroke(this.stroke);
        }
        RoundRectangle2D.Double roundedShape = new RoundRectangle2D.Double((float)x + this.strokeWidth / 2.0f, (float)y + this.strokeWidth / 2.0f, (float)width - this.strokeWidth - 1.0f, (float)height - this.strokeWidth - 1.0f, arc, arc);
        Rectangle2D.Double rectangleShape = new Rectangle2D.Double((float)x + this.strokeWidth / 2.0f, (float)y + this.strokeWidth / 2.0f, (float)width - this.strokeWidth - 1.0f, (float)height - this.strokeWidth - 1.0f);
        Rectangle clipRectangle = new Rectangle(x, y, width, height);
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            if (this.tl && this.tr && this.bl && this.br) {
                g2.fill(roundedShape);
            } else {
                oldClip = g.getClip();
                g.setClip(clipRectangle.x, clipRectangle.y, clipRectangle.width / 2, clipRectangle.height / 2);
                if (this.tl) {
                    g2.fill(roundedShape);
                } else {
                    g2.fill(rectangleShape);
                }
                g.setClip(oldClip);
                g.setClip(clipRectangle.x + clipRectangle.width / 2, clipRectangle.y, clipRectangle.width / 2, clipRectangle.height / 2);
                if (this.tr) {
                    g2.fill(roundedShape);
                } else {
                    g2.fill(rectangleShape);
                }
                g.setClip(oldClip);
                g.setClip(clipRectangle.x, clipRectangle.y + clipRectangle.height / 2, clipRectangle.width / 2, clipRectangle.height / 2);
                if (this.bl) {
                    g2.fill(roundedShape);
                } else {
                    g2.fill(rectangleShape);
                }
                g.setClip(oldClip);
                g.setClip(clipRectangle.x + clipRectangle.width / 2, clipRectangle.y + clipRectangle.height / 2, clipRectangle.width / 2, clipRectangle.height / 2);
                if (this.br) {
                    g2.fill(roundedShape);
                } else {
                    g2.fill(rectangleShape);
                }
                g.setClip(oldClip);
            }
        }
        g.setColor(this.color);
        if (this.tl && this.tr && this.bl && this.br) {
            g2.draw(roundedShape);
        } else {
            oldClip = g.getClip();
            g.setClip(clipRectangle.x, clipRectangle.y, clipRectangle.width / 2, clipRectangle.height / 2);
            if (this.tl) {
                g2.draw(roundedShape);
            } else {
                g2.draw(rectangleShape);
            }
            g.setClip(oldClip);
            g.setClip(clipRectangle.x + clipRectangle.width / 2, clipRectangle.y, clipRectangle.width / 2, clipRectangle.height / 2);
            if (this.tr) {
                g2.draw(roundedShape);
            } else {
                g2.draw(rectangleShape);
            }
            g.setClip(oldClip);
            g.setClip(clipRectangle.x, clipRectangle.y + clipRectangle.height / 2, clipRectangle.width / 2, clipRectangle.height / 2);
            if (this.bl) {
                g2.draw(roundedShape);
            } else {
                g2.draw(rectangleShape);
            }
            g.setClip(oldClip);
            g.setClip(clipRectangle.x + clipRectangle.width / 2, clipRectangle.y + clipRectangle.height / 2, clipRectangle.width / 2, clipRectangle.height / 2);
            if (this.br) {
                g2.draw(roundedShape);
            } else {
                g2.draw(rectangleShape);
            }
            g.setClip(oldClip);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

