/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import utils.stream.CFriendlyStreamUtils;

public class CFriendlyProperties {
    public static byte[] encode(Properties props) throws IOException {
        Object[] keys = props.keySet().toArray();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)props.get(key);
            if (value == null) {
                value = "";
            }
            CFriendlyStreamUtils.writeString(bout, key);
            CFriendlyStreamUtils.writeString(bout, value);
        }
        bout.flush();
        return bout.toByteArray();
    }

    public static Properties decode(byte[] dat) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        Properties props = new Properties();
        try {
            while (true) {
                String key = CFriendlyStreamUtils.readString(bin);
                String value = CFriendlyStreamUtils.readString(bin);
                if (value.length() == 1 && value.charAt(0) == '\u0004') {
                    value = "";
                }
                props.setProperty(key, value);
                if (key != null && key.toLowerCase().contains("passw")) {
                    System.out.println("JW Launch Prop: " + key + "=[...(contents hidden)...]");
                    continue;
                }
                if (value != null && value.length() > 200) {
                    System.out.println("JW Launch Prop: " + key + "=[" + value.substring(0, 200) + "...]");
                    continue;
                }
                System.out.println("JW Launch Prop: " + key + "=[" + value + "]");
            }
        }
        catch (IOException iOException) {
            return props;
        }
    }
}

