/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

public class ByteArrayUtils {
    public static void writeLong(byte[] dat, int offset, long n) {
        dat[offset] = (byte)(n >>> 56);
        dat[offset + 1] = (byte)(n >>> 48);
        dat[offset + 2] = (byte)(n >>> 40);
        dat[offset + 3] = (byte)(n >>> 32);
        dat[offset + 4] = (byte)(n >>> 24);
        dat[offset + 5] = (byte)(n >>> 16);
        dat[offset + 6] = (byte)(n >>> 8);
        dat[offset + 7] = (byte)n;
    }

    public static long readLong(byte[] dat, int offset) {
        long n = 0L;
        for (int i = 0; i < 8; ++i) {
            n = n << 8 | 0xFFL & (long)dat[offset + i];
        }
        return n;
    }

    public static void writeInt(byte[] dat, int offset, int n) {
        dat[offset] = (byte)(n >>> 24);
        dat[offset + 1] = (byte)(n >>> 16);
        dat[offset + 2] = (byte)(n >>> 8);
        dat[offset + 3] = (byte)n;
    }

    public static int readInt(byte[] dat, int offset) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | 0xFF & dat[offset + i];
        }
        return n;
    }

    public static void main(String[] args) throws Exception {
        byte[] b = new byte[8];
        ByteArrayUtils.writeLong(b, 0, -261456134204876L);
        if (-261456134204876L != ByteArrayUtils.readLong(b, 0)) {
            System.out.println("FAILED");
        } else {
            System.out.println("SUCCEEDED!");
        }
    }
}

