/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.LinkedList;
import utils.progtools.Cleanable;
import utils.progtools.HistogramTracker;
import utils.progtools.profiler.SamplingProfiler;
import utils.switches.Switches;

public class OnDemandThreadPool {
    public static boolean PRINT_STATS = false;
    public static boolean REUSE_THREADS = Switches.SH_1839_odThreadPoolReuseThreads;
    public static final int NO_MAX_BUFFER = -1;
    long workerTimeout = 20000L;
    int maxThreads = 1;
    int maxBuffered = -1;
    Object inside_LOCK = new Object();
    LinkedList<Worker> workers = new LinkedList();
    int inside = 0;
    Object jobs_LOCK = new Object();
    LinkedList<TimedJob> jobs = new LinkedList();
    Object completionNotifier = new Object();
    String name;
    int pri;
    boolean dumpOldJobsFirst = false;
    long lastAlertPrint = 0L;
    long poolAlertCount = 0L;
    static long threadCreates = 0L;
    static long threadLaunches = 0L;
    static long threadExecutes = 0L;
    long lastProcessingWarning = 0L;
    long lastProcessingFinished = System.currentTimeMillis();
    long lastPrint = System.currentTimeMillis();
    HistogramTracker requests = new HistogramTracker(15, 50, 180000);
    HistogramTracker runs = new HistogramTracker(15, 50, 180000);

    public OnDemandThreadPool(String name, int threads, int maxBuffered, int priority) {
        this.name = name;
        this.maxThreads = threads;
        this.maxBuffered = Math.max(1, maxBuffered);
        this.pri = priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDumpOldJobsOnBufferMaxed(boolean b) {
        this.dumpOldJobsFirst = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStats() {
        String stats;
        Object object = this.jobs_LOCK;
        synchronized (object) {
            stats = this.jobs.size() + " >= " + this.maxBuffered;
        }
        stats = stats + ", " + this.getLiveCount() + " live";
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAll() throws InterruptedException {
        while (this.getOutstanding() > 0) {
            Object object = this.completionNotifier;
            synchronized (object) {
                this.completionNotifier.wait(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutstanding() {
        int outstanding = 0;
        Object object = this.jobs_LOCK;
        synchronized (object) {
            outstanding += this.jobs.size();
        }
        object = this.inside_LOCK;
        synchronized (object) {
            for (Worker worker : this.workers) {
                if (worker.waiting) continue;
                ++outstanding;
            }
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.jobs_LOCK;
        synchronized (object) {
            this.jobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRun() {
        Object object = this.jobs_LOCK;
        synchronized (object) {
            if (this.jobs.size() >= this.maxBuffered && this.maxBuffered != -1) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runAsync(Runnable r) {
        Object object = this.jobs_LOCK;
        synchronized (object) {
            while (this.jobs.size() >= this.maxBuffered && this.maxBuffered != -1) {
                if (this.dumpOldJobsFirst) {
                    this.jobs.removeFirst();
                    continue;
                }
                ++this.poolAlertCount;
                if (Switches.SH_2018_printAllPoolAlerts && System.currentTimeMillis() > this.lastAlertPrint + 60000L) {
                    this.lastAlertPrint = System.currentTimeMillis();
                    System.out.println("[Pool Alert] " + this.name + " was unable to process " + this.poolAlertCount + " jobs");
                    this.poolAlertCount = 0L;
                }
                return false;
            }
            this.jobs.add(new TimedJob(r));
        }
        this.launchThreadForNext();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveCount() {
        Object object = this.inside_LOCK;
        synchronized (object) {
            return this.inside;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchThreadForNext() {
        block17: {
            long timeSinceLastProcessed;
            ++threadExecutes;
            boolean mustLaunch = false;
            Object object = this.inside_LOCK;
            synchronized (object) {
                if (REUSE_THREADS) {
                    for (Worker worker : this.workers) {
                        if (!worker.wakeIfWaiting()) continue;
                        ++threadLaunches;
                        return;
                    }
                }
                if (this.inside < this.maxThreads) {
                    mustLaunch = true;
                    ++this.inside;
                }
            }
            if (mustLaunch) {
                try {
                    Worker worker = null;
                    if (worker == null) {
                        ++threadCreates;
                        StringBuffer sb = new StringBuffer(40);
                        sb.append("ODThreadPool-").append(this.name).append('-').append(System.currentTimeMillis());
                        worker = new Worker(sb.toString(), this.pri);
                        worker.start();
                    }
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Object object2 = this.inside_LOCK;
                    synchronized (object2) {
                        --this.inside;
                        break block17;
                    }
                }
            }
            if (Switches.SH_2018_printAllPoolAlerts && (timeSinceLastProcessed = System.currentTimeMillis() - this.lastProcessingFinished) > 60000L && System.currentTimeMillis() > this.lastProcessingWarning + 60000L) {
                int buffered;
                Object object3 = this.jobs_LOCK;
                synchronized (object3) {
                    buffered = this.jobs.size();
                }
                System.out.println("[Pool Alert] " + this.name + " is full (" + this.inside + " +" + buffered + ") and has not processed anything for " + timeSinceLastProcessed / 1000L + "s");
                this.lastProcessingWarning = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable getNextJob() {
        Object object = this.jobs_LOCK;
        synchronized (object) {
            if (this.jobs.size() == 0) {
                return null;
            }
            return this.jobs.removeFirst();
        }
    }

    private void doStatsPrint() {
        if (PRINT_STATS && System.currentTimeMillis() > this.lastPrint + 60000L) {
            this.lastPrint = System.currentTimeMillis();
            this.requests.clear();
            this.runs.clear();
            System.out.print(this.requests.getReadout("ODTP " + this.name, true, true));
            System.out.print(this.runs.getReadout("ODTP " + this.name, false, true));
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        OnDemandThreadPool tp = new OnDemandThreadPool("TEST", 1, 100, 1);
        TestRun run = new TestRun();
        System.out.println("Testing 3x bouts of 100 single threaded, should allocate no more than 1 thread and take no more than 3s");
        for (i = 0; i < 100; ++i) {
            tp.runAsync(run);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 100; ++i) {
            tp.runAsync(run);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 100; ++i) {
            tp.runAsync(run);
        }
        tp.waitForAll();
        System.out.println("DONE! (" + threadCreates + " creates, " + threadLaunches + " launches, " + threadExecutes + " runs)");
        Thread.sleep(2000L);
        System.out.println("Testing 100 threads max throughput");
        tp = new OnDemandThreadPool("TEST", 100, 100, 1);
        SamplingProfiler profiler = new SamplingProfiler();
        profiler.startSampling(50);
        long T = System.currentTimeMillis();
        for (int i2 = 0; i2 < 50000; ++i2) {
            while (!tp.runAsync(run)) {
                Thread.sleep(1L);
            }
            if (i2 % 100 != 0) continue;
            System.out.println("Outstanding: " + tp.getOutstanding());
        }
        tp.waitForAll();
        T = System.currentTimeMillis() - T;
        profiler.stopSampling();
        profiler.dump(1.0);
        double time = T;
        double persec = (double)run.N / (time /= 1000.0);
        System.out.println("DONE! " + (int)persec + " per sec (" + run.N + " confirmed runs in " + T + "ms) (" + threadCreates + " creates, " + threadLaunches + " launches, " + threadExecutes + " runs)");
    }

    static class TestRun
    implements Runnable {
        int N = 0;
        long QUIT = System.currentTimeMillis() + 1000L;

        TestRun() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TestRun testRun = this;
            synchronized (testRun) {
                ++this.N;
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class Worker
    extends Thread
    implements Cleanable {
        Object NOTIFY;
        boolean waiting;
        boolean woken;
        boolean forceQuit;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wakeIfWaiting() {
            Object object = this.NOTIFY;
            synchronized (object) {
                if (this.waiting) {
                    this.woken = true;
                    this.NOTIFY.notifyAll();
                    return true;
                }
            }
            return false;
        }

        public Worker(String name, int priority) {
            super(name);
            this.NOTIFY = new Object();
            this.waiting = false;
            this.woken = false;
            this.forceQuit = false;
            if (!Switches.SH_1839_odThreadPoolNoSetPriority) {
                this.setPriority(priority);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Object object2;
            long T_run = System.currentTimeMillis();
            try {
                object2 = OnDemandThreadPool.this.inside_LOCK;
                synchronized (object2) {
                    OnDemandThreadPool.this.workers.add(this);
                }
                OnDemandThreadPool.this.doStatsPrint();
                Runnable r = OnDemandThreadPool.this.getNextJob();
                OnDemandThreadPool.this.doStatsPrint();
                while (r != null || this.woken) {
                    if (this.forceQuit) {
                        return;
                    }
                    try {
                        if (r != null) {
                            r.run();
                        }
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                    }
                    OnDemandThreadPool.this.doStatsPrint();
                    if (REUSE_THREADS) {
                        r = OnDemandThreadPool.this.getNextJob();
                        if (r != null) continue;
                        object = this.NOTIFY;
                        synchronized (object) {
                            block39: {
                                Object object3 = OnDemandThreadPool.this.completionNotifier;
                                synchronized (object3) {
                                    OnDemandThreadPool.this.completionNotifier.notifyAll();
                                }
                                this.woken = false;
                                this.waiting = true;
                                try {
                                    this.NOTIFY.wait(OnDemandThreadPool.this.workerTimeout);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (!this.forceQuit) break block39;
                                return;
                            }
                            this.waiting = false;
                        }
                        r = OnDemandThreadPool.this.getNextJob();
                        continue;
                    }
                    r = OnDemandThreadPool.this.getNextJob();
                    OnDemandThreadPool.this.doStatsPrint();
                }
            }
            finally {
                object = OnDemandThreadPool.this.inside_LOCK;
                synchronized (object) {
                    --OnDemandThreadPool.this.inside;
                    OnDemandThreadPool.this.workers.remove(this);
                }
                if (Switches.SH_2018_printAllPoolAlerts) {
                    OnDemandThreadPool.this.lastProcessingFinished = System.currentTimeMillis();
                }
                T_run = System.currentTimeMillis() - T_run;
                OnDemandThreadPool.this.runs.measured(T_run);
            }
            object2 = OnDemandThreadPool.this.completionNotifier;
            synchronized (object2) {
                OnDemandThreadPool.this.completionNotifier.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanupNow() {
            this.forceQuit = true;
            Object object = this.NOTIFY;
            synchronized (object) {
                this.NOTIFY.notifyAll();
            }
        }
    }

    private class TimedJob
    implements Runnable {
        long request_T = System.currentTimeMillis();
        Runnable r;

        public TimedJob(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            this.request_T = System.currentTimeMillis() - this.request_T;
            OnDemandThreadPool.this.requests.measured(this.request_T);
            this.r.run();
        }
    }
}

