/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import utils.progtools.CheapTimingPrintStream;

public class CircularLogStream
extends OutputStream {
    RandomAccessFile raf;
    long initialB;
    long circleB;
    long chop = 0L;
    int seq = 1;
    byte[] seqdat = this.makeSeqDat();
    boolean flip = true;
    byte[] one = new byte[1];

    private byte[] makeSeqDat() {
        boolean bl = this.flip = !this.flip;
        if (this.flip) {
            return ("##" + this.seq + "## | ").getBytes();
        }
        return ("--" + this.seq + "-- | ").getBytes();
    }

    public CircularLogStream(File file, long initialB, long circleB) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.initialB = initialB;
        this.circleB = circleB;
    }

    public void setInitialSize(long bytes) {
        this.initialB = bytes;
    }

    public void setCircularSize(long bytes) {
        this.circleB = bytes;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    public void write(byte b) throws IOException {
        this.one[0] = b;
        this.write(this.one);
    }

    @Override
    public void write(int b) throws IOException {
        this.write((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.chop == 0L) {
            this.raf.write(b, off, len);
            long ptr = this.raf.getFilePointer();
            if (ptr > this.initialB) {
                this.raf.write("\n\n--- [CircularLogStream] End of log start, remaining log will be circular, sections denoted with '.##.' and '.--.'\n\n".getBytes());
                this.chop = this.raf.getFilePointer();
            }
        } else {
            if (len > 1) {
                this.raf.write(this.seqdat);
            }
            this.raf.write(b, off, len);
            long ptr = this.raf.getFilePointer();
            if (ptr > this.initialB + this.circleB) {
                this.raf.seek(this.chop);
                ++this.seq;
                this.seqdat = this.makeSeqDat();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        CircularLogStream clog = new CircularLogStream(new File("clogExample.log"), 5000L, 10000L);
        CheapTimingPrintStream pout = new CheapTimingPrintStream(clog);
        for (int i = 0; i < 10000; ++i) {
            ((PrintStream)pout).println("This is a test " + System.currentTimeMillis());
        }
    }
}

