/*
 * Decompiled with CFR 0.152.
 */
package utils.plist;

import java.util.Date;
import utils.plist.PListArray;
import utils.plist.PListDict;
import utils.plist.PListException;

public abstract class PListObject<T> {
    private static final int DEFAULT_INDENT = 4;
    private T value;

    T getValue(T def) {
        if (this.value == null) {
            return def;
        }
        return this.value;
    }

    PListObject(T value) {
        this.value = value;
    }

    public String getString(String def) throws PListException {
        throw new PListException("value is not string.");
    }

    public long getInt(long def) throws PListException {
        throw new PListException("value is not int.");
    }

    public double getReal(double def) throws PListException {
        throw new PListException("value is not real.");
    }

    public boolean getBool(boolean def) throws PListException {
        throw new PListException("value is not bool.");
    }

    public Date getDate(Date def) throws PListException {
        throw new PListException("value is not date.");
    }

    public PListDict getPListDict() throws PListException {
        throw new PListException("value is not dict.");
    }

    public PListArray getPListArray() throws PListException {
        throw new PListException("value is not array.");
    }

    public String toString() {
        return this.toString(4);
    }

    public String toString(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n').append("<plist version=\"1.0\">").append('\n');
        this.toString(sb, indent, 1);
        sb.append("</plist>").append('\n');
        return sb.toString();
    }

    static void insertSpaces(StringBuffer sb, int indent, int level) {
        indent *= level;
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    abstract Type getType();

    abstract void toString(StringBuffer var1, int var2, int var3);

    public static enum Type {
        Key,
        String,
        Int,
        Real,
        Bool,
        Date,
        Dict,
        Array;

    }
}

