/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.osx;

import java.io.IOException;
import java.util.ArrayList;
import utils.message.Message;
import utils.osstats.types.BasicInfo;
import utils.osstats.types.DiskConfig;
import utils.osstats.types.MemoryConfig;
import utils.osstats.types.ProcessorConfig;
import utils.ostools.RunCommandGetOutput;
import utils.plist.PListArray;
import utils.plist.PListDict;
import utils.plist.PListObject;
import utils.plist.PListParser;

public class OSXBasicInfo
extends BasicInfo {
    public String bootROMVersion;
    public String SMCVersion;
    public boolean upgradeableMemory;

    public OSXBasicInfo() {
        this(false, false);
    }

    public OSXBasicInfo(boolean fake, boolean memoryOnly) {
        super(fake, memoryOnly, true);
        if (fake) {
            this.bootROMVersion = "MBP121.0167.B16";
            this.SMCVersion = "2.28f7";
            this.upgradeableMemory = false;
        }
    }

    public OSXBasicInfo(Message loadFromMessage) {
        super(false, false, false);
        this.loadFromMessage(loadFromMessage);
    }

    @Override
    protected void loadFromMessage(Message m) {
        super.loadFromMessage(m);
        this.bootROMVersion = m.getNextString();
        this.SMCVersion = m.getNextString();
        this.upgradeableMemory = m.getNextBoolean();
    }

    @Override
    public Message toMessage() {
        Message m = super.toMessage();
        m.append(this.bootROMVersion);
        m.append(this.SMCVersion);
        m.append(this.upgradeableMemory);
        return m;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[OSX] ECC Memory: ").append(this.eccMemory).append("\n");
        builder.append("[OSX] Boot ROM Version: ").append(this.bootROMVersion).append("\n");
        builder.append("[OSX] SMC Version (system): ").append(this.SMCVersion).append("\n");
        return builder.toString();
    }

    @Override
    protected void readBasicInfo() {
        String processorName = null;
        long processorSpeedHz = 0L;
        int processorCount = 0;
        int coreCount = 0;
        boolean is64bit = false;
        try {
            RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"sysctl", "hw.cpu64bit_capable"});
            if (commandResponse.stdout != null) {
                is64bit = commandResponse.stdout.trim().equals("hw.cpu64bit_capable: 1");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.readBasicMemoryOnly();
        try {
            String output = RunCommandGetOutput.runCommandGetOutput(new String[]{"system_profiler", "-xml", "SPHardwareDataType", "SPMemoryDataType", "SPStorageDataType", "SPSerialATADataType"})[0];
            PListArray parse = (PListArray)PListParser.parse(output);
            PListDict hardwareDict = parse.getPListDict(0);
            PListDict memoryDict = parse.getPListDict(1);
            PListDict storageDict = parse.getPListDict(2);
            PListDict sataDict = parse.getPListDict(3);
            PListObject items = hardwareDict.getPListArray("_items").getPListDict(0);
            this.SMCVersion = ((PListDict)items).getString("SMC_version_system", null);
            this.bootROMVersion = ((PListDict)items).getString("boot_rom_version", null);
            this.serial = ((PListDict)items).getString("serial_number", null);
            this.computerModelName = ((PListDict)items).getString("machine_name", null);
            this.computerModelIdentifier = ((PListDict)items).getString("machine_model", null);
            processorCount = (int)((PListDict)items).getInt("packages", 0L);
            coreCount = (int)((PListDict)items).getInt("number_processors", 0L);
            processorSpeedHz = OSXBasicInfo.getAsHertz(((PListDict)items).getString("current_processor_speed", null));
            processorName = ((PListDict)items).getString("cpu_type", null);
            items = memoryDict.getPListArray("_items").getPListDict(0);
            this.eccMemory = !((PListDict)items).getString("global_ecc_state", "").equals("ecc_disabled");
            this.upgradeableMemory = !((PListDict)items).getString("is_memory_upgradeable", "").equalsIgnoreCase("no");
            ArrayList<MemoryConfig> memoryConfigs = new ArrayList<MemoryConfig>();
            PListArray memoryDicts = ((PListDict)items).getPListArray("_items");
            for (int i = 0; i < memoryDicts.size(); ++i) {
                PListDict slotDict = memoryDicts.getPListDict(i);
                MemoryConfig memory = new MemoryConfig();
                String manufacturer = slotDict.getString("dimm_manufacturer", null);
                if (manufacturer == null || manufacturer.equalsIgnoreCase("empty")) continue;
                memory.capacityBytes = OSXBasicInfo.getAsBytes(slotDict.getString("dimm_size", null));
                memory.manufacturer = slotDict.getString("dimm_manufacturer", null);
                memory.speedHz = OSXBasicInfo.getAsHertz(slotDict.getString("dimm_speed", null));
                memory.status = slotDict.getString("dimm_status", null);
                memory.type = slotDict.getString("dimm_type", null);
                if (memory.status != null) {
                    memory.status = memory.status.toUpperCase();
                }
                memoryConfigs.add(memory);
            }
            this.memoryConfig = memoryConfigs.toArray(new MemoryConfig[0]);
            items = storageDict.getPListArray("_items");
            ArrayList<DiskConfig> diskResults = new ArrayList<DiskConfig>();
            for (int i = 0; i < ((PListArray)items).size(); ++i) {
                PListDict diskDict = ((PListArray)items).getPListDict(i);
                PListDict physicalDiskDict = diskDict.getPListDict("physical_drive");
                DiskConfig config = new DiskConfig();
                config.disk = diskDict.getString("bsd_name", null);
                config.capacityBytes = diskDict.getInt("size_in_bytes", 0L);
                if (physicalDiskDict != null) {
                    config.deviceName = physicalDiskDict.getString("device_name", null);
                    config.internal = physicalDiskDict.getString("is_internal_disk", "").equalsIgnoreCase("yes");
                    config.mediaName = physicalDiskDict.getString("media_name", null);
                    config.type = physicalDiskDict.getString("medium_type", null);
                    config.protocol = physicalDiskDict.getString("protocol", null);
                }
                diskResults.add(config);
            }
            this.diskConfig = diskResults.toArray(new DiskConfig[0]);
            items = sataDict.getPListArray("_items");
            for (int i = 0; i < ((PListArray)items).size(); ++i) {
                PListDict dict = ((PListArray)items).getPListDict(i);
                PListArray subItems = dict.getPListArray("_items");
                for (int j = 0; j < subItems.size(); ++j) {
                    PListDict subDict = subItems.getPListDict(j);
                    String deviceName = subDict.getString("device_model", null);
                    if (deviceName == null) continue;
                    String serial = subDict.getString("device_serial", null);
                    for (DiskConfig config : this.diskConfig) {
                        if (config == null || config.deviceName == null || !config.deviceName.trim().equalsIgnoreCase(deviceName.trim())) continue;
                        config.serialNumber = serial;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.computerModelManufacturer = "Apple Inc.";
        if (processorName == null) {
            processorCount = 0;
        }
        this.processorConfig = new ProcessorConfig[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.processorConfig[i] = new ProcessorConfig();
            this.processorConfig[i].processorName = processorName;
            this.processorConfig[i].processorSpeedHz = processorSpeedHz;
            this.processorConfig[i].is64bit = is64bit;
            if (i == processorCount - 1) {
                int coreCountForThisCPU = coreCount / processorCount;
                coreCount -= coreCountForThisCPU;
                this.processorConfig[i].coreCount = coreCountForThisCPU;
                continue;
            }
            this.processorConfig[i].coreCount = coreCount;
        }
        try {
            String output = RunCommandGetOutput.runCommandGetOutput(new String[]{"uptime"})[0];
            this.lastBootTimeUTC = this.parseUptimeOutputAsUTC(output);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void readBasicMemoryOnly() {
        try {
            RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"sysctl", "hw.memsize"});
            if (commandResponse.stdout != null) {
                String response = commandResponse.stdout;
                response = response.substring(response.indexOf(58) + 1).trim();
                this.memoryTotalBytes = Long.parseLong(response);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String popKeyValueFromLine(String allOutput, String key) {
        int bsdNameIndex = allOutput.indexOf(key + ":");
        if (bsdNameIndex != -1) {
            return allOutput.substring(bsdNameIndex + (key.length() + 1), allOutput.indexOf(10, bsdNameIndex));
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        OSXBasicInfo info = new OSXBasicInfo();
        System.out.println(info);
    }
}

