/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import utils.message.MessageConstants;

public class Message
implements MessageConstants {
    public static boolean INCLUDE_CREATION_STACKS = false;
    int MINLEN = 10;
    private Object[] data;
    private int type = 0;
    private int length = 0;
    StringBuffer callstack = null;
    private int nextIndex = 0;

    public void appendToCallStack(String s) {
        if (this.callstack == null) {
            this.callstack = new StringBuffer();
        }
        this.callstack.append(s);
    }

    public void appendToCallStack(Throwable t) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(bout));
        this.appendToCallStack(new String(bout.toByteArray()));
    }

    public Message() {
        if (INCLUDE_CREATION_STACKS) {
            this.appendToCallStack("x");
        }
        this.data = new Object[this.MINLEN];
    }

    public Message(int type) {
        if (INCLUDE_CREATION_STACKS) {
            this.appendToCallStack("x");
        }
        this.type = type;
        this.data = new Object[this.MINLEN];
    }

    public Message(Message m) {
        this.type = m.type;
        this.length = m.length;
        this.data = new Object[m.length];
        System.arraycopy(m.data, 0, this.data, 0, this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] instanceof Message) {
                this.data[i] = new Message((Message)this.data[i]);
                continue;
            }
            if (this.data[i] instanceof byte[]) {
                this.data[i] = ((byte[])this.data[i]).clone();
                continue;
            }
            if (this.data[i] instanceof String[]) {
                this.data[i] = ((String[])this.data[i]).clone();
                continue;
            }
            if (this.data[i] instanceof int[]) {
                this.data[i] = ((int[])this.data[i]).clone();
                continue;
            }
            if (!(this.data[i] instanceof double[])) continue;
            this.data[i] = ((double[])this.data[i]).clone();
        }
        if (m.callstack != null) {
            this.callstack = new StringBuffer(m.callstack.toString());
        }
    }

    public void set(int index, Object o) {
        this.data[index] = o;
    }

    private void add(Object o) {
        if (this.length == this.data.length) {
            Object[] ndata = new Object[(int)((double)this.data.length * 1.5) + 1];
            System.arraycopy(this.data, 0, ndata, 0, this.length);
            this.data = ndata;
        }
        this.data[this.length] = o;
    }

    private Object internal_remove(int index) {
        Object o = this.data[index];
        for (int i = index; i < this.length - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        this.data[this.length - 1] = null;
        return o;
    }

    public void appendAll(Message message) {
        for (int i = 0; i < message.length; ++i) {
            this.add(message.data[i]);
            ++this.length;
        }
    }

    public void append(Message message) {
        this.add(message);
        ++this.length;
    }

    public void append(String string) {
        this.add(string);
        ++this.length;
    }

    public void append(int integer) {
        this.add(new Integer(integer));
        ++this.length;
    }

    public void append(Integer integer) {
        this.add(integer);
        ++this.length;
    }

    public void append(long longint) {
        this.add(new Long(longint));
        ++this.length;
    }

    public void append(Long longint) {
        this.add(longint);
        ++this.length;
    }

    public void append(byte byteInt) {
        this.add(new Byte(byteInt));
        ++this.length;
    }

    public void append(Byte byteInt) {
        this.add(byteInt);
        ++this.length;
    }

    public void append(double longfloat) {
        this.add(new Double(longfloat));
        ++this.length;
    }

    public void append(Double longfloat) {
        this.add(longfloat);
        ++this.length;
    }

    public void append(boolean bool) {
        this.add(new Boolean(bool));
        ++this.length;
    }

    public void append(Boolean bool) {
        this.add(bool);
        ++this.length;
    }

    public void append(byte[] bytes) {
        this.add(bytes);
        ++this.length;
    }

    public void append(int[] ints) {
        this.add(ints);
        ++this.length;
    }

    public void append(double[] doubles) {
        this.add(doubles);
        ++this.length;
    }

    public void append(long[] longs) {
        this.add(longs);
        ++this.length;
    }

    public void append(String[] strings) {
        this.add(strings);
        ++this.length;
    }

    public void appendRef_WARNING_NO_GETS(byte[] bytes, int off, int len) {
        this.add(new ByteArrayRef(bytes, off, len));
        ++this.length;
    }

    public void append(byte[] bytes, int off, int len) {
        byte[] b = new byte[len];
        System.arraycopy(bytes, off, b, 0, len);
        this.add(b);
        ++this.length;
    }

    public void append(int[] ints, int off, int len) {
        int[] b = new int[len];
        System.arraycopy(ints, off, b, 0, len);
        this.add(b);
        ++this.length;
    }

    public void append(double[] doubles, int off, int len) {
        double[] b = new double[len];
        System.arraycopy(doubles, off, b, 0, len);
        this.add(b);
        ++this.length;
    }

    public void append(long[] longs, int off, int len) {
        long[] b = new long[len];
        System.arraycopy(longs, off, b, 0, len);
        this.add(b);
        ++this.length;
    }

    public void append(String[] ints, int off, int len) {
        String[] b = new String[len];
        System.arraycopy(ints, off, b, 0, len);
        this.add(b);
        ++this.length;
    }

    public int getNextType() {
        return this.getType(this.nextIndex);
    }

    public void resetIndex() {
        this.nextIndex = 0;
    }

    public void setCurrentIndex(int currentIndex) {
        this.nextIndex = currentIndex;
    }

    public int getCurrentIndex() {
        return this.nextIndex;
    }

    public int getType(int i) {
        int tmp = this.nextIndex;
        Object o = this.get(i);
        this.nextIndex = tmp;
        if (o == null) {
            return 0;
        }
        if (o instanceof String) {
            return 0;
        }
        if (o instanceof Integer) {
            return 1;
        }
        if (o instanceof Long) {
            return 2;
        }
        if (o instanceof Double) {
            return 3;
        }
        if (o instanceof Boolean) {
            return 7;
        }
        if (o instanceof Message) {
            return 4;
        }
        if (o instanceof ByteArrayRef) {
            return 5;
        }
        if (o instanceof IntegerArrayRef) {
            return 9;
        }
        if (o instanceof StringArrayRef) {
            return 10;
        }
        if (o instanceof DoubleArrayRef) {
            return 12;
        }
        if (o instanceof LongArrayRef) {
            return 13;
        }
        if (o instanceof Byte) {
            return 8;
        }
        if (o instanceof int[]) {
            return 9;
        }
        if (o instanceof double[]) {
            return 12;
        }
        if (o instanceof long[]) {
            return 13;
        }
        if (o instanceof String[]) {
            return 10;
        }
        return 5;
    }

    public Object get(int i) {
        if (i >= this.length) {
            throw new ArrayIndexOutOfBoundsException("index " + i + " is larger than length " + this.length);
        }
        this.nextIndex = i + 1;
        Object o = this.data[i];
        return o;
    }

    public String getAsString(int i) {
        return (String)this.get(i);
    }

    public byte getAsByte(int i) {
        return (Byte)this.get(i);
    }

    public int getAsInt(int i) {
        return (Integer)this.get(i);
    }

    public double getAsDouble(int i) {
        return (Double)this.get(i);
    }

    public long getAsLong(int i) {
        return (Long)this.get(i);
    }

    public byte[] getFirstByteArray() {
        Object o = this.get(0);
        if (o instanceof ByteArrayRef) {
            return ((ByteArrayRef)o).allocateAndResolve();
        }
        return (byte[])o;
    }

    public long getFirstLong() {
        return this.getAsLong(0);
    }

    public int getFirstInt() {
        return this.getAsInt(0);
    }

    public double getFirstDouble() {
        return this.getAsDouble(0);
    }

    public String getFirstString() {
        return this.getAsString(0);
    }

    public boolean getFirstBoolean() {
        return this.getAsBoolean(0);
    }

    public Message getFirstMessage() {
        return this.getAsMessage(0);
    }

    public boolean getAsBoolean(int i) {
        return (Boolean)this.get(i);
    }

    public Message getAsMessage(int i) {
        return (Message)this.get(i);
    }

    public String getNextString() {
        return (String)this.get(this.nextIndex);
    }

    public String[] getNextStringArray() {
        return (String[])this.get(this.nextIndex);
    }

    public byte getNextByte() {
        return (Byte)this.get(this.nextIndex);
    }

    public int getNextInt() {
        return (Integer)this.get(this.nextIndex);
    }

    public Object getNext() {
        return this.get(this.nextIndex);
    }

    public int[] getNextIntArray() {
        return (int[])this.get(this.nextIndex);
    }

    public double[] getNextDoubleArray() {
        return (double[])this.get(this.nextIndex);
    }

    public long[] getNextLongArray() {
        return (long[])this.get(this.nextIndex);
    }

    public ByteArrayRef getNextByteArrayRef() {
        return (ByteArrayRef)this.get(this.nextIndex);
    }

    public byte[] getNextByteArray() {
        return (byte[])this.get(this.nextIndex);
    }

    public double getNextDouble() {
        return (Double)this.get(this.nextIndex);
    }

    public long getNextLong() {
        return (Long)this.get(this.nextIndex);
    }

    public boolean getNextBoolean() {
        return (Boolean)this.get(this.nextIndex);
    }

    public boolean hasNext() {
        return this.nextIndex < this.length();
    }

    public Message getNextMessage() {
        return (Message)this.get(this.nextIndex);
    }

    public Object remove(int index) {
        Object o = this.internal_remove(index);
        --this.length;
        return o;
    }

    public Object pop() {
        Object o = this.internal_remove(this.length - 1);
        --this.length;
        return o;
    }

    public Object peek() {
        return this.get(this.length - 1);
    }

    public void setType(int i) {
        this.type = i;
    }

    public int getType() {
        return this.type;
    }

    public int length() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Message) {
            return this.toString().equals(o.toString());
        }
        return super.equals(o);
    }

    public String toString() {
        return this.toString(0, false, null);
    }

    public String toString(Class[] srcs) {
        return this.toString(0, false, srcs);
    }

    private static String lookup(int value, Class[] srcs) {
        block6: {
            try {
                if (srcs == null) break block6;
                for (Class src : srcs) {
                    Field[] all;
                    for (Field field : all = src.getDeclaredFields()) {
                        try {
                            field.setAccessible(true);
                            int check = field.getInt(null);
                            if (check != value) continue;
                            return field.getName() + "/" + value + "/" + Integer.toHexString(value);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return value + "/" + Integer.toHexString(value);
    }

    public String toPretty(Class[] intrefs) {
        return this.toString(0, true, intrefs);
    }

    public String toPrettyHead(Class[] intrefs) {
        return this.toString(0, false, intrefs);
    }

    private void appendDepth(StringBuffer sb, int depth) {
        sb.append("\n");
        for (int i = 0; i < depth; ++i) {
            sb.append("   ");
        }
        sb.append(' ');
    }

    public String toString(int depth, boolean pretty, Class[] intrefs) {
        StringBuffer sb = new StringBuffer();
        sb.append("Message(");
        if (pretty) {
            sb.append(Message.lookup(this.type, intrefs));
        } else {
            sb.append(Message.lookup(this.type, intrefs));
        }
        sb.append(")");
        if (pretty) {
            sb.append(" n=").append(this.length);
        }
        for (int i = 0; i < this.length; ++i) {
            Object ref;
            Object o = this.data[i];
            if (pretty) {
                this.appendDepth(sb, depth);
            }
            sb.append("[");
            if (o == null) {
                sb.append("STR (null)");
            } else if (o instanceof String) {
                sb.append("STR,");
                sb.append(o);
            } else if (o instanceof Integer) {
                sb.append("INT,");
                sb.append(o);
            } else if (o instanceof Long) {
                sb.append("LONG,");
                sb.append(o);
            } else if (o instanceof Double) {
                sb.append("DOUBLE,");
                sb.append(o);
            } else if (o instanceof Message) {
                sb.append("SUBMSG,");
                sb.append(((Message)o).toString(depth + 1, pretty, intrefs));
            } else if (o instanceof Boolean) {
                sb.append("BOOL,");
                sb.append(o);
            } else if (o instanceof ByteArrayRef) {
                ref = (ByteArrayRef)o;
                sb.append("DATAREF,");
                sb.append(((ByteArrayRef)ref).len);
                sb.append(" bytes");
            } else if (o instanceof IntegerArrayRef) {
                ref = (IntegerArrayRef)o;
                sb.append("DATAREF,");
                sb.append(((IntegerArrayRef)ref).len);
                sb.append(" ints");
            } else if (o instanceof LongArrayRef) {
                ref = (LongArrayRef)o;
                sb.append("DATAREF,");
                sb.append(((LongArrayRef)ref).len);
                sb.append(" longs");
            } else if (o instanceof DoubleArrayRef) {
                ref = (DoubleArrayRef)o;
                sb.append("DATAREF,");
                sb.append(((DoubleArrayRef)ref).len);
                sb.append(" doubles");
            } else if (o instanceof StringArrayRef) {
                ref = (StringArrayRef)o;
                sb.append("DATAREF,");
                sb.append(((StringArrayRef)ref).len);
                sb.append(" strings");
            } else if (o instanceof Byte) {
                sb.append("BYTE,");
                sb.append(o);
            } else if (o instanceof int[]) {
                sb.append("IDATA,");
                sb.append(((int[])o).length);
                sb.append(" ints");
            } else if (o instanceof double[]) {
                sb.append("IDATA,");
                sb.append(((double[])o).length);
                sb.append(" doubles");
            } else if (o instanceof long[]) {
                sb.append("IDATA,");
                sb.append(((long[])o).length);
                sb.append(" longs");
            } else if (o instanceof String[]) {
                sb.append("IDATA,");
                sb.append(((String[])o).length);
                sb.append(" strings");
            } else {
                sb.append("DATA,");
                sb.append(((byte[])o).length);
                sb.append(" bytes");
            }
            sb.append("]");
        }
        if (this.callstack != null) {
            sb.append("CALLSTACK," + this.callstack.toString());
        }
        return sb.toString();
    }

    public Object clone() {
        return new Message(this);
    }

    public Message cloneShallow() {
        Message m = new Message(this.getType());
        m.appendAll(this);
        return m;
    }

    class StringArrayRef {
        String[] array;
        int off;
        int len;

        public StringArrayRef(String[] ar, int off, int len) {
            this.array = ar;
            this.off = off;
            this.len = len;
        }
    }

    class LongArrayRef {
        long[] array;
        int off;
        int len;

        public LongArrayRef(long[] ar, int off, int len) {
            this.array = ar;
            this.off = off;
            this.len = len;
        }
    }

    class DoubleArrayRef {
        double[] array;
        int off;
        int len;

        public DoubleArrayRef(double[] ar, int off, int len) {
            this.array = ar;
            this.off = off;
            this.len = len;
        }
    }

    class IntegerArrayRef {
        int[] array;
        int off;
        int len;

        public IntegerArrayRef(int[] ar, int off, int len) {
            this.array = ar;
            this.off = off;
            this.len = len;
        }
    }

    public class ByteArrayRef {
        public byte[] array;
        public int off;
        public int len;

        public ByteArrayRef(byte[] ar, int off, int len) {
            this.array = ar;
            this.off = off;
            this.len = len;
        }

        public byte[] allocateAndResolve() {
            byte[] tmp = new byte[this.len];
            System.arraycopy(this.array, this.off, tmp, 0, this.len);
            return tmp;
        }
    }
}

