/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import utils.files.FileUtil;
import utils.switches.Switches;

public class AtomicRenamer {
    private File instructionFile;
    private ArrayList<File> todo = new ArrayList();
    private final ArrayList<Runnable> postRenameRunners = new ArrayList();

    public AtomicRenamer(File instructionFile) {
        this.instructionFile = instructionFile;
    }

    public void addRenameInstruction(File from, File to) {
        this.todo.add(from);
        this.todo.add(to);
    }

    public void cancelAtomicMultiRename() throws IOException {
        this.todo.clear();
        this.instructionFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAtomicMultiRenameNow() throws IOException {
        try {
            System.out.println("[AtomicRenamer] Performing multi rename now.");
            if (this.todo.size() == 0) {
                boolean bl = this.completeAnyFailedAtomicMultiRenameNow();
                return bl;
            }
            StringBuilder sb = new StringBuilder();
            for (File aTodo : this.todo) {
                sb.append(aTodo).append("\n");
            }
            File instIncomplete = new File(this.instructionFile.getAbsolutePath() + ".ar-inst-incomplete");
            FileUtil.writeFileAsString(instIncomplete.getAbsolutePath(), sb.toString().trim());
            if (!instIncomplete.renameTo(this.instructionFile)) {
                System.out.println("[AtomicRenamer] WARNING: Renaming '" + instIncomplete + "' to '" + this.instructionFile + "' failed!? (" + instIncomplete.exists() + "," + this.instructionFile.exists() + ")");
            }
            boolean worked = this.completeAnyFailedAtomicMultiRenameNow();
            this.todo.clear();
            boolean bl = worked;
            return bl;
        }
        finally {
            for (Runnable runner : this.postRenameRunners) {
                runner.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostRenameRunner(Runnable runner) {
        ArrayList<Runnable> arrayList = this.postRenameRunners;
        synchronized (arrayList) {
            this.postRenameRunners.add(runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completeAnyFailedAtomicMultiRenameNow() throws IOException {
        if (this.instructionFile.exists()) {
            try {
                String lines = FileUtil.readFileAsString(this.instructionFile.getAbsolutePath()).trim();
                if (lines.length() > 0) {
                    int i;
                    String[] all = lines.split("\n");
                    ArrayList<RenameJob> jobs = new ArrayList<RenameJob>();
                    for (i = 0; i < all.length; ++i) {
                        System.out.println("[AtomicRenamer] " + i + " " + all[i]);
                    }
                    for (i = 0; i < all.length; i += 2) {
                        String from = all[i];
                        String to = all[i + 1];
                        jobs.add(new RenameJob(i / 2, from, to));
                    }
                    if (jobs.size() > 0) {
                        int tryLimit = 30;
                        for (int tryAttempts = 0; tryAttempts < tryLimit && jobs.size() > 0; ++tryAttempts) {
                            for (int i2 = jobs.size() - 1; i2 >= 0; --i2) {
                                if (!((RenameJob)jobs.get(i2)).tryRename()) continue;
                                jobs.remove(i2);
                            }
                            try {
                                Thread.sleep(300L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if (jobs.size() > 0) {
                            for (RenameJob job : jobs) {
                                try {
                                    job.doCopy();
                                }
                                catch (Throwable tt) {
                                    System.out.println("[AtomicRenamer] Copy failed. Attempting the rest.");
                                    tt.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
            finally {
                this.instructionFile.delete();
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(FileUtil.listDir(new File(".")));
        AtomicRenamer at = new AtomicRenamer(new File("atomic_rename_instructions"));
        if (at.instructionFile.exists()) {
            System.out.println("Finishing up then...");
            at.completeAnyFailedAtomicMultiRenameNow();
            System.out.println(FileUtil.listDir(new File(".")));
            System.exit(0);
        }
        System.out.println("Creating files...");
        for (int i = 0; i < 5; ++i) {
            File f = new File(i + ".old");
            File nf = new File(i + ".new");
            f.delete();
            nf.delete();
            new FileOutputStream(f).close();
            at.addRenameInstruction(f, nf);
        }
        System.out.println(FileUtil.listDir(new File(".")));
        System.out.println("Renaming files...");
        at.performAtomicMultiRenameNow();
        System.out.println("Listing final file list");
        System.out.println(FileUtil.listDir(new File(".")));
    }

    private class RenameJob {
        private String from;
        private String to;
        private int index;

        public RenameJob(int i, String from, String to) {
            this.index = i;
            this.from = from;
            this.to = to;
        }

        boolean tryRename() {
            if (new File(this.from).getName().equals("2.old")) {
                return false;
            }
            File fileFrom = new File(this.from);
            File fileTo = new File(this.to);
            System.out.println("[AtomicRenamer] [" + this.index + "] Renaming From: " + this.from + " (exists=" + fileFrom.exists() + ")");
            System.out.println("[AtomicRenamer] [" + this.index + "] Renaming To: " + this.to + " (exists=" + fileTo.exists() + ")");
            if (!fileFrom.exists() && fileTo.exists()) {
                System.out.println("[AtomicRenamer] Success. (Already been done)");
                return true;
            }
            if (fileFrom.exists() && fileTo.exists()) {
                System.out.println("[AtomicRenamer] Success. (Source and target exist)");
                return true;
            }
            if (!fileFrom.renameTo(fileTo)) {
                System.out.println("[AtomicRenamer] Failed.");
                return false;
            }
            System.out.println("[AtomicRenamer] Success [" + fileTo.exists() + "]");
            return true;
        }

        void doCopy() throws IOException {
            File fileFrom = new File(this.from);
            File fileTo = new File(this.to);
            if (fileTo.exists() && Switches.SH_1564_atomicRenamerNoCopyToExisting) {
                System.out.println("[AtomicRenamer] [" + this.index + "] Not attempting copy as destination already exists (so may be in the process of being copied already)");
            } else {
                fileTo.mkdirs();
                System.out.println("[AtomicRenamer] [" + this.index + "] Attempting copy as renames have failed.");
                FileUtil.copyFileOrDir(fileFrom, fileTo);
                FileUtil.deleteDir(fileFrom);
            }
        }
    }
}

