/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;

public class LogFolderCleaner {
    private static final int MAX_COUNT = 6;
    private static final long MAX_AGE = 604800000L;

    public static void cleanLogFilesLargerThan(File logFolder, long maxBytes) {
        File[] logs = logFolder.listFiles();
        if (logs == null) {
            return;
        }
        for (File f : logs) {
            if (f.length() <= maxBytes) continue;
            System.out.println("[LogFolderCleaner] Deleting large log file " + f);
            f.delete();
        }
    }

    public static void clean(File logFolder) {
        Object[] logs = logFolder.list();
        if (logs == null) {
            return;
        }
        Arrays.sort(logs);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
        Object prev = "";
        int run = 0;
        for (int i = logs.length - 1; i >= 0; --i) {
            File targetFile = new File(logFolder, (String)logs[i]);
            Object name = logs[i];
            try {
                int first = ((String)name).indexOf("-2");
                int last = ((String)name).lastIndexOf(46);
                String date = ((String)name).substring(first + 1, last);
                name = ((String)name).substring(0, first);
                run = ((String)name).equals(prev) ? ++run : 0;
                if (run >= 6) {
                    System.out.println("[LogFolderCleaner] Deleting " + (String)logs[i]);
                    new File(logFolder, (String)logs[i]).delete();
                } else {
                    try {
                        long time = Math.max(targetFile.lastModified(), sdf.parse(date).getTime());
                        long now = System.currentTimeMillis();
                        if (now - time > 604800000L) {
                            System.out.println("[LogFolderCleaner] Deleting " + (String)logs[i]);
                            new File(logFolder, (String)logs[i]).delete();
                        } else {
                            System.out.println("[LogFolderCleaner] Keeping " + (String)logs[i]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                prev = name;
                continue;
            }
            catch (Exception x) {
                System.out.println("[LogFolderCleaner] ignoring " + (String)name);
            }
        }
    }

    public static void main(String[] args) {
        LogFolderCleaner.clean(new File("/Users/aem/Library/Application Support/JWrapper-SimpleHelp Technician/logs"));
    }
}

