/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.Border;

public class RoundRectBorder
implements Border {
    protected Color color;
    protected int radius = 4;
    private int strokeWidth = 4;
    protected Stroke stroke = new BasicStroke(4.0f);
    private Color fillColor = null;
    private Paint overridePaint = null;
    private Insets shadowInsets = new Insets(0, 0, 3, 0);
    private int shadowWidth = 4;

    public RoundRectBorder(Color color) {
        this.color = color;
    }

    public void overrideWithPaint(Paint paint) {
        this.overridePaint = paint;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public void setWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.stroke = new BasicStroke(strokeWidth);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        int value = this.strokeWidth;
        return new Insets(this.shadowInsets.top + value, this.shadowInsets.left + value, this.shadowInsets.bottom + value, this.shadowInsets.right + value);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        Insets insets = this.getBorderInsets(comp);
        int arc = this.radius * 3;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setStroke(new BasicStroke(this.shadowWidth));
        g2.setColor(new Color(180, 180, 180, 80));
        g2.drawRoundRect(x + this.strokeWidth / 2, y + this.strokeWidth / 2, width - this.strokeWidth - 1, height - this.strokeWidth - 1, arc + this.shadowInsets.left + this.shadowInsets.right, arc + this.shadowInsets.top + this.shadowInsets.bottom);
        if (this.stroke != null) {
            g2.setStroke(this.stroke);
        }
        if (this.fillColor != null) {
            int borderX = x + this.shadowInsets.left;
            int borderY = y + this.shadowInsets.top;
            int borderWidth = width - this.shadowInsets.left - this.shadowInsets.right;
            int borderHeight = height - this.shadowInsets.top - this.shadowInsets.bottom;
            Insets borderInsets = new Insets(insets.top - this.shadowInsets.top, insets.left - this.shadowInsets.left, insets.bottom - this.shadowInsets.bottom, insets.right - this.shadowInsets.right);
            g2.setColor(this.fillColor);
            g2.setClip(borderX, borderY, borderWidth, borderInsets.top);
            g2.fillRoundRect(x + this.strokeWidth / 2 + this.shadowInsets.left, y + this.strokeWidth / 2 + this.shadowInsets.top, width - this.strokeWidth - this.shadowInsets.left - this.shadowInsets.right - 1, height - this.strokeWidth - this.shadowInsets.top - this.shadowInsets.bottom - 1, arc, arc);
            g2.setClip(borderX, borderY, borderInsets.left, borderHeight);
            g2.fillRoundRect(x + this.strokeWidth / 2 + this.shadowInsets.left, y + this.strokeWidth / 2 + this.shadowInsets.top, width - this.strokeWidth - this.shadowInsets.left - this.shadowInsets.right - 1, height - this.strokeWidth - this.shadowInsets.top - this.shadowInsets.bottom - 1, arc, arc);
            g2.setClip(borderX + borderWidth - borderInsets.right, borderY, borderInsets.right, borderHeight);
            g2.fillRoundRect(x + this.strokeWidth / 2 + this.shadowInsets.left + 1, y + this.strokeWidth / 2 + this.shadowInsets.top, width - this.strokeWidth - this.shadowInsets.left - this.shadowInsets.right - 1, height - this.strokeWidth - this.shadowInsets.top - this.shadowInsets.bottom - 1, arc, arc);
            g2.setClip(borderX, height - insets.bottom, borderWidth, borderInsets.bottom);
            g2.fillRoundRect(x + this.strokeWidth / 2 + this.shadowInsets.left, y + this.strokeWidth / 2 + this.shadowInsets.top + 1, width - this.strokeWidth - this.shadowInsets.left - this.shadowInsets.right - 1, height - this.strokeWidth - this.shadowInsets.top - this.shadowInsets.bottom - 1, arc, arc);
        }
        g2.setClip(x, y, width, height);
        g2.setColor(this.color);
        if (this.overridePaint != null) {
            g2.setPaint(this.overridePaint);
        }
        g2.drawRoundRect(x + this.strokeWidth / 2 + this.shadowInsets.left, y + this.strokeWidth / 2 + this.shadowInsets.top, width - this.strokeWidth - this.shadowInsets.left - this.shadowInsets.right - 1, height - this.strokeWidth - this.shadowInsets.top - this.shadowInsets.bottom - 1, arc, arc);
    }
}

