/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import jwrapper.proxy.JWProxyKeys;
import jwrapper.proxy.JWProxyList;
import utils.encryption.rsa.RSADecryptor;
import utils.encryption.rsa.RSAEncryptor;
import utils.stream.StreamUtils;

public class JWProxyCredentials {
    private HashMap<String, Credentials> map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File targetFile) throws IOException {
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(targetFile));
        try {
            int size = this.map.size();
            StreamUtils.writeInt(bout, size);
            RSAEncryptor rsaEncryptor = JWProxyCredentials.getEncryptor();
            for (String key : this.map.keySet()) {
                Credentials value = this.map.get(key);
                byte[] encryptedUsername = new byte[]{};
                byte[] encryptedPassword = new byte[]{};
                boolean hasPassword = value.password != null;
                try {
                    encryptedUsername = this.encryptString(rsaEncryptor, value.username);
                    if (hasPassword) {
                        encryptedPassword = this.encryptString(rsaEncryptor, value.password);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                StreamUtils.writeStringUTF8(bout, key);
                StreamUtils.writeBytes(bout, encryptedUsername);
                StreamUtils.writeBoolean(bout, hasPassword);
                if (!hasPassword) continue;
                StreamUtils.writeBytes(bout, encryptedPassword);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            bout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File file) throws IOException {
        if (file.exists()) {
            System.out.println("[JWProxyCredentials] Loading credentials from " + file + "...");
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
            try {
                int size = StreamUtils.readInt(bin);
                RSADecryptor descryptor = JWProxyCredentials.getDecryptor();
                for (int i = 0; i < size; ++i) {
                    String key = StreamUtils.readStringUTF8(bin);
                    byte[] encryptedUsername = StreamUtils.readBytes(bin);
                    byte[] encryptedPassword = null;
                    boolean hasPassword = StreamUtils.readBoolean(bin);
                    if (hasPassword) {
                        encryptedPassword = StreamUtils.readBytes(bin);
                    }
                    if (encryptedUsername.length == 0) continue;
                    try {
                        String username = this.decryptString(descryptor, encryptedUsername);
                        String password = null;
                        if (hasPassword) {
                            password = this.decryptString(descryptor, encryptedPassword);
                        }
                        this.map.put(key, new Credentials(username, password));
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                System.out.println("[JWProxyCredentials] Loaded " + size + " credentials.");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                bin.close();
            }
        }
    }

    public Credentials getCredentialsFor(Proxy proxy) {
        String key = this.getKey(proxy);
        return this.map.get(key);
    }

    public Credentials getCredentialsFor(String hostname, int port) {
        String key = JWProxyCredentials.getKey(hostname, port);
        return this.map.get(key);
    }

    public void setCredentialsFor(Proxy proxy, Credentials credentials) {
        String key = this.getKey(proxy);
        this.map.put(key, credentials);
    }

    private String getKey(Proxy proxy) {
        InetSocketAddress address = (InetSocketAddress)proxy.address();
        return JWProxyCredentials.getKey(JWProxyList.getHostnameFrom(address), address.getPort());
    }

    public static String getKey(String hostname, int port) {
        return hostname + ":" + port;
    }

    private byte[] encryptString(RSAEncryptor rsaEncryptor, String string) {
        try {
            byte[] data = string.getBytes("UTF-8");
            return rsaEncryptor.encrypt(data);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String decryptString(RSADecryptor rsaDecryptor, byte[] encryptedData) {
        try {
            byte[] decryptedData = rsaDecryptor.decrypt(encryptedData);
            return new String(decryptedData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RSAEncryptor getEncryptor() {
        return new RSAEncryptor(JWProxyKeys.getPrivate());
    }

    private static RSADecryptor getDecryptor() {
        return new RSADecryptor(JWProxyKeys.getPublic());
    }

    public static class Credentials {
        public String username;
        public String password;

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

