/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import bcutil.BCUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import jwrapper.jwutils.JWSockIPCListener;
import jwrapper.updater.JWLaunchProperties;
import utils.encryption.aes.Rijndael;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.multiplex.MultiplexerInputStream;
import utils.multiplex.MultiplexerOutputStream;
import utils.stream.StreamCloseDetector;
import utils.stream.StreamCloseListener;
import utils.string.Base64;

public class JWSockIPC {
    private static final boolean DEBUG_STDOUT = false;
    private Socket ipcSock;
    private MultiplexerInputStream xin;
    private MultiplexerOutputStream xout;
    private String aesString;
    private boolean closeDetected = false;
    Object map_LOCK = new Object();
    HashMap outmap = new HashMap();
    HashMap inmap = new HashMap();
    private static final String PROP_HOST = "jwsockipc.hostname";
    private static final String PROP_SERV_PORT = "jwsockipc.serverport";
    private static final String PROP_CLI_PORT = "jwsockipc.clientport";
    private static final String PROP_ENCRYPTED = "jwsockipc.aesenc";
    private static final String PROP_IDENT = "jwsockipc.ident";
    private static Object LOCK = new Object();
    private static HashMap map = new HashMap();
    static SecureRandom sr;

    private JWSockIPC(Socket sock, String aesString) {
        this.ipcSock = sock;
        this.aesString = aesString;
    }

    public static JWSockIPC createNewIPC(Socket sock) {
        return new JWSockIPC(sock, "");
    }

    public boolean isCloseDetected() {
        return this.closeDetected;
    }

    public String toString() {
        return "JWIPC-" + this.ipcSock;
    }

    public Socket getRawUnencryptedSocket() {
        return this.ipcSock;
    }

    public void setupMultipleChannels() throws IOException {
        if (this.xin == null) {
            byte[] aesKey = JWSockIPC.getAesKey(this.aesString);
            if (aesKey == null) {
                this.xin = new MultiplexerInputStream(new BufferedInputStream(this.ipcSock.getInputStream()));
                this.xout = new MultiplexerOutputStream(new BufferedOutputStream(this.ipcSock.getOutputStream()));
            } else {
                this.xin = new MultiplexerInputStream(new BufferedInputStream(new RijndaelDecryptionStream((InputStream)new BufferedInputStream(this.ipcSock.getInputStream()), aesKey)));
                this.xout = new MultiplexerOutputStream(new BufferedOutputStream(new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream(this.ipcSock.getOutputStream()), aesKey)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInChannel(short id) {
        InputStream in;
        Object object = this.map_LOCK;
        synchronized (object) {
            in = (InputStream)this.inmap.get(new Short(id));
            if (in == null) {
                in = this.xin.getBufInputStream(id, "JWSockIPC-channel-" + id);
                this.inmap.put(new Short(id), in);
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutChannel(short id) {
        OutputStream out;
        Object object = this.map_LOCK;
        synchronized (object) {
            out = (OutputStream)this.outmap.get(new Short(id));
            if (out == null) {
                out = this.xout.getBufOutputStream(id);
                this.outmap.put(new Short(id), out);
            }
        }
        return out;
    }

    public void close() {
        try {
            if (this.xin != null) {
                this.xin.closeAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.xout != null) {
                this.xout.closeAll(new IOException("JWSockIPC closed"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ipcSock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setupForIPC(Properties launchProperties, boolean aesEncrypted) throws IOException {
        JWSockIPC.setupForIPC("", launchProperties, aesEncrypted);
    }

    public static void dumpIPCProperties(Properties props) {
        JWSockIPC.dumpIPCProperties(props, "");
    }

    public static void dumpIPCProperties(Properties props, String propsprefix) {
        System.out.println("[JWSockIPC] Property dump:");
        System.out.println("[JWSockIPC] Host: " + props.getProperty(PROP_HOST + propsprefix));
        System.out.println("[JWSockIPC] Server Port: " + props.getProperty(PROP_SERV_PORT + propsprefix));
        System.out.println("[JWSockIPC] Client Port: " + props.getProperty(PROP_CLI_PORT + propsprefix));
        System.out.println("[JWSockIPC] Encrypted: " + props.getProperty(PROP_ENCRYPTED + propsprefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupForIPC(String propsprefix, Properties launchProperties, boolean aesEncrypted) throws IOException {
        String localhost;
        ConnectSpec spec = new ConnectSpec();
        try {
            localhost = InetAddress.getByName(null).getHostAddress();
        }
        catch (Exception x) {
            localhost = "localhost";
        }
        System.out.println("[JWSockIPC] Binding to loopback IP: " + localhost);
        spec.listening = new ServerSocket(0, 1, InetAddress.getByName(localhost));
        spec.placeholder = new ServerSocket(0, 1, InetAddress.getByName(localhost));
        launchProperties.put(PROP_HOST + propsprefix, localhost);
        launchProperties.put(PROP_SERV_PORT + propsprefix, "" + spec.placeholder.getLocalPort());
        launchProperties.put(PROP_CLI_PORT + propsprefix, "" + spec.listening.getLocalPort());
        String ident = "" + BCUtil.getNextAbsID();
        launchProperties.put(PROP_IDENT + propsprefix, ident);
        System.out.println("[JWSockIPC] IPC Ident: " + ident);
        if (sr == null) {
            sr = new SecureRandom();
        }
        byte[] aesKey = new byte[16];
        sr.nextBytes(aesKey);
        Rijndael rd = new Rijndael();
        rd.init("@$%TYHVFHTdbhjwguhiu32nbhjjhhhhhysadghi2rhiubdakjdnfhjagrouy23oubcfuef2bhjcdeiv2uy2gcyughIIUOUytr34i2uegruqvfdkgioOOOuyudsyryt");
        aesKey = rd.encryptCTR(aesKey, 0, aesKey.length);
        if (aesEncrypted) {
            launchProperties.put(PROP_ENCRYPTED + propsprefix, "" + Base64.byteArrayToBase64(aesKey));
        }
        while (!spec.placeholder.isClosed()) {
            spec.placeholder.close();
        }
        Object object = LOCK;
        synchronized (object) {
            map.put(ident, spec);
        }
    }

    private static byte[] getAesKey(String stored) throws IOException {
        if (stored == null) {
            return null;
        }
        if (stored.trim().length() == 0) {
            return null;
        }
        byte[] aesKey = Base64.base64ToByteArray(stored);
        Rijndael rd = new Rijndael();
        rd.init("@$%TYHVFHTdbhjwguhiu32nbhjjhhhhhysadghi2rhiubdakjdnfhjagrouy23oubcfuef2bhjcdeiv2uy2gcyughIIUOUytr34i2uegruqvfdkgioOOOuyudsyryt");
        aesKey = rd.decryptCTR(aesKey, 0);
        return aesKey;
    }

    public static void cancelIPC(String propsprefix, Properties launchProperties) {
        String ipcIdent = launchProperties.getProperty(PROP_IDENT + propsprefix);
        ConnectSpec spec = (ConnectSpec)map.remove(ipcIdent);
        if (spec != null) {
            try {
                spec.listening.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                spec.placeholder.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Socket connectAgnostic(ServerSocket ssock, String clihost, int cliport, boolean choose) throws IOException {
        Object NOTIFY;
        Object object = NOTIFY = new Object();
        synchronized (object) {
            ServerConnect scon = new ServerConnect(!choose);
            scon.ssock = ssock;
            scon.notify = NOTIFY;
            scon.start();
            ClientConnect ccon = new ClientConnect(!choose);
            ccon.host = clihost;
            ccon.port = cliport;
            ccon.notify = NOTIFY;
            ccon.start();
            try {
                NOTIFY.wait(300000L);
            }
            catch (InterruptedException x) {
                throw new IOException("Interrupted while waiting for connection");
            }
            if (choose) {
                if (ccon.sock != null) {
                    ccon.sock.getOutputStream().write(1);
                    ccon.sock.getOutputStream().flush();
                    scon.die();
                    return ccon.sock;
                }
                if (scon.sock != null) {
                    scon.sock.getOutputStream().write(1);
                    scon.sock.getOutputStream().flush();
                    ccon.die();
                    return scon.sock;
                }
            } else {
                if (ccon.sock != null) {
                    scon.die();
                    return ccon.sock;
                }
                if (scon.sock != null) {
                    ccon.die();
                    return scon.sock;
                }
            }
            throw new IOException("Unable to connect to set up Sock IPC to process");
        }
    }

    public static JWSockIPC connectChild() throws IOException {
        return JWSockIPC.connectChild("");
    }

    public static JWSockIPC connectChild(String propsprefix) throws IOException {
        String bindhost = JWLaunchProperties.getProperty(PROP_HOST + propsprefix);
        int servport = Integer.parseInt(JWLaunchProperties.getProperty(PROP_SERV_PORT + propsprefix));
        int cliport = Integer.parseInt(JWLaunchProperties.getProperty(PROP_CLI_PORT + propsprefix));
        String aesString = JWLaunchProperties.getProperty(PROP_ENCRYPTED + propsprefix);
        if (bindhost == null) {
            throw new IOException("This process is not set up for JWSockIPC");
        }
        Random r = new Random(System.currentTimeMillis());
        ServerSocket ssock = null;
        int attempts = 0;
        int total = 20;
        while (ssock == null && attempts < total) {
            ++attempts;
            try {
                ssock = new ServerSocket(servport, 1, InetAddress.getByName(bindhost));
            }
            catch (Throwable t) {
                try {
                    Thread.sleep(50 + r.nextInt(50));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return new JWSockIPC(JWSockIPC.connectAgnostic(ssock, bindhost, cliport, false), aesString);
    }

    public static JWSockIPC connectParent(Properties launchProperties) throws IOException {
        return JWSockIPC.connectParent("", launchProperties);
    }

    public static JWSockIPC connectParent(String propsprefix, Properties launchProperties) throws IOException {
        String ipcIdent = launchProperties.getProperty(PROP_IDENT + propsprefix);
        ConnectSpec spec = null;
        if (ipcIdent != null) {
            spec = (ConnectSpec)map.remove(ipcIdent);
        }
        if (spec != null) {
            String bindhost = launchProperties.getProperty(PROP_HOST + propsprefix);
            int servport = Integer.parseInt(launchProperties.getProperty(PROP_SERV_PORT + propsprefix));
            String aesString = launchProperties.getProperty(PROP_ENCRYPTED + propsprefix);
            return new JWSockIPC(JWSockIPC.connectAgnostic(spec.listening, bindhost, servport, true), aesString);
        }
        throw new IOException("No JWSockIPC set up for this set of Launch Properties");
    }

    public void setupPingsAndReportClosure(JWSockIPCListener listener, short channel) {
        this.setupPingsAndReportClosure(listener, channel, 30000L);
    }

    public void setupPingsAndReportClosure(JWSockIPCListener listener, short channel, long timeoutMS) {
        if (this.xin == null) {
            try {
                this.setupMultipleChannels();
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        new StreamCloseDetector(this.getInChannel(channel), this.getOutChannel(channel), new CloseNotifier(listener), timeoutMS);
    }

    private class CloseNotifier
    implements StreamCloseListener {
        JWSockIPCListener listener;

        public CloseNotifier(JWSockIPCListener listener) {
            this.listener = listener;
        }

        @Override
        public void streamClosed(String reason) {
            JWSockIPC.this.closeDetected = true;
            System.out.println("[JWSockIPC] Stream closed: " + reason);
            if (this.listener != null) {
                this.listener.ipcClosed();
            }
        }
    }

    private static class ServerConnect
    extends Thread {
        Object notify;
        Socket sock;
        ServerSocket ssock;
        boolean cancelled = false;
        boolean listening;

        public ServerConnect(boolean listening) {
            this.listening = listening;
        }

        public void die() {
            this.cancelled = true;
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.ssock.setSoTimeout(300000);
                Socket sock = this.ssock.accept();
                if (this.listening) {
                    int timeout = sock.getSoTimeout();
                    sock.setSoTimeout(10000);
                    if (sock.getInputStream().read() == 0) {
                        this.cancelled = true;
                    }
                    sock.setSoTimeout(timeout);
                }
                Object object = this.notify;
                synchronized (object) {
                    if (this.cancelled) {
                        try {
                            sock.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return;
                    }
                    this.sock = sock;
                    this.notify.notifyAll();
                    return;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                System.out.println("[ServerConnect] Exception: " + x.getMessage());
                return;
            }
        }
    }

    static class SimultaneousOpenConnectionException
    extends Exception {
        SimultaneousOpenConnectionException() {
        }
    }

    private static class ClientConnect
    extends Thread {
        Object notify;
        Socket sock;
        String host;
        int port;
        boolean cancelled = false;
        boolean listening;

        public ClientConnect(boolean listening) {
            this.listening = listening;
        }

        public void die() {
            this.cancelled = true;
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long t = System.currentTimeMillis() + 300000L;
            while (System.currentTimeMillis() < t) {
                try {
                    Socket sock = new Socket(this.host, this.port);
                    if (this.listening) {
                        int timeout = sock.getSoTimeout();
                        sock.setSoTimeout(10000);
                        if (sock.getInputStream().read() == 0) {
                            this.cancelled = true;
                        }
                        sock.setSoTimeout(timeout);
                    }
                    Object object = this.notify;
                    synchronized (object) {
                        if (this.cancelled) {
                            try {
                                sock.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return;
                        }
                        if (sock.getLocalPort() == sock.getPort()) {
                            sock.close();
                            Thread.sleep(100L);
                            throw new SimultaneousOpenConnectionException();
                        }
                        this.sock = sock;
                        this.notify.notifyAll();
                        return;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private static class ConnectSpec {
        ServerSocket listening;
        ServerSocket placeholder;

        private ConnectSpec() {
        }
    }
}

