/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LoadPanel
extends JPanel {
    protected static final Color BACKGROUND = Color.WHITE;
    protected static Color BORDERCOLOR = new Color(80, 129, 190);
    protected static Color TEXTCOLOR = new Color(30, 30, 30);
    protected static Color SHADE_TOP = new Color(185, 225, 247);
    protected static Color SHADE_BOTTOM = new Color(157, 199, 230);
    private ArrayList bars = new ArrayList();
    private CustomProgressBar pBar;
    private Image img;
    private ImagePanel imagePanel = new ImagePanel();
    private JPanel panel1 = new JPanel();
    private JPanel panel2 = new JPanel();

    public LoadPanel() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.pBar = new CustomProgressBar(0, 100, BACKGROUND);
        this.panel1.setBackground(BACKGROUND);
        this.panel2.setBackground(BACKGROUND);
        gbl.setConstraints(this.panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 10000.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(this.imagePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 20, 2), 0, 0));
        gbl.setConstraints(this.pBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        gbl.setConstraints(this.panel2, new GridBagConstraints(0, 3, 1, 1, 1.0, 10000.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.panel1);
        this.add(this.pBar);
        this.add(this.panel2);
        this.add(this.imagePanel);
        this.setVisible(false);
    }

    private Color hex2Rgb(String colorStr, Color defaultColour) {
        if (colorStr == null || colorStr.trim().length() == 0) {
            return defaultColour;
        }
        colorStr = colorStr.trim();
        int offset = 0;
        if (colorStr.startsWith("#")) {
            offset = 1;
        }
        return new Color(Integer.valueOf(colorStr.substring(0 + offset, 2 + offset), 16), Integer.valueOf(colorStr.substring(2 + offset, 4 + offset), 16), Integer.valueOf(colorStr.substring(4 + offset, 6 + offset), 16));
    }

    public void parseLoadingBarColours(String string) {
        if (string == null) {
            return;
        }
        String[] lines = string.split("\\n");
        if (lines == null) {
            return;
        }
        int start = -1;
        int end = -1;
        String line = null;
        for (int i = 0; i < lines.length && start == -1; ++i) {
            int index;
            line = lines[i].trim();
            if (line.startsWith("#") || (index = line.indexOf("LOAD_PROGRESS_BAR")) == -1 || (start = line.indexOf(61, start)) == -1 || (end = line.indexOf(10, ++start)) != -1) continue;
            end = line.length();
        }
        if (start == -1 || line == null) {
            return;
        }
        String colours = line.substring(start, end);
        if (colours != null) {
            System.out.println("[TinyApplet] Loading custom colours: " + colours);
            colours = colours.trim();
            String[] cols = colours.split(",");
            System.out.println(colours);
            if (cols.length < 4) {
                return;
            }
            SHADE_TOP = this.hex2Rgb(cols[0], SHADE_TOP);
            SHADE_BOTTOM = this.hex2Rgb(cols[1], SHADE_BOTTOM);
            BORDERCOLOR = this.hex2Rgb(cols[2], BORDERCOLOR);
            TEXTCOLOR = this.hex2Rgb(cols[3], TEXTCOLOR);
            System.out.println(SHADE_TOP + ", " + SHADE_BOTTOM + ", " + BORDERCOLOR + ", " + TEXTCOLOR);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.img != null) {
            if (this.getWidth() < this.img.getWidth(null)) {
                this.imagePanel.setVisible(false);
            } else if (this.getHeight() < this.img.getHeight(null) + 20 + 2 + 2 + 2 + this.pBar.getHeight()) {
                this.imagePanel.setVisible(false);
            } else {
                this.imagePanel.setVisible(true);
            }
        }
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(BACKGROUND);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void addProgressBar(double max, double progress) {
        MonitorBar mBar = new MonitorBar();
        mBar.total = max;
        mBar.progress = progress;
        this.bars.add(mBar);
        this.updateBar();
    }

    public void setLogo(Image img) {
        this.img = img;
        if (img != null) {
            this.imagePanel.setImage(img);
        }
        this.invalidate();
        SwingUtilities.invokeLater(new Repainter(this));
    }

    public void setProgress(int index, double outof1) {
        MonitorBar mBar = (MonitorBar)this.bars.get(index);
        if (mBar.total == 0.0) {
            mBar.progress = outof1;
            mBar.total = outof1;
        } else {
            mBar.progress = outof1;
        }
        this.updateBar();
    }

    @Override
    public void setVisible(boolean b) {
        this.pBar.setVisible(b);
    }

    public void setProgress(int index, double thismuch, double outofthismuch) {
        MonitorBar mBar = (MonitorBar)this.bars.get(index);
        if (outofthismuch < mBar.total) {
            mBar.total = outofthismuch;
        }
        mBar.progress = thismuch / outofthismuch;
        this.updateBar();
    }

    private void updateBar() {
        double progress = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.bars.size(); ++i) {
            MonitorBar mBar = (MonitorBar)this.bars.get(i);
            total += mBar.total;
            progress += mBar.progress * mBar.total;
        }
        this.pBar.setPostFixText("");
        this.pBar.setValue((int)(progress * 100.0 / total));
        SwingUtilities.invokeLater(new Repainter(this.pBar));
    }

    public void setText(String text) {
        this.pBar.setText(text);
    }

    static class Repainter
    implements Runnable {
        private Component c;

        public Repainter(Component c) {
            this.c = c;
        }

        @Override
        public void run() {
            this.c.repaint();
        }
    }

    public static class ImagePanel
    extends JPanel {
        private Image img;
        private Dimension dim;

        public ImagePanel() {
            this.setOpaque(false);
            this.dim = new Dimension(0, 0);
        }

        public void setImage(Image image) {
            this.img = image;
            if (this.img != null) {
                this.dim = new Dimension();
                this.dim.height = this.img.getHeight(null);
                this.dim.width = this.img.getWidth(null);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            if (this.img != null) {
                int x = (this.getWidth() - this.img.getWidth(null)) / 2;
                int y = (this.getHeight() - this.img.getHeight(null)) / 2;
                g2d.drawImage(this.img, x, y, null);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.dim;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }
    }

    static class CustomProgressBar
    extends JPanel {
        private int value;
        private int min;
        private int max;
        private Dimension dim;
        private String text = "";
        private String postfix = "";

        public CustomProgressBar(int min, int max, Color background) {
            this.min = min;
            this.max = max;
            this.dim = new Dimension();
            this.dim.height = 22;
            this.dim.width = 500;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setPostFixText(String postfix) {
            this.postfix = postfix;
        }

        public void setValue(int value) {
            this.value = value;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            float frac = (float)this.value / (float)(this.max - this.min);
            Graphics2D g2d = (Graphics2D)g;
            int totalWidth = this.getWidth();
            int totalHeight = this.getHeight();
            int leftBuffer = Math.max(0, (totalWidth - 300) / 2) + 4;
            int buffer = 2;
            int fullWidth = (int)(frac * (float)(totalWidth - 2 * leftBuffer - 3));
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setColor(BACKGROUND);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setColor(BORDERCOLOR);
            g2d.drawRect(leftBuffer, 0, totalWidth - 2 * leftBuffer, this.getHeight() - 1);
            GradientPaint gp1 = new GradientPaint(leftBuffer, buffer, SHADE_TOP, leftBuffer, totalHeight - 2 * buffer, SHADE_BOTTOM);
            g2d.setPaint(gp1);
            g2d.fillRect(leftBuffer + buffer, buffer, fullWidth, totalHeight - 2 * buffer);
            g2d.setColor(TEXTCOLOR);
            Font font = Font.decode("SansSerif-BOLD-10");
            g2d.setFont(font);
            String textToShow = this.text + " ";
            TextLayout tl = new TextLayout(textToShow, font, g2d.getFontRenderContext());
            tl.draw(g2d, (float)((double)this.getWidth() - tl.getBounds().getWidth()) / 2.0f, (float)((double)this.getHeight() + tl.getBounds().getHeight()) / 2.0f - 1.0f);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.dim;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }
    }

    static class MonitorBar {
        double progress;
        double total;

        MonitorBar() {
        }
    }
}

