/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.stream.StreamUtils;

public class IcoPng {
    byte[] ico;
    int pngIndex;
    int pngLen;

    public IcoPng(byte[] ico, int pngIndex, int pngLen) {
        this.ico = ico;
        this.pngIndex = pngIndex;
        this.pngLen = pngLen;
    }

    public IcoPng(File f) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        this.pngIndex = StreamUtils.readInt(in);
        this.pngLen = StreamUtils.readInt(in);
        this.ico = StreamUtils.readAll(in);
        ((InputStream)in).close();
    }

    public void save(File f) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        StreamUtils.writeInt(out, this.pngIndex);
        StreamUtils.writeInt(out, this.pngLen);
        ((OutputStream)out).write(this.ico);
        ((OutputStream)out).close();
    }

    public byte[] getICO() {
        return this.ico;
    }

    public byte[] getPNG() {
        byte[] png = new byte[this.pngLen];
        System.arraycopy(this.ico, this.pngIndex, png, 0, this.pngLen);
        return png;
    }
}

