/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtil;

public class BCUtilFileTest {
    public static void main(String[] args) throws Exception {
        byte[] dat = "Working OK!".getBytes();
        String salt = "Some random phrase to prevent rainbow tables";
        String secret = "Another random or possibly just vaguely entropic phrase to use as a secret";
        long work = 4000L;
        dat = BCUtil.encryptWithSecret(dat, salt, secret, 4000);
        System.out.println(new String(dat));
        for (int i = 0; i < 10; ++i) {
            System.out.println();
        }
        dat = BCUtil.decryptWithSecret(dat, salt, secret, 4000);
        System.out.println(new String(dat));
        long T = System.currentTimeMillis();
        byte[] dat2 = new byte[]{0};
        byte[] one = BCUtil.encryptWithSecret(dat2, "salt", "hi", 80000);
        System.out.println("Time to encrypt (work=1000ms): " + (System.currentTimeMillis() - T) + "ms");
        T = System.currentTimeMillis();
        dat2 = new byte[]{5};
        byte[] two = BCUtil.encryptWithSecret(dat2, "salt", "hi", 80000);
        System.out.println("Time to encrypt (work=1000ms): " + (System.currentTimeMillis() - T) + "ms");
        BCUtilFileTest.printDiff(one, two, 4);
        long X = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            long T2 = System.currentTimeMillis();
            byte[] dat3 = new byte[1];
            BCUtil.encryptWithSecret(dat3, "salt", "hi", 4000);
            System.out.println("Time to encrypt (work=50ms): " + (System.currentTimeMillis() - T2) + "ms");
        }
        X = System.currentTimeMillis() - X;
        System.out.println("Time to perform 10 encryptions (work=50ms): " + X + "ms");
    }

    private static void print(byte[] array, int cols) {
        for (int N = 0; N < array.length; ++N) {
            System.out.print("\t" + array[N]);
            if (N % cols != 0) continue;
            System.out.println();
        }
    }

    private static void printDiff(byte[] array, byte[] array2, int cols) {
        for (int N = 0; N < array.length; ++N) {
            System.out.print("\t" + (array[N] - array2[N]));
            if (N % cols != 0) continue;
            System.out.println();
        }
    }
}

