/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Dimension;
import com.pdfjet.Font;
import com.pdfjet.Page;
import com.pdfjet.Paragraph;
import com.pdfjet.Point;
import com.pdfjet.TextLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextColumn {
    protected int alignment = 0;
    protected int rotate;
    private float x;
    private float y;
    private float w;
    private float h;
    private float x1;
    private float y1;
    private float line_height;
    private float space_between_lines = 1.0f;
    private float space_between_paragraphs = 2.0f;
    private List<Paragraph> paragraphs;
    private boolean lineBetweenParagraphs = false;

    public TextColumn() {
        this.paragraphs = new ArrayList<Paragraph>();
    }

    public TextColumn(int n) throws Exception {
        this.rotate = n;
        if (this.rotate != 0 && this.rotate != 90 && this.rotate != 270) {
            throw new Exception("Invalid rotation angle. Please use 0, 90 or 270 degrees.");
        }
        this.paragraphs = new ArrayList<Paragraph>();
    }

    public void setLineBetweenParagraphs(boolean bl) {
        this.lineBetweenParagraphs = bl;
    }

    public void setSpaceBetweenLines(float f) {
        this.space_between_lines = f;
    }

    public void setSpaceBetweenParagraphs(float f) {
        this.space_between_paragraphs = f;
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        this.x1 = f;
        this.y1 = f2;
    }

    public void setSize(double d, double d2) {
        this.setSize((float)d, (float)d2);
    }

    public void setSize(float f, float f2) {
        this.w = f;
        this.h = f2;
    }

    public void setWidth(float f) {
        this.w = f;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setLineSpacing(double d) {
        this.space_between_lines = (float)d;
    }

    public void setLineSpacing(float f) {
        this.space_between_lines = f;
    }

    public void addParagraph(Paragraph paragraph) {
        this.paragraphs.add(paragraph);
    }

    public void removeLastParagraph() {
        if (this.paragraphs.size() >= 1) {
            this.paragraphs.remove(this.paragraphs.size() - 1);
        }
    }

    public Dimension getSize() throws Exception {
        Point point = this.drawOn(null, false);
        return new Dimension(this.w, point.y - this.y);
    }

    public Point drawOn(Page page) throws Exception {
        return this.drawOn(page, true);
    }

    public Point drawOn(Page page, boolean bl) throws Exception {
        Point point = null;
        for (int i = 0; i < this.paragraphs.size(); ++i) {
            Paragraph paragraph = this.paragraphs.get(i);
            this.alignment = paragraph.alignment;
            point = this.drawParagraphOn(page, paragraph, bl);
        }
        this.setLocation(this.x, this.y);
        return point;
    }

    private Point drawParagraphOn(Page page, Paragraph paragraph, boolean bl) throws Exception {
        ArrayList<TextLine> arrayList = new ArrayList<TextLine>();
        float f = 0.0f;
        for (int i = 0; i < paragraph.list.size(); ++i) {
            TextLine textLine = paragraph.list.get(i);
            if (i == 0) {
                this.line_height = textLine.font.body_height + this.space_between_lines;
                if (this.rotate == 0) {
                    this.y1 += textLine.font.ascent;
                } else if (this.rotate == 90) {
                    this.x1 += textLine.font.ascent;
                } else if (this.rotate == 270) {
                    this.x1 -= textLine.font.ascent;
                }
            }
            String[] stringArray = textLine.str.split("\\s");
            TextLine textLine2 = null;
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                textLine2 = new TextLine(textLine.font, string);
                textLine2.setColor(textLine.getColor());
                textLine2.setUnderline(textLine.getUnderline());
                textLine2.setStrikeout(textLine.getStrikeout());
                textLine2.setURIAction(textLine.getURIAction());
                textLine2.setGoToAction(textLine.getGoToAction());
                textLine2.setFallbackFont(textLine.getFallbackFont());
                f += textLine.font.stringWidth(textLine.getFallbackFont(), string);
                if (f >= this.w) {
                    this.drawLineOfText(page, arrayList, bl);
                    this.moveToNextLine();
                    arrayList.clear();
                    arrayList.add(textLine2);
                    f = textLine.font.stringWidth(textLine.getFallbackFont(), string + " ");
                    continue;
                }
                arrayList.add(textLine2);
                f += textLine.font.stringWidth(textLine.getFallbackFont(), " ");
            }
        }
        this.drawNonJustifiedLine(page, arrayList, bl);
        if (this.lineBetweenParagraphs) {
            return this.moveToNextLine();
        }
        return this.moveToNextParagraph(this.space_between_paragraphs);
    }

    private Point moveToNextLine() {
        if (this.rotate == 0) {
            this.x1 = this.x;
            this.y1 += this.line_height;
        } else if (this.rotate == 90) {
            this.x1 += this.line_height;
            this.y1 = this.y;
        } else if (this.rotate == 270) {
            this.x1 -= this.line_height;
            this.y1 = this.y;
        }
        return new Point(this.x1, this.y1);
    }

    private Point moveToNextParagraph(float f) {
        if (this.rotate == 0) {
            this.x1 = this.x;
            this.y1 += f;
        } else if (this.rotate == 90) {
            this.x1 += f;
            this.y1 = this.y;
        } else if (this.rotate == 270) {
            this.x1 -= f;
            this.y1 = this.y;
        }
        return new Point(this.x1, this.y1);
    }

    private void drawLineOfText(Page page, List<TextLine> list, boolean bl) throws Exception {
        if (this.alignment == 0x300000) {
            float f = 0.0f;
            for (int i = 0; i < list.size(); ++i) {
                TextLine textLine = list.get(i);
                f += textLine.font.stringWidth(textLine.getFallbackFont(), textLine.str);
            }
            float f2 = (this.w - f) / (float)(list.size() - 1);
            for (int i = 0; i < list.size(); ++i) {
                TextLine textLine = list.get(i);
                textLine.setPosition(this.x1, this.y1);
                if (textLine.getGoToAction() != null) {
                    page.addAnnotation(new Annotation(null, textLine.getGoToAction(), this.x, page.height - (this.y - textLine.font.ascent), this.x + textLine.font.stringWidth(textLine.getFallbackFont(), textLine.getText()), page.height - (this.y - textLine.font.descent), null, null, null));
                }
                if (this.rotate == 0) {
                    textLine.setTextDirection(0);
                    textLine.drawOn(page, bl);
                    this.x1 += textLine.font.stringWidth(textLine.getFallbackFont(), textLine.str) + f2;
                    continue;
                }
                if (this.rotate == 90) {
                    textLine.setTextDirection(90);
                    textLine.drawOn(page, bl);
                    this.y1 -= textLine.font.stringWidth(textLine.getFallbackFont(), textLine.str) + f2;
                    continue;
                }
                if (this.rotate != 270) continue;
                textLine.setTextDirection(270);
                textLine.drawOn(page, bl);
                this.y1 += textLine.font.stringWidth(textLine.getFallbackFont(), textLine.str) + f2;
            }
        } else {
            this.drawNonJustifiedLine(page, list, bl);
        }
    }

    private void drawNonJustifiedLine(Page page, List<TextLine> list, boolean bl) throws Exception {
        TextLine textLine;
        int n;
        float f = 0.0f;
        for (n = 0; n < list.size(); ++n) {
            textLine = list.get(n);
            if (n < list.size() - 1) {
                textLine.str = textLine.str + " ";
            }
            f += textLine.font.stringWidth(textLine.getFallbackFont(), textLine.str);
        }
        if (this.alignment == 0x100000) {
            if (this.rotate == 0) {
                this.x1 = this.x + (this.w - f) / 2.0f;
            } else if (this.rotate == 90) {
                this.y1 = this.y - (this.w - f) / 2.0f;
            } else if (this.rotate == 270) {
                this.y1 = this.y + (this.w - f) / 2.0f;
            }
        } else if (this.alignment == 0x200000) {
            if (this.rotate == 0) {
                this.x1 = this.x + (this.w - f);
            } else if (this.rotate == 90) {
                this.y1 = this.y - (this.w - f);
            } else if (this.rotate == 270) {
                this.y1 = this.y + (this.w - f);
            }
        }
        for (n = 0; n < list.size(); ++n) {
            textLine = list.get(n);
            textLine.setPosition(this.x1, this.y1);
            if (textLine.getGoToAction() != null) {
                page.addAnnotation(new Annotation(null, textLine.getGoToAction(), this.x, page.height - (this.y - textLine.font.ascent), this.x + textLine.font.stringWidth(textLine.getFallbackFont(), textLine.getText()), page.height - (this.y - textLine.font.descent), null, null, null));
            }
            if (this.rotate == 0) {
                textLine.setTextDirection(0);
                textLine.drawOn(page, bl);
                this.x1 += textLine.font.stringWidth(textLine.getFallbackFont(), textLine.str);
                continue;
            }
            if (this.rotate == 90) {
                textLine.setTextDirection(90);
                textLine.drawOn(page, bl);
                this.y1 -= textLine.font.stringWidth(textLine.getFallbackFont(), textLine.str);
                continue;
            }
            if (this.rotate != 270) continue;
            textLine.setTextDirection(270);
            textLine.drawOn(page, bl);
            this.y1 += textLine.font.stringWidth(textLine.getFallbackFont(), textLine.str);
        }
    }

    public void addChineseParagraph(Font font, String string) throws Exception {
        Paragraph paragraph = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            StringBuilder stringBuilder2 = new StringBuilder();
            if (font.stringWidth(stringBuilder2.append(stringBuilder.toString()).append(c).toString()) > this.w) {
                paragraph = new Paragraph();
                paragraph.add(new TextLine(font, stringBuilder.toString()));
                this.addParagraph(paragraph);
                stringBuilder.setLength(0);
            }
            stringBuilder.append(c);
        }
        paragraph = new Paragraph();
        paragraph.add(new TextLine(font, stringBuilder.toString()));
        this.addParagraph(paragraph);
    }
}

