/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.QRMath;

class Polynomial {
    private final int[] num;

    public Polynomial(int[] nArray) {
        this(nArray, 0);
    }

    public Polynomial(int[] nArray, int n) {
        int n2;
        for (n2 = 0; n2 < nArray.length && nArray[n2] == 0; ++n2) {
        }
        this.num = new int[nArray.length - n2 + n];
        System.arraycopy(nArray, n2, this.num, 0, nArray.length - n2);
    }

    public int get(int n) {
        return this.num[n];
    }

    public int getLength() {
        return this.num.length;
    }

    public Polynomial multiply(Polynomial polynomial) {
        int[] nArray = new int[this.getLength() + polynomial.getLength() - 1];
        for (int i = 0; i < this.getLength(); ++i) {
            for (int j = 0; j < polynomial.getLength(); ++j) {
                int n = i + j;
                nArray[n] = nArray[n] ^ QRMath.gexp(QRMath.glog(this.get(i)) + QRMath.glog(polynomial.get(j)));
            }
        }
        return new Polynomial(nArray);
    }

    public Polynomial mod(Polynomial polynomial) {
        int n;
        if (this.getLength() - polynomial.getLength() < 0) {
            return this;
        }
        int n2 = QRMath.glog(this.get(0)) - QRMath.glog(polynomial.get(0));
        int[] nArray = new int[this.getLength()];
        for (n = 0; n < this.getLength(); ++n) {
            nArray[n] = this.get(n);
        }
        for (n = 0; n < polynomial.getLength(); ++n) {
            int n3 = n;
            nArray[n3] = nArray[n3] ^ QRMath.gexp(QRMath.glog(polynomial.get(n)) + n2);
        }
        return new Polynomial(nArray).mod(polynomial);
    }
}

