/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Box;
import com.pdfjet.Drawable;
import com.pdfjet.Page;

public class Point
implements Drawable {
    public static final int INVISIBLE = -1;
    public static final int CIRCLE = 0;
    public static final int DIAMOND = 1;
    public static final int BOX = 2;
    public static final int PLUS = 3;
    public static final int H_DASH = 4;
    public static final int V_DASH = 5;
    public static final int MULTIPLY = 6;
    public static final int STAR = 7;
    public static final int X_MARK = 8;
    public static final int UP_ARROW = 9;
    public static final int DOWN_ARROW = 10;
    public static final int LEFT_ARROW = 11;
    public static final int RIGHT_ARROW = 12;
    public static final boolean CONTROL_POINT = true;
    protected float x;
    protected float y;
    protected float r = 2.0f;
    protected int shape = 0;
    protected int color = 0;
    protected int align = 0x200000;
    protected float lineWidth = 0.3f;
    protected String linePattern = "[] 0";
    protected boolean fillShape = false;
    protected boolean isControlPoint = false;
    protected boolean isStartOfPath = false;
    private String text;
    private int textColor;
    private int textDirection;
    private String uri;
    private float box_x;
    private float box_y;

    public Point() {
    }

    public Point(double d, double d2) {
        this((float)d, (float)d2);
    }

    public Point(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Point(double d, double d2, boolean bl) {
        this((float)d, (float)d2, bl);
    }

    public Point(float f, float f2, boolean bl) {
        this.x = f;
        this.y = f2;
        this.isControlPoint = bl;
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void setX(double d) {
        this.x = (float)d;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getX() {
        return this.x;
    }

    public void setY(double d) {
        this.y = (float)d;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getY() {
        return this.y;
    }

    public void setRadius(double d) {
        this.r = (float)d;
    }

    public void setRadius(float f) {
        this.r = f;
    }

    public float getRadius() {
        return this.r;
    }

    public void setShape(int n) {
        this.shape = n;
    }

    public int getShape() {
        return this.shape;
    }

    public void setFillShape(boolean bl) {
        this.fillShape = bl;
    }

    public boolean getFillShape() {
        return this.fillShape;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public void setLineWidth(double d) {
        this.lineWidth = (float)d;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLinePattern(String string) {
        this.linePattern = string;
    }

    public String getLinePattern() {
        return this.linePattern;
    }

    @Deprecated
    public void setDrawLineTo(boolean bl) {
        this.isStartOfPath = bl;
    }

    public void setStartOfPath() {
        this.isStartOfPath = true;
    }

    public void setURIAction(String string) {
        this.uri = string;
    }

    public String getURIAction() {
        return this.uri;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setTextColor(int n) {
        this.textColor = n;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextDirection(int n) {
        this.textDirection = n;
    }

    public int getTextDirection() {
        return this.textDirection;
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public int getAlignment() {
        return this.align;
    }

    public void placeIn(Box box) throws Exception {
        this.placeIn(box, 0.0f, 0.0f);
    }

    public void placeIn(Box box, double d, double d2) throws Exception {
        this.placeIn(box, (float)d, (float)d2);
    }

    public void placeIn(Box box, float f, float f2) throws Exception {
        this.box_x = box.x + f;
        this.box_y = box.y + f2;
    }

    public void drawOn(Page page) throws Exception {
        page.setPenWidth(this.lineWidth);
        page.setLinePattern(this.linePattern);
        if (this.fillShape) {
            page.setBrushColor(this.color);
        } else {
            page.setPenColor(this.color);
        }
        this.x += this.box_x;
        this.y += this.box_y;
        page.drawPoint(this);
        this.x -= this.box_x;
        this.y -= this.box_y;
    }
}

