/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Font;
import com.pdfjet.Page;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainText {
    private Font font;
    private String[] textLines;
    private float fontSize;
    private float x;
    private float y;
    private float w = 500.0f;
    private float leading;
    private int backgroundColor = 0xFFFFFF;
    private int borderColor = 0xFFFFFF;
    private int textColor = 0;
    private List<float[]> endOfLinePoints = null;
    private String language = null;
    private String altDescription = null;
    private String actualText = null;

    public PlainText(Font font, String[] stringArray) {
        this.font = font;
        this.fontSize = font.getSize();
        this.textLines = stringArray;
        this.endOfLinePoints = new ArrayList<float[]>();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        this.altDescription = stringBuilder.toString();
        this.actualText = stringBuilder.toString();
    }

    public PlainText setFontSize(float f) {
        this.fontSize = f;
        return this;
    }

    public PlainText setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public PlainText setWidth(float f) {
        this.w = f;
        return this;
    }

    public PlainText setLeading(float f) {
        this.leading = f;
        return this;
    }

    public PlainText setBackgroundColor(int n) {
        this.backgroundColor = n;
        return this;
    }

    public PlainText setBorderColor(int n) {
        this.borderColor = n;
        return this;
    }

    public PlainText setTextColor(int n) {
        this.textColor = n;
        return this;
    }

    public List<float[]> getEndOfLinePoints() {
        return this.endOfLinePoints;
    }

    public float[] drawOn(Page page) throws Exception {
        float f = this.font.getSize();
        this.font.setSize(this.fontSize);
        float f2 = this.y + this.font.getAscent();
        page.addBMC("Span", this.language, " ", " ");
        page.setBrushColor(this.backgroundColor);
        this.leading = this.font.getBodyHeight();
        float f3 = this.font.getBodyHeight() * (float)this.textLines.length;
        page.fillRect(this.x, this.y, this.w, f3);
        page.setPenColor(this.borderColor);
        page.setPenWidth(0.0f);
        page.drawRect(this.x, this.y, this.w, f3);
        page.setBrushColor(this.textColor);
        page.addEMC();
        page.addBMC("Span", this.language, this.altDescription, this.actualText);
        page.setTextStart();
        page.setTextFont(this.font);
        page.setTextLeading(this.leading);
        page.setTextLocation(this.x, f2);
        for (String string : this.textLines) {
            if (this.font.skew15) {
                this.setTextSkew(page, 0.26f, this.x, f2);
            }
            page.println(string);
            this.endOfLinePoints.add(new float[]{this.x + this.font.stringWidth(string), f2});
            f2 += this.leading;
        }
        page.setTextEnd();
        page.addEMC();
        this.font.setSize(f);
        return new float[]{this.x + this.w, this.y + f3};
    }

    private void setTextSkew(Page page, float f, float f2, float f3) throws Exception {
        page.append(1.0f);
        page.append(' ');
        page.append(0.0f);
        page.append(' ');
        page.append(f);
        page.append(' ');
        page.append(1.0f);
        page.append(' ');
        page.append(f2);
        page.append(' ');
        page.append(page.height - f3);
        page.append(" Tm\n");
    }
}

