/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Chunk;
import com.pdfjet.Compressor;
import com.pdfjet.Decompressor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNGImage {
    int w;
    int h;
    byte[] data;
    byte[] inflated;
    byte[] image;
    byte[] deflated;
    byte[] rgb;
    byte[] alphaForPalette;
    byte[] deflatedAlpha;
    private byte bitDepth = (byte)8;
    private byte colorType = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PNGImage(InputStream inputStream) throws Exception {
        this.validatePNG(inputStream);
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        this.processPNG(arrayList, inputStream);
        for (int i = 0; i < arrayList.size(); ++i) {
            Chunk chunk = (Chunk)arrayList.get(i);
            if (chunk.type[0] == 73 && chunk.type[1] == 72 && chunk.type[2] == 68 && chunk.type[3] == 82) {
                this.w = this.toIntValue(chunk.getData(), 0);
                this.h = this.toIntValue(chunk.getData(), 4);
                this.bitDepth = chunk.getData()[8];
                this.colorType = chunk.getData()[9];
                continue;
            }
            if (chunk.type[0] == 73 && chunk.type[1] == 68 && chunk.type[2] == 65 && chunk.type[3] == 84) {
                this.data = this.appendIdatChunk(this.data, chunk.getData());
                continue;
            }
            if (chunk.type[0] == 80 && chunk.type[1] == 76 && chunk.type[2] == 84 && chunk.type[3] == 69) {
                this.rgb = chunk.getData();
                if (this.rgb.length % 3 == 0) continue;
                throw new Exception("Incorrect palette length.");
            }
            if (chunk.type[0] == 103 && chunk.type[1] == 65 && chunk.type[2] == 77 && chunk.type[3] == 65) continue;
            if (chunk.type[0] == 116 && chunk.type[1] == 82 && chunk.type[2] == 78 && chunk.type[3] == 83) {
                if (this.colorType != 3) continue;
                this.alphaForPalette = new byte[this.w * this.h];
                Arrays.fill(this.alphaForPalette, (byte)-1);
                byte[] byArray = chunk.getData();
                for (int j = 0; j < byArray.length; ++j) {
                    this.alphaForPalette[j] = byArray[j];
                }
                continue;
            }
            if (!(chunk.type[0] == 99 && chunk.type[1] == 72 && chunk.type[2] == 82 && chunk.type[3] == 77 || chunk.type[0] == 115 && chunk.type[1] == 66 && chunk.type[2] == 73 && chunk.type[3] == 84 || chunk.type[0] != 98 || chunk.type[1] != 75 || chunk.type[2] != 71) && chunk.type[3] != 68) continue;
        }
        this.inflated = this.getDecompressedData();
        if (this.colorType == 0) {
            if (this.bitDepth == 16) {
                this.image = this.getImageColorType0BitDepth16();
            } else if (this.bitDepth == 8) {
                this.image = this.getImageColorType0BitDepth8();
            } else if (this.bitDepth == 4) {
                this.image = this.getImageColorType0BitDepth4();
            } else if (this.bitDepth == 2) {
                this.image = this.getImageColorType0BitDepth2();
            } else {
                if (this.bitDepth != 1) throw new Exception("Image with unsupported bit depth == " + this.bitDepth);
                this.image = this.getImageColorType0BitDepth1();
            }
        } else if (this.colorType == 6) {
            this.image = this.getImageColorType6BitDepth8();
        } else if (this.rgb == null) {
            this.image = this.bitDepth == 16 ? this.getImageColorType2BitDepth16() : this.getImageColorType2BitDepth8();
        } else if (this.bitDepth == 8) {
            this.image = this.getImageColorType3BitDepth8();
        } else if (this.bitDepth == 4) {
            this.image = this.getImageColorType3BitDepth4();
        } else if (this.bitDepth == 2) {
            this.image = this.getImageColorType3BitDepth2();
        } else {
            if (this.bitDepth != 1) throw new Exception("Image with unsupported bit depth == " + this.bitDepth);
            this.image = this.getImageColorType3BitDepth1();
        }
        this.deflated = this.deflateReconstructedData();
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getColorType() {
        return this.colorType;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public byte[] getData() {
        return this.deflated;
    }

    public byte[] getAlpha() {
        return this.deflatedAlpha;
    }

    private void processPNG(List<Chunk> list, InputStream inputStream) throws Exception {
        Chunk chunk;
        do {
            chunk = this.getChunk(inputStream);
            list.add(chunk);
        } while (chunk.type[0] != 73 || chunk.type[1] != 69 || chunk.type[2] != 78 || chunk.type[3] != 68);
    }

    private void validatePNG(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[8];
        if (inputStream.read(byArray, 0, byArray.length) == -1) {
            throw new Exception("File is too short!");
        }
        if ((byArray[0] & 0xFF) != 137 || byArray[1] != 80 || byArray[2] != 78 || byArray[3] != 71 || byArray[4] != 13 || byArray[5] != 10 || byArray[6] != 26 || byArray[7] != 10) {
            throw new Exception("Wrong PNG signature.");
        }
    }

    private Chunk getChunk(InputStream inputStream) throws Exception {
        Chunk chunk = new Chunk();
        chunk.setLength(this.getLong(inputStream));
        chunk.setType(this.getBytes(inputStream, 4L));
        chunk.setData(this.getBytes(inputStream, chunk.getLength()));
        chunk.setCrc(this.getLong(inputStream));
        if (!chunk.hasGoodCRC()) {
            throw new Exception("Chunk has bad CRC.");
        }
        return chunk;
    }

    private long getLong(InputStream inputStream) throws Exception {
        byte[] byArray = this.getBytes(inputStream, 4L);
        return (long)this.toIntValue(byArray, 0) & 0xFFFFFFFFL;
    }

    private byte[] getBytes(InputStream inputStream, long l) throws Exception {
        byte[] byArray = new byte[(int)l];
        if (inputStream.read(byArray, 0, byArray.length) == -1) {
            throw new Exception("Error reading input stream!");
        }
        return byArray;
    }

    private int toIntValue(byte[] byArray, int n) {
        long l = 0L;
        l |= (long)byArray[n] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[1 + n] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[2 + n] & 0xFFL;
        l <<= 8;
        return (int)(l |= (long)byArray[3 + n] & 0xFFL);
    }

    private byte[] getImageColorType2BitDepth16() {
        int n = 0;
        byte[] byArray = new byte[this.inflated.length - this.h];
        byte by = 0;
        int n2 = 6 * this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (n2 + 1) == 0) {
                by = this.inflated[i];
                continue;
            }
            byArray[n] = this.inflated[i];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (n % n2 >= 6) {
                n3 = byArray[n - 6] & 0xFF;
            }
            if (n >= n2) {
                n4 = byArray[n - n2] & 0xFF;
            }
            if (n % n2 >= 6 && n >= n2) {
                n5 = byArray[n - (n2 + 6)] & 0xFF;
            }
            this.applyFilters(by, byArray, n, n3, n4, n5);
            ++n;
        }
        return byArray;
    }

    private byte[] getImageColorType2BitDepth8() {
        int n = 0;
        byte[] byArray = new byte[this.inflated.length - this.h];
        byte by = 0;
        int n2 = 3 * this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (n2 + 1) == 0) {
                by = this.inflated[i];
                continue;
            }
            byArray[n] = this.inflated[i];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (n % n2 >= 3) {
                n3 = byArray[n - 3] & 0xFF;
            }
            if (n >= n2) {
                n4 = byArray[n - n2] & 0xFF;
            }
            if (n % n2 >= 3 && n >= n2) {
                n5 = byArray[n - (n2 + 3)] & 0xFF;
            }
            this.applyFilters(by, byArray, n, n3, n4, n5);
            ++n;
        }
        return byArray;
    }

    private byte[] getImageColorType6BitDepth8() throws Exception {
        int n;
        int n2;
        int n3 = 0;
        byte[] byArray = new byte[4 * this.w * this.h];
        byte by = 0;
        int n4 = 4 * this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (n4 + 1) == 0) {
                by = this.inflated[i];
                continue;
            }
            byArray[n3] = this.inflated[i];
            int n5 = 0;
            n2 = 0;
            n = 0;
            if (n3 % n4 >= 4) {
                n5 = byArray[n3 - 4] & 0xFF;
            }
            if (n3 >= n4) {
                n2 = byArray[n3 - n4] & 0xFF;
            }
            if (n3 % n4 >= 4 && n3 >= n4) {
                n = byArray[n3 - (n4 + 4)] & 0xFF;
            }
            this.applyFilters(by, byArray, n3, n5, n2, n);
            ++n3;
        }
        byte[] byArray2 = new byte[3 * this.w * this.h];
        byte[] byArray3 = new byte[this.w * this.h];
        n2 = 0;
        n = 0;
        for (int i = 0; i < byArray.length; i += 4) {
            byArray2[n2] = byArray[i];
            byArray2[n2 + 1] = byArray[i + 1];
            byArray2[n2 + 2] = byArray[i + 2];
            byArray3[n] = byArray[i + 3];
            n2 += 3;
            ++n;
        }
        Compressor compressor = new Compressor(byArray3);
        this.deflatedAlpha = compressor.getCompressedData();
        return byArray2;
    }

    private byte[] getImageColorType3BitDepth8() {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        if (this.alphaForPalette != null) {
            byArray = new byte[this.w * this.h];
        }
        byte[] byArray2 = new byte[3 * (this.inflated.length - this.h)];
        int n3 = this.w + 1;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % n3 == 0) continue;
            int n4 = this.inflated[i] & 0xFF;
            byArray2[n++] = this.rgb[3 * n4];
            byArray2[n++] = this.rgb[3 * n4 + 1];
            byArray2[n++] = this.rgb[3 * n4 + 2];
            if (this.alphaForPalette == null) continue;
            byArray[n2++] = this.alphaForPalette[n4];
        }
        if (this.alphaForPalette != null) {
            Compressor compressor = new Compressor(byArray);
            this.deflatedAlpha = compressor.getCompressedData();
        }
        return byArray2;
    }

    private byte[] getImageColorType3BitDepth4() {
        int n = 0;
        byte[] byArray = new byte[6 * (this.inflated.length - this.h)];
        int n2 = this.w / 2 + 1;
        if (this.w % 2 > 0) {
            ++n2;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % n2 == 0) continue;
            byte by = this.inflated[i];
            int n3 = 3 * (by >> 4 & 0xF);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by & 0xF);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
        }
        return byArray;
    }

    private byte[] getImageColorType3BitDepth2() {
        int n = 0;
        byte[] byArray = new byte[12 * (this.inflated.length - this.h)];
        int n2 = this.w / 4 + 1;
        if (this.w % 4 > 0) {
            ++n2;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % n2 == 0) continue;
            byte by = this.inflated[i];
            int n3 = 3 * (by >> 6 & 3);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by >> 4 & 3);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by >> 2 & 3);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by & 3);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
        }
        return byArray;
    }

    private byte[] getImageColorType3BitDepth1() {
        int n = 0;
        byte[] byArray = new byte[24 * (this.inflated.length - this.h)];
        int n2 = this.w / 8 + 1;
        if (this.w % 8 > 0) {
            ++n2;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % n2 == 0) continue;
            byte by = this.inflated[i];
            int n3 = 3 * (by >> 7 & 1);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by >> 6 & 1);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by >> 5 & 1);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by >> 4 & 1);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by >> 3 & 1);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by >> 2 & 1);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by >> 1 & 1);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
            if (n % (3 * this.w) == 0) continue;
            n3 = 3 * (by & 1);
            byArray[n++] = this.rgb[n3];
            byArray[n++] = this.rgb[n3 + 1];
            byArray[n++] = this.rgb[n3 + 2];
        }
        return byArray;
    }

    private byte[] getImageColorType0BitDepth16() {
        int n = 0;
        byte[] byArray = new byte[this.inflated.length - this.h];
        byte by = 0;
        int n2 = 2 * this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (n2 + 1) == 0) {
                by = this.inflated[i];
                continue;
            }
            byArray[n] = this.inflated[i];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (n % n2 >= 2) {
                n3 = byArray[n - 2] & 0xFF;
            }
            if (n >= n2) {
                n4 = byArray[n - n2] & 0xFF;
            }
            if (n % n2 >= 2 && n >= n2) {
                n5 = byArray[n - (n2 + 2)] & 0xFF;
            }
            this.applyFilters(by, byArray, n, n3, n4, n5);
            ++n;
        }
        return byArray;
    }

    private byte[] getImageColorType0BitDepth8() {
        int n = 0;
        byte[] byArray = new byte[this.inflated.length - this.h];
        byte by = 0;
        int n2 = this.w;
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % (n2 + 1) == 0) {
                by = this.inflated[i];
                continue;
            }
            byArray[n] = this.inflated[i];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (n % n2 >= 1) {
                n3 = byArray[n - 1] & 0xFF;
            }
            if (n >= n2) {
                n4 = byArray[n - n2] & 0xFF;
            }
            if (n % n2 >= 1 && n >= n2) {
                n5 = byArray[n - (n2 + 1)] & 0xFF;
            }
            this.applyFilters(by, byArray, n, n3, n4, n5);
            ++n;
        }
        return byArray;
    }

    private byte[] getImageColorType0BitDepth4() {
        int n = 0;
        byte[] byArray = new byte[this.inflated.length - this.h];
        int n2 = this.w / 2 + 1;
        if (this.w % 2 > 0) {
            ++n2;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % n2 == 0) continue;
            byArray[n++] = this.inflated[i];
        }
        return byArray;
    }

    private byte[] getImageColorType0BitDepth2() {
        int n = 0;
        byte[] byArray = new byte[this.inflated.length - this.h];
        int n2 = this.w / 4 + 1;
        if (this.w % 4 > 0) {
            ++n2;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % n2 == 0) continue;
            byArray[n++] = this.inflated[i];
        }
        return byArray;
    }

    private byte[] getImageColorType0BitDepth1() {
        int n = 0;
        byte[] byArray = new byte[this.inflated.length - this.h];
        int n2 = this.w / 8 + 1;
        if (this.w % 8 > 0) {
            ++n2;
        }
        for (int i = 0; i < this.inflated.length; ++i) {
            if (i % n2 == 0) continue;
            byArray[n++] = this.inflated[i];
        }
        return byArray;
    }

    private void applyFilters(byte by, byte[] byArray, int n, int n2, int n3, int n4) {
        if (by != 0) {
            if (by == 1) {
                int n5 = n;
                byArray[n5] = (byte)(byArray[n5] + (byte)n2);
            } else if (by == 2) {
                int n6 = n;
                byArray[n6] = (byte)(byArray[n6] + (byte)n3);
            } else if (by == 3) {
                int n7 = n;
                byArray[n7] = (byte)(byArray[n7] + (byte)Math.floor((double)(n2 + n3) / 2.0));
            } else if (by == 4) {
                int n8 = n2 + n3 - n4;
                int n9 = Math.abs(n8 - n2);
                int n10 = Math.abs(n8 - n3);
                int n11 = Math.abs(n8 - n4);
                int n12 = n9 <= n10 && n9 <= n11 ? n2 : (n10 <= n11 ? n3 : n4);
                int n13 = n;
                byArray[n13] = (byte)(byArray[n13] + (byte)(n12 & 0xFF));
            }
        }
    }

    private byte[] getDecompressedData() throws Exception {
        Decompressor decompressor = new Decompressor(this.data);
        return decompressor.getDecompressedData();
    }

    private byte[] deflateReconstructedData() throws Exception {
        Compressor compressor = new Compressor(this.image);
        return compressor.getCompressedData();
    }

    private byte[] appendIdatChunk(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }
}

