/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Drawable;
import com.pdfjet.Page;
import java.util.ArrayList;
import java.util.List;

public class OptionalContentGroup {
    protected String name;
    protected int ocgNumber;
    protected int objNumber;
    protected boolean visible;
    protected boolean printable;
    protected boolean exportable;
    private List<Drawable> components;

    public OptionalContentGroup(String string) {
        this.name = string;
        this.components = new ArrayList<Drawable>();
    }

    public void add(Drawable drawable) {
        this.components.add(drawable);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setPrintable(boolean bl) {
        this.printable = bl;
    }

    public void setExportable(boolean bl) {
        this.exportable = bl;
    }

    public void drawOn(Page page) throws Exception {
        if (!this.components.isEmpty()) {
            page.pdf.groups.add(this);
            this.ocgNumber = page.pdf.groups.size();
            page.pdf.newobj();
            page.pdf.append("<<\n");
            page.pdf.append("/Type /OCG\n");
            page.pdf.append("/Name (" + this.name + ")\n");
            page.pdf.append(">>\n");
            page.pdf.endobj();
            this.objNumber = page.pdf.objNumber;
            page.append("/OC /OC");
            page.append(this.ocgNumber);
            page.append(" BDC\n");
            for (Drawable drawable : this.components) {
                drawable.drawOn(page);
            }
            page.append("\nEMC\n");
        }
    }
}

