/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.FontTable;
import com.pdfjet.Lookup;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class OTF {
    protected String fontName;
    protected boolean cff = false;
    protected ByteArrayOutputStream baos;
    protected byte[] buf;
    protected int unitsPerEm;
    protected short bBoxLLx;
    protected short bBoxLLy;
    protected short bBoxURx;
    protected short bBoxURy;
    protected short ascent;
    protected short descent;
    protected int[] advanceWidth;
    protected int firstChar;
    protected int lastChar;
    protected int capHeight;
    protected int[] glyphWidth;
    protected long postVersion;
    protected long italicAngle;
    protected short underlinePosition;
    protected short underlineThickness;
    private InputStream stream;
    private DeflaterOutputStream dos;
    private int cff_off;
    private int cff_len;
    private int index = 0;
    protected int[] unicodeToGID = new int[65536];
    protected int[] halfForm = new int[576];

    public OTF(InputStream inputStream) throws Exception {
        int n;
        this.stream = inputStream;
        this.baos = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            this.baos.write(byArray, 0, n);
        }
        inputStream.close();
        this.buf = this.baos.toByteArray();
        this.baos = new ByteArrayOutputStream();
        this.dos = new DeflaterOutputStream((OutputStream)this.baos, new Deflater(1));
        long l = this.readUInt32();
        if (l != 65536L && l != 1953658213L && l != 0x4F54544FL) {
            throw new Exception("OTF version == " + l + " is not supported.");
        }
        int n2 = this.readUInt16();
        int n3 = this.readUInt16();
        int n4 = this.readUInt16();
        int n5 = this.readUInt16();
        FontTable fontTable = null;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = new byte[4];
            for (int j = 0; j < 4; ++j) {
                byArray2[j] = this.readByte();
            }
            FontTable fontTable2 = new FontTable();
            fontTable2.name = new String(byArray2);
            fontTable2.checkSum = this.readUInt32();
            fontTable2.offset = (int)this.readUInt32();
            fontTable2.length = (int)this.readUInt32();
            int n6 = this.index;
            if (fontTable2.name.equals("head")) {
                this.head(fontTable2);
            } else if (fontTable2.name.equals("hhea")) {
                this.hhea(fontTable2);
            } else if (fontTable2.name.equals("OS/2")) {
                this.OS_2(fontTable2);
            } else if (fontTable2.name.equals("name")) {
                this.name(fontTable2);
            } else if (fontTable2.name.equals("hmtx")) {
                this.hmtx(fontTable2);
            } else if (fontTable2.name.equals("post")) {
                this.post(fontTable2);
            } else if (fontTable2.name.equals("CFF ")) {
                this.CFF_(fontTable2);
            } else if (fontTable2.name.equals("GSUB")) {
                this.GSUB(fontTable2);
            } else if (fontTable2.name.equals("cmap")) {
                fontTable = fontTable2;
            }
            this.index = n6;
        }
        this.cmap(fontTable);
        if (this.cff) {
            this.dos.write(this.buf, this.cff_off, this.cff_len);
        } else {
            this.dos.write(this.buf, 0, this.buf.length);
        }
        this.dos.finish();
    }

    private void head(FontTable fontTable) throws IOException {
        this.index = fontTable.offset + 16;
        int n = this.readUInt16();
        this.unitsPerEm = this.readUInt16();
        this.index += 16;
        this.bBoxLLx = (short)this.readUInt16();
        this.bBoxLLy = (short)this.readUInt16();
        this.bBoxURx = (short)this.readUInt16();
        this.bBoxURy = (short)this.readUInt16();
    }

    private void hhea(FontTable fontTable) throws IOException {
        this.index = fontTable.offset + 4;
        this.ascent = (short)this.readUInt16();
        this.descent = (short)this.readUInt16();
        this.index += 26;
        this.advanceWidth = new int[this.readUInt16()];
    }

    private void OS_2(FontTable fontTable) throws IOException {
        this.index = fontTable.offset + 64;
        this.firstChar = this.readUInt16();
        this.lastChar = this.readUInt16();
        this.index += 20;
        this.capHeight = (short)this.readUInt16();
    }

    private void name(FontTable fontTable) throws IOException {
        int n = this.index = fontTable.offset;
        int n2 = this.readUInt16();
        int n3 = this.readUInt16();
        int n4 = this.readUInt16();
        for (int i = 0; i < n3; ++i) {
            int n5 = this.readUInt16();
            int n6 = this.readUInt16();
            int n7 = this.readUInt16();
            int n8 = this.readUInt16();
            int n9 = this.readUInt16();
            int n10 = this.readUInt16();
            int n11 = n + n4 + n10;
            if (n5 == 1) {
                if (n6 != 0 || n7 != 0 || n8 != 6) continue;
                this.index = n11;
                byte[] byArray = new byte[n9];
                for (int j = 0; j < n9; ++j) {
                    byArray[j] = this.readByte();
                }
                this.fontName = new String(byArray);
                break;
            }
            if (n5 != 3 || n6 != 1 || n7 != 1033 || n8 != 6) continue;
            this.index = n11;
            int n12 = n9 / 2;
            byte[] byArray = new byte[n12];
            for (int j = 0; j < n12; ++j) {
                byte by;
                byte by2 = this.readByte();
                byArray[j] = by = this.readByte();
            }
            this.fontName = new String(byArray);
            break;
        }
    }

    private void cmap(FontTable fontTable) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.index = fontTable.offset;
        this.index += 2;
        int n6 = this.readUInt16();
        boolean bl = false;
        int n7 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = this.readUInt16();
            n2 = this.readUInt16();
            n7 = (int)this.readUInt32();
            if (n3 != 3 || n2 != 1) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new Exception("Format 4 subtable not found in this font.");
        }
        this.index = n5 + n7;
        n4 = this.readUInt16();
        n3 = this.readUInt16();
        n2 = this.readUInt16();
        int n8 = this.readUInt16() / 2;
        this.index += 6;
        int[] nArray = new int[n8];
        for (int i = 0; i < n8; ++i) {
            nArray[i] = this.readUInt16();
        }
        this.index += 2;
        int[] nArray2 = new int[n8];
        for (int i = 0; i < n8; ++i) {
            nArray2[i] = this.readUInt16();
        }
        short[] sArray = new short[n8];
        for (int i = 0; i < n8; ++i) {
            sArray[i] = (short)this.readUInt16();
        }
        int[] nArray3 = new int[n8];
        for (int i = 0; i < n8; ++i) {
            nArray3[i] = this.readUInt16();
        }
        int[] nArray4 = new int[(n3 - (16 + 8 * n8)) / 2];
        for (n = 0; n < nArray4.length; ++n) {
            nArray4[n] = this.readUInt16();
        }
        this.glyphWidth = new int[this.lastChar + 1];
        Arrays.fill(this.glyphWidth, this.advanceWidth[0]);
        for (n = this.firstChar; n <= this.lastChar; ++n) {
            int n9;
            int n10 = this.getSegmentFor(n, nArray2, nArray, n8);
            if (n10 == -1) continue;
            int n11 = nArray3[n10];
            if (n11 == 0) {
                n9 = (sArray[n10] + n) % 65536;
            } else {
                n11 /= 2;
                n9 = nArray4[(n11 -= n8 - n10) + (n - nArray2[n10])];
                if (n9 != 0) {
                    n9 += sArray[n10] % 65536;
                }
            }
            if (n9 < this.advanceWidth.length) {
                this.glyphWidth[n] = this.advanceWidth[n9];
            }
            this.unicodeToGID[n] = n9;
        }
    }

    private void hmtx(FontTable fontTable) throws IOException {
        this.index = fontTable.offset;
        for (int i = 0; i < this.advanceWidth.length; ++i) {
            this.advanceWidth[i] = this.readUInt16();
            this.index += 2;
        }
    }

    private void post(FontTable fontTable) throws IOException {
        this.index = fontTable.offset;
        this.postVersion = this.readUInt32();
        this.italicAngle = this.readUInt32();
        this.underlinePosition = (short)this.readUInt16();
        this.underlineThickness = (short)this.readUInt16();
    }

    private void CFF_(FontTable fontTable) throws IOException {
        this.cff = true;
        this.cff_off = fontTable.offset;
        this.cff_len = fontTable.length;
    }

    private void GSUB(FontTable fontTable) throws IOException {
        int n;
        int n2;
        int n3 = this.index = fontTable.offset;
        long l = this.readUInt32();
        int n4 = this.readUInt16();
        int n5 = this.readUInt16();
        int n6 = this.readUInt16();
        this.index = n3 + n4;
        int n7 = this.readUInt16();
        for (n2 = 0; n2 < n7; ++n2) {
            int n8;
            byte[] byArray = new byte[4];
            for (n8 = 0; n8 < 4; ++n8) {
                byArray[n8] = this.readByte();
            }
            n8 = this.readUInt16();
        }
        this.index = n3 + n5;
        n2 = this.readUInt16();
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = new byte[4];
            for (n = 0; n < 4; ++n) {
                byArray[n] = this.readByte();
            }
            n = this.readUInt16();
        }
        this.index = n3 + n6;
        int[] nArray = new int[this.readUInt16()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n3 + n6 + this.readUInt16();
        }
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        for (n = 0; n < nArray.length; ++n) {
            this.index = nArray[n];
            Lookup lookup = new Lookup();
            lookup.lookupType = this.readUInt16();
            lookup.lookupFlag = this.readUInt16();
            lookup.subTableCount = this.readUInt16();
            lookup.subTable = new int[lookup.subTableCount];
            for (int i = 0; i < lookup.subTableCount; ++i) {
                lookup.subTable[i] = nArray[n] + this.readUInt16();
            }
            arrayList.add(lookup);
        }
        for (Lookup lookup : arrayList) {
            int[] nArray2 = lookup.subTable;
            int n9 = nArray2.length;
            for (int i = 0; i < n9; ++i) {
                int n10;
                int n11;
                this.index = n11 = nArray2[i];
                int n12 = this.readUInt16();
                if (n12 == 1) {
                    n10 = this.readUInt16();
                    for (int j = 0; j < n10; ++j) {
                    }
                    continue;
                }
                if (n12 != 2) continue;
                n10 = this.readUInt16();
            }
        }
    }

    private int getSegmentFor(int n, int[] nArray, int[] nArray2, int n2) {
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            if (n > nArray2[i] || n < nArray[i]) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private byte readByte() {
        return this.buf[this.index++];
    }

    private int readUInt16() {
        int n = 0;
        n |= this.buf[this.index++] << 8 & 0xFF00;
        return n |= this.buf[this.index++] & 0xFF;
    }

    private long readUInt32() {
        long l = 0L;
        l |= (long)(this.buf[this.index++] << 24) & 0xFF000000L;
        l |= (long)(this.buf[this.index++] << 16) & 0xFF0000L;
        l |= (long)(this.buf[this.index++] << 8) & 0xFF00L;
        return l |= (long)this.buf[this.index++] & 0xFFL;
    }

    private void setHalfForm(char c, char c2, int n) {
        this.halfForm[16 * (c - 2325) + (c2 - 2366)] = n;
    }
}

