/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

class JPGImage {
    static final char M_SOF0 = '\u00c0';
    static final char M_SOF1 = '\u00c1';
    static final char M_SOF2 = '\u00c2';
    static final char M_SOF3 = '\u00c3';
    static final char M_SOF5 = '\u00c5';
    static final char M_SOF6 = '\u00c6';
    static final char M_SOF7 = '\u00c7';
    static final char M_SOF9 = '\u00c9';
    static final char M_SOF10 = '\u00ca';
    static final char M_SOF11 = '\u00cb';
    static final char M_SOF13 = '\u00cd';
    static final char M_SOF14 = '\u00ce';
    static final char M_SOF15 = '\u00cf';
    int width;
    int height;
    long size;
    int colorComponents;
    byte[] data;
    private InputStream stream;

    public JPGImage(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.data = byteArrayOutputStream.toByteArray();
        this.readJPGImage(new ByteArrayInputStream(this.data));
    }

    protected InputStream getInputStream() {
        return this.stream;
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    protected long getFileSize() {
        return this.size;
    }

    protected int getColorComponents() {
        return this.colorComponents;
    }

    protected byte[] getData() {
        return this.data;
    }

    private void readJPGImage(InputStream inputStream) throws Exception {
        char c = (char)inputStream.read();
        char c2 = (char)inputStream.read();
        this.size += 2L;
        if (c == '\u00ff' && c2 == '\u00d8') {
            boolean bl = false;
            do {
                char c3 = this.nextMarker(inputStream);
                switch (c3) {
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c5': 
                    case '\u00c6': 
                    case '\u00c7': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': {
                        inputStream.read();
                        inputStream.read();
                        inputStream.read();
                        this.size += 3L;
                        this.height = this.readTwoBytes(inputStream);
                        this.width = this.readTwoBytes(inputStream);
                        this.colorComponents = inputStream.read();
                        ++this.size;
                        bl = true;
                        break;
                    }
                    default: {
                        this.skipVariable(inputStream);
                    }
                }
            } while (!bl);
            while (inputStream.read() != -1) {
                ++this.size;
            }
        } else {
            throw new Exception();
        }
    }

    private int readTwoBytes(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        n <<= 8;
        this.size += 2L;
        return n |= inputStream.read();
    }

    private char nextMarker(InputStream inputStream) throws Exception {
        int n = 0;
        char c = ' ';
        c = (char)inputStream.read();
        ++this.size;
        while (c != '\u00ff') {
            ++n;
            c = (char)inputStream.read();
            ++this.size;
        }
        do {
            c = (char)inputStream.read();
            ++this.size;
        } while (c == 255);
        if (n != 0) {
            throw new Exception();
        }
        return c;
    }

    private void skipVariable(InputStream inputStream) throws Exception {
        int n = this.readTwoBytes(inputStream);
        if (n < 2) {
            throw new Exception();
        }
        n -= 2;
        while (n > 0) {
            inputStream.read();
            ++this.size;
            --n;
        }
    }
}

