/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Box;
import com.pdfjet.Field;
import com.pdfjet.Font;
import com.pdfjet.Line;
import com.pdfjet.Page;
import com.pdfjet.TextLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form {
    private List<Field> fields;
    private float x;
    private float y;
    private Font f1;
    private float labelFontSize = 8.0f;
    private Font f2;
    private float valueFontSize = 10.0f;
    private int numberOfRows;
    private float rowLength = 500.0f;
    private float rowHeight = 12.0f;
    private int labelColor = 0;
    private int valueColor = 255;
    private List<float[]> endOfLinePoints;

    public Form(List<Field> list) {
        this.fields = list;
        this.endOfLinePoints = new ArrayList<float[]>();
        for (Field field : list) {
            if (field.x != 0.0f) continue;
            this.numberOfRows += field.values.length;
        }
    }

    public Form setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Form setRowLength(float f) {
        this.rowLength = f;
        return this;
    }

    public Form setRowHeight(float f) {
        this.rowHeight = f;
        return this;
    }

    public Form setLabelFont(Font font) {
        this.f1 = font;
        return this;
    }

    public Form setLabelFontSize(float f) {
        this.labelFontSize = f;
        return this;
    }

    public Form setValueFont(Font font) {
        this.f2 = font;
        return this;
    }

    public Form setValueFontSize(float f) {
        this.valueFontSize = f;
        return this;
    }

    public Form setLabelColor(int n) {
        this.labelColor = n;
        return this;
    }

    public Form setValueColor(int n) {
        this.valueColor = n;
        return this;
    }

    public List<float[]> getEndOfLinePoints() {
        return this.endOfLinePoints;
    }

    public float[] drawOn(Page page) throws Exception {
        if (this.numberOfRows == 0) {
            return new float[]{this.x, this.y};
        }
        float f = this.rowHeight * (float)this.numberOfRows;
        Box box = new Box();
        box.setLocation(this.x, this.y);
        box.setSize(this.rowLength, f);
        box.drawOn(page);
        float f2 = 0.0f;
        int n = 1;
        float f3 = 0.0f;
        for (Field field : this.fields) {
            if (field.x == 0.0f) {
                f3 += (float)n * this.rowHeight;
                n = field.values.length;
            }
            f2 = f3;
            for (int i = 0; i < field.values.length; ++i) {
                Font font = i == 0 ? this.f1 : this.f2;
                float f4 = i == 0 ? this.labelFontSize : this.valueFontSize;
                int n2 = i == 0 ? this.labelColor : this.valueColor;
                new TextLine(font, field.values[i]).setFontSize(f4).setColor(n2).placeIn(box, field.x + this.f1.getDescent(), f2 - font.getDescent()).setAltDescription(i == 0 ? field.altDescription[i] : field.altDescription[i] + ",").setActualText(i == 0 ? field.actualText[i] : field.actualText[i] + ",").drawOn(page);
                this.endOfLinePoints.add(new float[]{field.x + this.f1.getDescent() + font.stringWidth(field.values[i]), f2 - font.getDescent()});
                if (i == field.values.length - 1) {
                    new Line(0.0f, 0.0f, this.rowLength, 0.0f).placeIn(box, 0.0f, f2).drawOn(page);
                    if (field.x != 0.0f) {
                        new Line(0.0f, (float)(-(field.values.length - 1)) * this.rowHeight, 0.0f, 0.0f).placeIn(box, field.x, f2).drawOn(page);
                    }
                }
                f2 += this.rowHeight;
            }
        }
        return new float[]{this.x + this.rowLength, this.y + f};
    }
}

