/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.CP1250;
import com.pdfjet.CP1251;
import com.pdfjet.CP1252;
import com.pdfjet.CP1253;
import com.pdfjet.CP1254;
import com.pdfjet.CP1257;
import com.pdfjet.CoreFont;
import com.pdfjet.FastFont;
import com.pdfjet.OpenTypeFont;
import com.pdfjet.PDF;
import com.pdfjet.StandardFont;
import java.io.InputStream;

public class Font {
    protected String name;
    protected int objNumber;
    protected int fileObjNumber = -1;
    protected int unitsPerEm = 1000;
    protected float size = 12.0f;
    protected float ascent;
    protected float descent;
    protected float capHeight;
    protected float body_height;
    protected int[][] metrics = null;
    protected boolean isStandard = true;
    protected boolean kernPairs = false;
    protected boolean isComposite = false;
    protected int firstChar = 32;
    protected int lastChar = 255;
    protected boolean skew15 = false;
    protected boolean isCJK = false;
    public boolean isDevanagari = false;
    protected float bBoxLLx;
    protected float bBoxLLy;
    protected float bBoxURx;
    protected float bBoxURy;
    protected float underlinePosition;
    protected float underlineThickness;
    protected int compressed_size;
    protected int uncompressed_size;
    protected int[] advanceWidth = null;
    protected int[] glyphWidth = null;
    protected int[] unicodeToGID;
    protected int[] halfForm;
    protected String fontID;
    private int fontDescriptorObjNumber = -1;
    private int cMapObjNumber = -1;
    private int cidFontDictObjNumber = -1;
    private int toUnicodeCMapObjNumber = -1;
    private int widthsArrayObjNumber = -1;
    private int encodingObjNumber = -1;
    private int codePage = 2;
    private int fontUnderlinePosition = 0;
    private int fontUnderlineThickness = 0;

    public Font(PDF pDF, CoreFont coreFont) throws Exception {
        StandardFont standardFont = StandardFont.getInstance(coreFont);
        this.name = standardFont.name;
        this.bBoxLLx = standardFont.bBoxLLx;
        this.bBoxLLy = standardFont.bBoxLLy;
        this.bBoxURx = standardFont.bBoxURx;
        this.bBoxURy = standardFont.bBoxURy;
        this.metrics = standardFont.metrics;
        this.ascent = this.bBoxURy * this.size / (float)this.unitsPerEm;
        this.descent = this.bBoxLLy * this.size / (float)this.unitsPerEm;
        this.body_height = this.ascent - this.descent;
        this.fontUnderlinePosition = standardFont.underlinePosition;
        this.fontUnderlineThickness = standardFont.underlineThickness;
        this.underlineThickness = (float)this.fontUnderlineThickness * this.size / (float)this.unitsPerEm;
        this.underlinePosition = (float)this.fontUnderlinePosition * this.size / (float)(-this.unitsPerEm) + this.underlineThickness / 2.0f;
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Font\n");
        pDF.append("/Subtype /Type1\n");
        pDF.append("/BaseFont /");
        pDF.append(this.name);
        pDF.append('\n');
        if (!this.name.equals("Symbol") && !this.name.equals("ZapfDingbats")) {
            pDF.append("/Encoding /WinAnsiEncoding\n");
        }
        pDF.append(">>\n");
        pDF.endobj();
        this.objNumber = pDF.objNumber;
        pDF.fonts.add(this);
    }

    protected Font(CoreFont coreFont) {
        StandardFont standardFont = StandardFont.getInstance(coreFont);
        this.name = standardFont.name;
        this.bBoxLLx = standardFont.bBoxLLx;
        this.bBoxLLy = standardFont.bBoxLLy;
        this.bBoxURx = standardFont.bBoxURx;
        this.bBoxURy = standardFont.bBoxURy;
        this.metrics = standardFont.metrics;
        this.ascent = this.bBoxURy * this.size / (float)this.unitsPerEm;
        this.descent = this.bBoxLLy * this.size / (float)this.unitsPerEm;
        this.body_height = this.ascent - this.descent;
        this.fontUnderlinePosition = standardFont.underlinePosition;
        this.fontUnderlineThickness = standardFont.underlineThickness;
        this.underlineThickness = (float)this.fontUnderlineThickness * this.size / (float)this.unitsPerEm;
        this.underlinePosition = (float)this.fontUnderlinePosition * this.size / (float)(-this.unitsPerEm) + this.underlineThickness / 2.0f;
    }

    public Font(PDF pDF, String string, int n) throws Exception {
        this.name = string;
        this.codePage = n;
        this.isCJK = true;
        this.isStandard = false;
        this.isComposite = true;
        this.firstChar = 32;
        this.lastChar = 65518;
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /FontDescriptor\n");
        pDF.append("/FontName /");
        pDF.append(string);
        pDF.append('\n');
        pDF.append("/Flags 4\n");
        pDF.append("/FontBBox [0 0 0 0]\n");
        pDF.append(">>\n");
        pDF.endobj();
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Font\n");
        pDF.append("/Subtype /CIDFontType0\n");
        pDF.append("/BaseFont /");
        pDF.append(string);
        pDF.append('\n');
        pDF.append("/FontDescriptor ");
        pDF.append(pDF.objNumber - 1);
        pDF.append(" 0 R\n");
        pDF.append("/CIDSystemInfo <<\n");
        pDF.append("/Registry (Adobe)\n");
        if (string.startsWith("AdobeMingStd")) {
            pDF.append("/Ordering (CNS1)\n");
            pDF.append("/Supplement 4\n");
        } else if (string.startsWith("AdobeSongStd") || string.startsWith("STHeitiSC")) {
            pDF.append("/Ordering (GB1)\n");
            pDF.append("/Supplement 4\n");
        } else if (string.startsWith("KozMinPro")) {
            pDF.append("/Ordering (Japan1)\n");
            pDF.append("/Supplement 4\n");
        } else if (string.startsWith("AdobeMyungjoStd")) {
            pDF.append("/Ordering (Korea1)\n");
            pDF.append("/Supplement 1\n");
        } else {
            throw new Exception("Unsupported font: " + string);
        }
        pDF.append(">>\n");
        pDF.append(">>\n");
        pDF.endobj();
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Font\n");
        pDF.append("/Subtype /Type0\n");
        pDF.append("/BaseFont /");
        if (string.startsWith("AdobeMingStd")) {
            pDF.append(string + "-UniCNS-UTF16-H\n");
            pDF.append("/Encoding /UniCNS-UTF16-H\n");
        } else if (string.startsWith("AdobeSongStd") || string.startsWith("STHeitiSC")) {
            pDF.append(string + "-UniGB-UTF16-H\n");
            pDF.append("/Encoding /UniGB-UTF16-H\n");
        } else if (string.startsWith("KozMinPro")) {
            pDF.append(string + "-UniJIS-UCS2-H\n");
            pDF.append("/Encoding /UniJIS-UCS2-H\n");
        } else if (string.startsWith("AdobeMyungjoStd")) {
            pDF.append(string + "-UniKS-UCS2-H\n");
            pDF.append("/Encoding /UniKS-UCS2-H\n");
        } else {
            throw new Exception("Unsupported font: " + string);
        }
        pDF.append("/DescendantFonts [");
        pDF.append(pDF.objNumber - 1);
        pDF.append(" 0 R]\n");
        pDF.append(">>\n");
        pDF.endobj();
        this.objNumber = pDF.objNumber;
        this.ascent = this.size;
        this.descent = -this.ascent / 4.0f;
        this.body_height = this.ascent - this.descent;
        pDF.fonts.add(this);
    }

    public Font(PDF pDF, InputStream inputStream) throws Exception {
        this.isStandard = false;
        this.isComposite = true;
        this.codePage = -1;
        FastFont.register(pDF, this, inputStream);
        this.ascent = this.bBoxURy * this.size / (float)this.unitsPerEm;
        this.descent = this.bBoxLLy * this.size / (float)this.unitsPerEm;
        this.body_height = this.ascent - this.descent;
        this.underlineThickness = (float)this.fontUnderlineThickness * this.size / (float)this.unitsPerEm;
        this.underlinePosition = (float)this.fontUnderlinePosition * this.size / (float)(-this.unitsPerEm) + this.underlineThickness / 2.0f;
        pDF.fonts.add(this);
    }

    public Font(PDF pDF, InputStream inputStream, int n, boolean bl) throws Exception {
        this.isStandard = false;
        this.codePage = n;
        OpenTypeFont openTypeFont = new OpenTypeFont();
        if (n == -1) {
            openTypeFont.registerAsComposite(pDF, this, inputStream, bl);
            this.isComposite = true;
            this.firstChar = openTypeFont.otf.firstChar;
            this.lastChar = openTypeFont.otf.lastChar;
        } else {
            openTypeFont.registerAsSimple(pDF, this, inputStream, n, bl);
        }
        this.name = openTypeFont.otf.fontName;
        this.unicodeToGID = openTypeFont.otf.unicodeToGID;
        this.halfForm = openTypeFont.otf.halfForm;
        this.unitsPerEm = openTypeFont.otf.unitsPerEm;
        this.bBoxLLx = openTypeFont.otf.bBoxLLx;
        this.bBoxLLy = openTypeFont.otf.bBoxLLy;
        this.bBoxURx = openTypeFont.otf.bBoxURx;
        this.bBoxURy = openTypeFont.otf.bBoxURy;
        this.advanceWidth = openTypeFont.otf.advanceWidth;
        this.glyphWidth = openTypeFont.otf.glyphWidth;
        this.ascent = this.bBoxURy * this.size / (float)this.unitsPerEm;
        this.descent = this.bBoxLLy * this.size / (float)this.unitsPerEm;
        this.body_height = this.ascent - this.descent;
        this.fontUnderlineThickness = openTypeFont.otf.underlineThickness;
        this.fontUnderlinePosition = openTypeFont.otf.underlinePosition;
        this.underlineThickness = (float)this.fontUnderlineThickness * this.size / (float)this.unitsPerEm;
        this.underlinePosition = (float)this.fontUnderlinePosition * this.size / (float)(-this.unitsPerEm) + this.underlineThickness / 2.0f;
        pDF.fonts.add(this);
        inputStream.close();
    }

    protected int getFontDescriptorObjNumber() {
        return this.fontDescriptorObjNumber;
    }

    protected int getCMapObjNumber() {
        return this.cMapObjNumber;
    }

    protected int getCidFontDictObjNumber() {
        return this.cidFontDictObjNumber;
    }

    protected int getToUnicodeCMapObjNumber() {
        return this.toUnicodeCMapObjNumber;
    }

    protected int getWidthsArrayObjNumber() {
        return this.widthsArrayObjNumber;
    }

    protected int getEncodingObjNumber() {
        return this.encodingObjNumber;
    }

    protected float getUnderlinePosition() {
        return this.underlinePosition;
    }

    protected float getUnderlineThickness() {
        return this.underlineThickness;
    }

    protected void setFontDescriptorObjNumber(int n) {
        this.fontDescriptorObjNumber = n;
    }

    protected void setCMapObjNumber(int n) {
        this.cMapObjNumber = n;
    }

    protected void setCidFontDictObjNumber(int n) {
        this.cidFontDictObjNumber = n;
    }

    protected void setToUnicodeCMapObjNumber(int n) {
        this.toUnicodeCMapObjNumber = n;
    }

    protected void setWidthsArrayObjNumber(int n) {
        this.widthsArrayObjNumber = n;
    }

    protected void setEncodingObjNumber(int n) {
        this.encodingObjNumber = n;
    }

    public void setSize(double d) {
        this.setSize((float)d);
    }

    public void setSize(float f) {
        this.size = f;
        if (this.isCJK) {
            this.ascent = this.size;
            this.descent = -this.ascent / 4.0f;
            return;
        }
        this.ascent = this.bBoxURy * this.size / (float)this.unitsPerEm;
        this.descent = this.bBoxLLy * this.size / (float)this.unitsPerEm;
        this.body_height = this.ascent - this.descent;
        this.underlineThickness = (float)this.fontUnderlineThickness * this.size / (float)this.unitsPerEm;
        this.underlinePosition = (float)this.fontUnderlinePosition * this.size / (float)(-this.unitsPerEm) + this.underlineThickness / 2.0f;
    }

    public float getSize() {
        return this.size;
    }

    public void setKernPairs(boolean bl) {
        this.kernPairs = bl;
    }

    public float stringWidth(String string) {
        if (string == null) {
            return 0.0f;
        }
        if (this.isCJK) {
            return (float)string.length() * this.ascent;
        }
        int n = 0;
        block0: for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (this.isStandard) {
                if (n2 < this.firstChar || n2 > this.lastChar) {
                    n2 = this.mapUnicodeChar(n2);
                }
                n += this.metrics[n2 -= 32][1];
                if (!this.kernPairs || i >= string.length() - 1) continue;
                int n3 = string.charAt(i + 1);
                if (n3 < this.firstChar || n3 > this.lastChar) {
                    n3 = 32;
                }
                for (int j = 2; j < this.metrics[n2].length; j += 2) {
                    if (this.metrics[n2][j] != n3) continue;
                    n += this.metrics[n2][j + 1];
                    continue block0;
                }
                continue;
            }
            if (n2 < this.firstChar || n2 > this.lastChar) {
                n += this.advanceWidth[0];
                continue;
            }
            n += this.nonStandardFontGlyphWidth(n2);
        }
        return (float)n * this.size / (float)this.unitsPerEm;
    }

    private int nonStandardFontGlyphWidth(int n) {
        int n2 = 0;
        if (this.isComposite) {
            n2 = this.glyphWidth[n];
        } else if (n < 127) {
            n2 = this.glyphWidth[n];
        } else if (this.codePage == 0) {
            n2 = this.glyphWidth[CP1250.codes[n - 127]];
        } else if (this.codePage == 1) {
            n2 = this.glyphWidth[CP1251.codes[n - 127]];
        } else if (this.codePage == 2) {
            n2 = this.glyphWidth[CP1252.codes[n - 127]];
        } else if (this.codePage == 3) {
            n2 = this.glyphWidth[CP1253.codes[n - 127]];
        } else if (this.codePage == 4) {
            n2 = this.glyphWidth[CP1254.codes[n - 127]];
        } else if (this.codePage == 7) {
            n2 = this.glyphWidth[CP1257.codes[n - 127]];
        }
        return n2;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getDescent() {
        return -this.descent;
    }

    public float getHeight() {
        return this.ascent - this.descent;
    }

    public float getBodyHeight() {
        return this.body_height;
    }

    public int getFitChars(String string, double d) {
        return this.getFitChars(string, (float)d);
    }

    public int getFitChars(String string, float f) {
        int n;
        float f2 = f * (float)this.unitsPerEm / this.size;
        if (this.isCJK) {
            return (int)(f2 / this.ascent);
        }
        if (this.isStandard) {
            return this.getStandardFontFitChars(string, f2);
        }
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            f2 = c < this.firstChar || c > this.lastChar ? (f2 -= (float)this.advanceWidth[0]) : (f2 -= (float)this.nonStandardFontGlyphWidth(c));
            if (f2 < 0.0f) break;
        }
        return n;
    }

    private int getStandardFontFitChars(String string, float f) {
        int n;
        float f2 = f;
        block0: for (n = 0; n < string.length(); ++n) {
            int n2 = string.charAt(n);
            if (n2 < this.firstChar || n2 > this.lastChar) {
                n2 = 32;
            }
            if ((f2 -= (float)this.metrics[n2 -= 32][1]) < 0.0f) {
                return n;
            }
            if (!this.kernPairs || n >= string.length() - 1) continue;
            int n3 = string.charAt(n + 1);
            if (n3 < this.firstChar || n3 > this.lastChar) {
                n3 = 32;
            }
            for (int i = 2; i < this.metrics[n2].length; i += 2) {
                if (this.metrics[n2][i] != n3) continue;
                if (!((f2 -= (float)this.metrics[n2][i + 1]) < 0.0f)) continue block0;
                return n;
            }
        }
        return n;
    }

    protected int mapUnicodeChar(int n) {
        int[] nArray = null;
        if (this.codePage == 0) {
            nArray = CP1250.codes;
        } else if (this.codePage == 1) {
            nArray = CP1251.codes;
        } else if (this.codePage == 2) {
            nArray = CP1252.codes;
        } else if (this.codePage == 3) {
            nArray = CP1253.codes;
        } else if (this.codePage == 4) {
            nArray = CP1254.codes;
        } else if (this.codePage == 7) {
            nArray = CP1257.codes;
        }
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return 127 + i;
            }
        }
        return 32;
    }

    public void setItalic(boolean bl) {
        this.skew15 = bl;
    }

    public float stringWidth(Font font, String string) {
        if (font == null) {
            return this.stringWidth(string);
        }
        float f = 0.0f;
        Font font2 = this;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.isCJK && c >= '\u4e00' && c <= '\u9fcc' || !this.isCJK && this.unicodeToGID[c] != 0) {
                if (this != font2) {
                    f += font2.stringWidth(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    font2 = this;
                }
            } else if (font != font2) {
                f += font2.stringWidth(stringBuilder.toString());
                stringBuilder.setLength(0);
                font2 = font;
            }
            stringBuilder.append(c);
        }
        return f += font2.stringWidth(stringBuilder.toString());
    }

    protected boolean isVowel(char c) {
        return c >= '\u0904' && c <= '\u0914';
    }

    protected boolean isConsonant(char c) {
        return c >= '\u0915' && c <= '\u0939';
    }

    protected boolean isDependentVowel(char c) {
        return c >= '\u093e' && c <= '\u094c';
    }

    protected boolean isVowelSignI(char c) {
        return c == '\u093f';
    }

    protected boolean isVirama(char c) {
        return c == '\u094d';
    }

    protected int getHalfForm(char c, char c2) {
        return this.halfForm[16 * (c - 2325) + (c2 - 2366)];
    }
}

