/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Font;
import com.pdfjet.PDF;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FastFont {
    FastFont() {
    }

    protected static void register(PDF pDF, Font font, InputStream inputStream) throws Exception {
        int n;
        int n2 = inputStream.read();
        byte[] byArray = new byte[n2];
        inputStream.read(byArray, 0, n2);
        font.name = new String(byArray);
        font.unitsPerEm = FastFont.getInt32(inputStream);
        font.bBoxLLx = FastFont.getInt32(inputStream);
        font.bBoxLLy = FastFont.getInt32(inputStream);
        font.bBoxURx = FastFont.getInt32(inputStream);
        font.bBoxURy = FastFont.getInt32(inputStream);
        font.ascent = FastFont.getInt32(inputStream);
        font.descent = FastFont.getInt32(inputStream);
        font.firstChar = FastFont.getInt32(inputStream);
        font.lastChar = FastFont.getInt32(inputStream);
        font.capHeight = FastFont.getInt32(inputStream);
        font.underlinePosition = FastFont.getInt32(inputStream);
        font.underlineThickness = FastFont.getInt32(inputStream);
        n2 = FastFont.getInt32(inputStream);
        font.advanceWidth = new int[n2];
        for (n = 0; n < n2; ++n) {
            font.advanceWidth[n] = FastFont.getInt16(inputStream);
        }
        n2 = FastFont.getInt32(inputStream);
        font.glyphWidth = new int[n2];
        for (n = 0; n < n2; ++n) {
            font.glyphWidth[n] = FastFont.getInt16(inputStream);
        }
        n2 = FastFont.getInt32(inputStream);
        font.unicodeToGID = new int[n2];
        for (n = 0; n < n2; ++n) {
            font.unicodeToGID[n] = FastFont.getInt16(inputStream);
        }
        font.uncompressed_size = FastFont.getInt32(inputStream);
        font.compressed_size = FastFont.getInt32(inputStream);
        FastFont.embedFontFile(pDF, font, inputStream);
        FastFont.addFontDescriptorObject(pDF, font);
        FastFont.addCIDFontDictionaryObject(pDF, font);
        FastFont.addToUnicodeCMapObject(pDF, font);
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Font\n");
        pDF.append("/Subtype /Type0\n");
        pDF.append("/BaseFont /");
        pDF.append(font.name);
        pDF.append('\n');
        pDF.append("/Encoding /Identity-H\n");
        pDF.append("/DescendantFonts [");
        pDF.append(font.getCidFontDictObjNumber());
        pDF.append(" 0 R]\n");
        pDF.append("/ToUnicode ");
        pDF.append(font.getToUnicodeCMapObjNumber());
        pDF.append(" 0 R\n");
        pDF.append(">>\n");
        pDF.endobj();
        font.objNumber = pDF.objNumber;
    }

    private static void embedFontFile(PDF pDF, Font font, InputStream inputStream) throws Exception {
        int n;
        for (int i = 0; i < pDF.fonts.size(); ++i) {
            Font font2 = pDF.fonts.get(i);
            if (!font2.name.equals(font.name) || font2.fileObjNumber == -1) continue;
            font.fileObjNumber = font2.fileObjNumber;
            return;
        }
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Filter /FlateDecode\n");
        pDF.append("/Length ");
        pDF.append(font.compressed_size);
        pDF.append("\n");
        pDF.append("/Length1 ");
        pDF.append(font.uncompressed_size);
        pDF.append('\n');
        pDF.append(">>\n");
        pDF.append("stream\n");
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            pDF.append(byArray, 0, n);
        }
        inputStream.close();
        pDF.append("\nendstream\n");
        pDF.endobj();
        font.fileObjNumber = pDF.objNumber;
    }

    private static void addFontDescriptorObject(PDF pDF, Font font) throws Exception {
        float f = 1000.0f / (float)font.unitsPerEm;
        for (int i = 0; i < pDF.fonts.size(); ++i) {
            Font font2 = pDF.fonts.get(i);
            if (!font2.name.equals(font.name) || font2.getFontDescriptorObjNumber() == -1) continue;
            font.setFontDescriptorObjNumber(font2.getFontDescriptorObjNumber());
            return;
        }
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /FontDescriptor\n");
        pDF.append("/FontName /");
        pDF.append(font.name);
        pDF.append('\n');
        pDF.append("/FontFile2 ");
        pDF.append(font.fileObjNumber);
        pDF.append(" 0 R\n");
        pDF.append("/Flags 32\n");
        pDF.append("/FontBBox [");
        pDF.append(font.bBoxLLx * f);
        pDF.append(' ');
        pDF.append(font.bBoxLLy * f);
        pDF.append(' ');
        pDF.append(font.bBoxURx * f);
        pDF.append(' ');
        pDF.append(font.bBoxURy * f);
        pDF.append("]\n");
        pDF.append("/Ascent ");
        pDF.append(font.ascent * f);
        pDF.append('\n');
        pDF.append("/Descent ");
        pDF.append(font.descent * f);
        pDF.append('\n');
        pDF.append("/ItalicAngle 0\n");
        pDF.append("/CapHeight ");
        pDF.append(font.capHeight * f);
        pDF.append('\n');
        pDF.append("/StemV 79\n");
        pDF.append(">>\n");
        pDF.endobj();
        font.setFontDescriptorObjNumber(pDF.objNumber);
    }

    private static void addToUnicodeCMapObject(PDF pDF, Font font) throws Exception {
        Object object;
        for (int i = 0; i < pDF.fonts.size(); ++i) {
            object = pDF.fonts.get(i);
            if (!((Font)object).name.equals(font.name) || ((Font)object).getToUnicodeCMapObjNumber() == -1) continue;
            font.setToUnicodeCMapObjNumber(((Font)object).getToUnicodeCMapObjNumber());
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/CIDInit /ProcSet findresource begin\n");
        stringBuilder.append("12 dict begin\n");
        stringBuilder.append("begincmap\n");
        stringBuilder.append("/CIDSystemInfo <</Registry (Adobe) /Ordering (Identity) /Supplement 0>> def\n");
        stringBuilder.append("/CMapName /Adobe-Identity def\n");
        stringBuilder.append("/CMapType 2 def\n");
        stringBuilder.append("1 begincodespacerange\n");
        stringBuilder.append("<0000> <FFFF>\n");
        stringBuilder.append("endcodespacerange\n");
        object = new ArrayList();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i <= 65535; ++i) {
            int n = font.unicodeToGID[i];
            if (n <= 0) continue;
            stringBuilder2.append('<');
            stringBuilder2.append(FastFont.toHexString(n));
            stringBuilder2.append("> <");
            stringBuilder2.append(FastFont.toHexString(i));
            stringBuilder2.append(">\n");
            object.add(stringBuilder2.toString());
            stringBuilder2.setLength(0);
            if (object.size() != 100) continue;
            FastFont.writeListToBuffer((List<String>)object, stringBuilder);
        }
        if (object.size() > 0) {
            FastFont.writeListToBuffer((List<String>)object, stringBuilder);
        }
        stringBuilder.append("endcmap\n");
        stringBuilder.append("CMapName currentdict /CMap defineresource pop\n");
        stringBuilder.append("end\nend");
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Length ");
        pDF.append(stringBuilder.length());
        pDF.append("\n");
        pDF.append(">>\n");
        pDF.append("stream\n");
        pDF.append(stringBuilder.toString());
        pDF.append("\nendstream\n");
        pDF.endobj();
        font.setToUnicodeCMapObjNumber(pDF.objNumber);
    }

    private static void addCIDFontDictionaryObject(PDF pDF, Font font) throws Exception {
        int n;
        for (n = 0; n < pDF.fonts.size(); ++n) {
            Font font2 = pDF.fonts.get(n);
            if (!font2.name.equals(font.name) || font2.getCidFontDictObjNumber() == -1) continue;
            font.setCidFontDictObjNumber(font2.getCidFontDictObjNumber());
            return;
        }
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Font\n");
        pDF.append("/Subtype /CIDFontType2\n");
        pDF.append("/BaseFont /");
        pDF.append(font.name);
        pDF.append('\n');
        pDF.append("/CIDSystemInfo <</Registry (Adobe) /Ordering (Identity) /Supplement 0>>\n");
        pDF.append("/FontDescriptor ");
        pDF.append(font.getFontDescriptorObjNumber());
        pDF.append(" 0 R\n");
        pDF.append("/DW ");
        pDF.append((int)(1000.0f / (float)font.unitsPerEm * (float)font.advanceWidth[0]));
        pDF.append('\n');
        pDF.append("/W [0[\n");
        for (n = 0; n < font.advanceWidth.length; ++n) {
            pDF.append((int)(1000.0f / (float)font.unitsPerEm * (float)font.advanceWidth[n]));
            if ((n + 1) % 10 == 0) {
                pDF.append('\n');
                continue;
            }
            pDF.append(' ');
        }
        pDF.append("]]\n");
        pDF.append("/CIDToGIDMap /Identity\n");
        pDF.append(">>\n");
        pDF.endobj();
        font.setCidFontDictObjNumber(pDF.objNumber);
    }

    private static String toHexString(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            return "000" + string;
        }
        if (string.length() == 2) {
            return "00" + string;
        }
        if (string.length() == 3) {
            return "0" + string;
        }
        return string;
    }

    private static void writeListToBuffer(List<String> list, StringBuilder stringBuilder) {
        stringBuilder.append(list.size());
        stringBuilder.append(" beginbfchar\n");
        for (String string : list) {
            stringBuilder.append(string);
        }
        stringBuilder.append("endbfchar\n");
        list.clear();
    }

    private static int getInt16(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[2];
        inputStream.read(byArray, 0, 2);
        int n = 0;
        n |= byArray[0] & 0xFF;
        n <<= 8;
        return n |= byArray[1] & 0xFF;
    }

    private static int getInt32(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4];
        inputStream.read(byArray, 0, 4);
        int n = 0;
        n |= byArray[0] & 0xFF;
        n <<= 8;
        n |= byArray[1] & 0xFF;
        n <<= 8;
        n |= byArray[2] & 0xFF;
        n <<= 8;
        return n |= byArray[3] & 0xFF;
    }
}

