/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Font;
import com.pdfjet.Operation;
import com.pdfjet.Page;
import com.pdfjet.Point;
import com.pdfjet.Round;
import java.text.NumberFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart {
    private float w = 300.0f;
    private float h = 200.0f;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float x3;
    private float y3;
    private float x4;
    private float y4;
    private float x5;
    private float y5;
    private float x6;
    private float y6;
    private float x7;
    private float y7;
    private float x8;
    private float y8;
    private float x_max = Float.MIN_VALUE;
    private float x_min = Float.MAX_VALUE;
    private float y_max = Float.MIN_VALUE;
    private float y_min = Float.MAX_VALUE;
    private int x_axis_grid_lines = 0;
    private int y_axis_grid_lines = 0;
    private String title = "";
    private String x_axis_title = "";
    private String y_axis_title = "";
    private boolean drawXAxisLabels = true;
    private boolean drawYAxisLabels = true;
    private float h_grid_line_width;
    private float v_grid_line_width;
    private String h_grid_line_pattern = "[1 1] 0";
    private String v_grid_line_pattern = "[1 1] 0";
    private float chart_border_width = 0.3f;
    private float inner_border_width = 0.3f;
    private NumberFormat nf = null;
    private int minFractionDigits = 2;
    private int maxFractionDigits = 2;
    private Font f1 = null;
    private Font f2 = null;
    private List<List<Point>> chartData = null;

    public Chart(Font font, Font font2) {
        this.f1 = font;
        this.f2 = font2;
        this.nf = NumberFormat.getInstance();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setXAxisTitle(String string) {
        this.x_axis_title = string;
    }

    public void setYAxisTitle(String string) {
        this.y_axis_title = string;
    }

    public void setData(List<List<Point>> list) {
        this.chartData = list;
    }

    public List<List<Point>> getData() {
        return this.chartData;
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x1 = f;
        this.y1 = f2;
    }

    public void setSize(double d, double d2) {
        this.setSize((float)d, (float)d2);
    }

    public void setSize(float f, float f2) {
        this.w = f;
        this.h = f2;
    }

    public void setMinimumFractionDigits(int n) {
        this.minFractionDigits = n;
    }

    public void setMaximumFractionDigits(int n) {
        this.maxFractionDigits = n;
    }

    public float slope(List<Point> list) {
        return this.covar(list) / this.devsq(list) * (float)(list.size() - 1);
    }

    public float intercept(List<Point> list, double d) {
        return this.intercept(list, (float)d);
    }

    public float intercept(List<Point> list, float f) {
        float[] fArray = this.mean(list);
        return fArray[1] - f * fArray[0];
    }

    public void setDrawXAxisLabels(boolean bl) {
        this.drawXAxisLabels = bl;
    }

    public void setDrawYAxisLabels(boolean bl) {
        this.drawYAxisLabels = bl;
    }

    public void drawOn(Page page) throws Exception {
        this.nf.setMinimumFractionDigits(this.minFractionDigits);
        this.nf.setMaximumFractionDigits(this.maxFractionDigits);
        this.x2 = this.x1 + this.w;
        this.y2 = this.y1;
        this.x3 = this.x2;
        this.y3 = this.y1 + this.h;
        this.x4 = this.x1;
        this.y4 = this.y3;
        this.setMinAndMaxChartValues();
        this.roundXAxisMinAndMaxValues();
        this.roundYAxisMinAndMaxValues();
        page.drawString(this.f1, this.title, this.x1 + (this.w - this.f1.stringWidth(this.title)) / 2.0f, this.y1 + 1.5f * this.f1.body_height);
        float f = 2.5f * this.f1.body_height;
        float f2 = this.getLongestAxisYLabelWidth() + 2.0f * this.f2.body_height;
        float f3 = 2.0f * this.f2.body_height;
        float f4 = 2.5f * this.f2.body_height;
        this.x5 = this.x1 + f2;
        this.y5 = this.y1 + f;
        this.x6 = this.x2 - f3;
        this.y6 = this.y5;
        this.x7 = this.x6;
        this.y7 = this.y3 - f4;
        this.x8 = this.x5;
        this.y8 = this.y7;
        this.drawChartBorder(page);
        this.drawInnerBorder(page);
        this.drawHorizontalGridLines(page);
        this.drawVerticalGridLines(page);
        if (this.drawXAxisLabels) {
            this.drawXAxisLabels(page);
        }
        if (this.drawYAxisLabels) {
            this.drawYAxisLabels(page);
        }
        for (int i = 0; i < this.chartData.size(); ++i) {
            List<Point> list = this.chartData.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Point point = list.get(j);
                point.x = this.x5 + (point.x - this.x_min) * (this.x6 - this.x5) / (this.x_max - this.x_min);
                point.y = this.y8 - (point.y - this.y_min) * (this.y8 - this.y5) / (this.y_max - this.y_min);
                if (point.getURIAction() == null) continue;
                page.addAnnotation(new Annotation(point.getURIAction(), null, point.x - point.r, page.height - (point.y - point.r), point.x + point.r, page.height - (point.y + point.r), null, null, null));
            }
        }
        this.drawPathsAndPoints(page, this.chartData);
        page.setBrushColor(0);
        page.setTextDirection(90);
        page.drawString(this.f2, this.y_axis_title, this.x1 + this.f2.body_height, this.y8 - (this.y8 - this.y5 - this.f2.stringWidth(this.y_axis_title)) / 2.0f);
        page.setTextDirection(0);
        page.drawString(this.f2, this.x_axis_title, this.x5 + (this.x6 - this.x5 - this.f2.stringWidth(this.x_axis_title)) / 2.0f, this.y4 - this.f2.body_height / 2.0f);
        page.setDefaultLineWidth();
        page.setDefaultLinePattern();
        page.setPenColor(0);
    }

    private float getLongestAxisYLabelWidth() {
        float f = this.f2.stringWidth(this.nf.format(this.y_min) + "0");
        float f2 = this.f2.stringWidth(this.nf.format(this.y_max) + "0");
        if (f2 > f) {
            return f2;
        }
        return f;
    }

    private void setMinAndMaxChartValues() {
        for (int i = 0; i < this.chartData.size(); ++i) {
            List<Point> list = this.chartData.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Point point = list.get(j);
                if (point.x < this.x_min) {
                    this.x_min = point.x;
                }
                if (point.x > this.x_max) {
                    this.x_max = point.x;
                }
                if (point.y < this.y_min) {
                    this.y_min = point.y;
                }
                if (!(point.y > this.y_max)) continue;
                this.y_max = point.y;
            }
        }
    }

    private void roundXAxisMinAndMaxValues() {
        Round round = this.roundMaxAndMinValues(this.x_max, this.x_min);
        this.x_max = round.max_value;
        this.x_min = round.min_value;
        this.x_axis_grid_lines = round.num_of_grid_lines;
    }

    private void roundYAxisMinAndMaxValues() {
        Round round = this.roundMaxAndMinValues(this.y_max, this.y_min);
        this.y_max = round.max_value;
        this.y_min = round.min_value;
        this.y_axis_grid_lines = round.num_of_grid_lines;
    }

    private void drawChartBorder(Page page) throws Exception {
        page.setPenWidth(this.chart_border_width);
        page.setPenColor(0);
        page.moveTo(this.x1, this.y1);
        page.lineTo(this.x2, this.y2);
        page.lineTo(this.x3, this.y3);
        page.lineTo(this.x4, this.y4);
        page.closePath();
        page.strokePath();
    }

    private void drawInnerBorder(Page page) throws Exception {
        page.setPenWidth(this.inner_border_width);
        page.setPenColor(0);
        page.moveTo(this.x5, this.y5);
        page.lineTo(this.x6, this.y6);
        page.lineTo(this.x7, this.y7);
        page.lineTo(this.x8, this.y8);
        page.closePath();
        page.strokePath();
    }

    private void drawHorizontalGridLines(Page page) throws Exception {
        page.setPenWidth(this.h_grid_line_width);
        page.setPenColor(0);
        page.setLinePattern(this.h_grid_line_pattern);
        float f = this.x8;
        float f2 = this.y8;
        float f3 = (this.y8 - this.y5) / (float)this.y_axis_grid_lines;
        for (int i = 0; i < this.y_axis_grid_lines; ++i) {
            page.drawLine(f, f2, this.x6, f2);
            f2 -= f3;
        }
    }

    private void drawVerticalGridLines(Page page) throws Exception {
        page.setPenWidth(this.v_grid_line_width);
        page.setPenColor(0);
        page.setLinePattern(this.v_grid_line_pattern);
        float f = this.x5;
        float f2 = this.y5;
        float f3 = (this.x6 - this.x5) / (float)this.x_axis_grid_lines;
        for (int i = 0; i < this.x_axis_grid_lines; ++i) {
            page.drawLine(f, f2, f, this.y8);
            f += f3;
        }
    }

    private void drawXAxisLabels(Page page) throws Exception {
        float f = this.x5;
        float f2 = this.y8 + this.f2.body_height;
        float f3 = (this.x6 - this.x5) / (float)this.x_axis_grid_lines;
        page.setBrushColor(0);
        for (int i = 0; i < this.x_axis_grid_lines + 1; ++i) {
            String string = this.nf.format(this.x_min + (this.x_max - this.x_min) / (float)this.x_axis_grid_lines * (float)i);
            page.drawString(this.f2, string, f - this.f2.stringWidth(string) / 2.0f, f2);
            f += f3;
        }
    }

    private void drawYAxisLabels(Page page) throws Exception {
        float f = this.x5 - this.getLongestAxisYLabelWidth();
        float f2 = this.y8 + this.f2.ascent / 3.0f;
        float f3 = (this.y8 - this.y5) / (float)this.y_axis_grid_lines;
        page.setBrushColor(0);
        for (int i = 0; i < this.y_axis_grid_lines + 1; ++i) {
            String string = this.nf.format(this.y_min + (this.y_max - this.y_min) / (float)this.y_axis_grid_lines * (float)i);
            page.drawString(this.f2, string, f, f2);
            f2 -= f3;
        }
    }

    private void drawPathsAndPoints(Page page, List<List<Point>> list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            List<Point> list2 = list.get(i);
            Point point = list2.get(0);
            if (point.isStartOfPath) {
                page.setPenColor(point.color);
                page.setPenWidth(point.lineWidth);
                page.setLinePattern(point.linePattern);
                page.drawPath(list2, Operation.STROKE);
                if (point.getText() != null) {
                    page.setBrushColor(point.getTextColor());
                    page.setTextDirection(point.getTextDirection());
                    page.drawString(this.f2, point.getText(), point.x, point.y);
                }
            }
            for (int j = 0; j < list2.size(); ++j) {
                point = list2.get(j);
                if (point.getShape() == -1) continue;
                page.setPenWidth(point.lineWidth);
                page.setLinePattern(point.linePattern);
                page.setPenColor(point.color);
                page.setBrushColor(point.color);
                page.drawPoint(point);
            }
        }
    }

    private Round roundMaxAndMinValues(float f, float f2) {
        int n;
        f = (f *= (float)Math.pow(10.0, -(n = (int)Math.floor(Math.log(f) / Math.log(10.0))))) > 9.0f ? 10.0f : (f > 8.0f ? 9.0f : (f > 7.0f ? 8.0f : (f > 6.0f ? 7.0f : (f > 5.0f ? 6.0f : (f > 4.0f ? 5.0f : (f > 3.5f ? 4.0f : (f > 3.0f ? 3.5f : (f > 2.5f ? 3.0f : (f > 2.0f ? 2.5f : (f > 1.75f ? 2.0f : (f > 1.5f ? 1.75f : (f > 1.25f ? 1.5f : (f > 1.0f ? 1.25f : 1.0f)))))))))))));
        Round round = new Round();
        if (f == 10.0f) {
            round.num_of_grid_lines = 10;
        } else if (f == 9.0f) {
            round.num_of_grid_lines = 9;
        } else if (f == 8.0f) {
            round.num_of_grid_lines = 8;
        } else if (f == 7.0f) {
            round.num_of_grid_lines = 7;
        } else if (f == 6.0f) {
            round.num_of_grid_lines = 6;
        } else if (f == 5.0f) {
            round.num_of_grid_lines = 5;
        } else if (f == 4.0f) {
            round.num_of_grid_lines = 8;
        } else if (f == 3.5f) {
            round.num_of_grid_lines = 7;
        } else if (f == 3.0f) {
            round.num_of_grid_lines = 6;
        } else if (f == 2.5f) {
            round.num_of_grid_lines = 5;
        } else if (f == 2.0f) {
            round.num_of_grid_lines = 8;
        } else if (f == 1.75f) {
            round.num_of_grid_lines = 7;
        } else if (f == 1.5f) {
            round.num_of_grid_lines = 6;
        } else if (f == 1.25f) {
            round.num_of_grid_lines = 5;
        } else if (f == 1.0f) {
            round.num_of_grid_lines = 10;
        }
        round.max_value = f * (float)Math.pow(10.0, n);
        float f3 = round.max_value / (float)round.num_of_grid_lines;
        float f4 = round.max_value;
        round.num_of_grid_lines = 0;
        do {
            ++round.num_of_grid_lines;
        } while (!((f4 -= f3) <= f2));
        round.min_value = f4;
        return round;
    }

    private float[] mean(List<Point> list) {
        float[] fArray = new float[2];
        for (int i = 0; i < list.size(); ++i) {
            Point point = list.get(i);
            fArray[0] = fArray[0] + point.x;
            fArray[1] = fArray[1] + point.y;
        }
        fArray[0] = fArray[0] / (float)(list.size() - 1);
        fArray[1] = fArray[1] / (float)(list.size() - 1);
        return fArray;
    }

    private float covar(List<Point> list) {
        float f = 0.0f;
        float[] fArray = this.mean(list);
        for (int i = 0; i < list.size(); ++i) {
            Point point = list.get(i);
            f += (point.x - fArray[0]) * (point.y - fArray[1]);
        }
        return f / (float)(list.size() - 1);
    }

    private float devsq(List<Point> list) {
        float f = 0.0f;
        float[] fArray = this.mean(list);
        for (int i = 0; i < list.size(); ++i) {
            Point point = list.get(i);
            f = (float)((double)f + Math.pow(point.x - fArray[0], 2.0));
        }
        return f;
    }
}

